/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.common.lib.types.OIDCGrantType;
import org.apache.syncope.common.lib.types.OIDCResponseType;
import org.apache.syncope.common.lib.types.OIDCTokenEncryptionAlg;
import org.apache.syncope.common.lib.types.OIDCTokenSigningAlg;
import org.apache.syncope.common.lib.wa.WAClientApp;
import org.apache.syncope.wa.starter.mapping.AbstractClientAppMapper;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProxyGrantingTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.apereo.cas.support.oauth.services.DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.DefaultRegisteredServiceOAuthDeviceTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.DefaultRegisteredServiceOAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthAccessTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthDeviceTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthRefreshTokenExpirationPolicy;

public class OIDCRPClientAppTOMapper
extends AbstractClientAppMapper {
    @Override
    public boolean supports(ClientAppTO clientApp) {
        return OIDCRPClientAppTO.class.equals(clientApp.getClass());
    }

    @Override
    public RegisteredService map(WAClientApp clientApp, RegisteredServiceAuthenticationPolicy authPolicy, RegisteredServiceMultifactorPolicy mfaPolicy, RegisteredServiceAccessStrategy accessStrategy, RegisteredServiceAttributeReleasePolicy attributeReleasePolicy, RegisteredServiceTicketGrantingTicketExpirationPolicy tgtExpirationPolicy, RegisteredServiceServiceTicketExpirationPolicy stExpirationPolicy, RegisteredServiceProxyGrantingTicketExpirationPolicy tgtProxyExpirationPolicy, RegisteredServiceProxyTicketExpirationPolicy stProxyExpirationPolicy) {
        OidcRegisteredService service;
        OIDCRPClientAppTO rp;
        block13: {
            block12: {
                rp = (OIDCRPClientAppTO)OIDCRPClientAppTO.class.cast(clientApp.getClientAppTO());
                service = new OidcRegisteredService();
                this.setCommon((BaseWebBasedRegisteredService)service, (ClientAppTO)rp);
                service.setServiceId(rp.getRedirectUris().stream().filter(Objects::nonNull).collect(Collectors.joining("|")));
                service.setClientId(rp.getClientId());
                service.setClientSecret(rp.getClientSecret());
                service.setIdTokenIssuer(rp.getIdTokenIssuer());
                service.setSignIdToken(rp.isSignIdToken());
                if (service.isSignIdToken()) {
                    Optional.ofNullable(rp.getIdTokenSigningAlg()).filter(v -> v != OIDCTokenSigningAlg.none).ifPresent(v -> service.setIdTokenSigningAlg(v.name()));
                } else {
                    service.setIdTokenSigningAlg(OIDCTokenSigningAlg.none.name());
                }
                service.setEncryptIdToken(rp.isEncryptIdToken());
                if (service.isEncryptIdToken()) {
                    Optional.ofNullable(rp.getIdTokenEncryptionAlg()).filter(v -> v != OIDCTokenEncryptionAlg.none).ifPresent(v -> service.setIdTokenEncryptionAlg(v.getExternalForm()));
                    Optional.ofNullable(rp.getIdTokenEncryptionEncoding()).ifPresent(v -> service.setIdTokenEncryptionEncoding(v.getExternalForm()));
                } else {
                    service.setIdTokenEncryptionAlg(OIDCTokenEncryptionAlg.none.getExternalForm());
                }
                Optional.ofNullable(rp.getUserInfoSigningAlg()).ifPresent(v -> service.setUserInfoSigningAlg(v.name()));
                Optional.ofNullable(rp.getUserInfoEncryptedResponseAlg()).ifPresent(v -> service.setUserInfoEncryptedResponseAlg(v.getExternalForm()));
                Optional.ofNullable(rp.getUserInfoEncryptedResponseEncoding()).ifPresent(v -> service.setUserInfoEncryptedResponseEncoding(v.getExternalForm()));
                service.setJwtAccessToken(rp.isJwtAccessToken());
                service.setBypassApprovalPrompt(rp.isBypassApprovalPrompt());
                service.setGenerateRefreshToken(rp.isGenerateRefreshToken());
                if (StringUtils.isNotBlank((CharSequence)rp.getJwksUri())) {
                    service.setJwks(rp.getJwksUri());
                } else {
                    service.setJwks(rp.getJwks());
                }
                Optional.ofNullable(rp.getSubjectType()).ifPresent(v -> service.setSubjectType(v.getExternalForm()));
                Optional.ofNullable(rp.getApplicationType()).ifPresent(v -> service.setApplicationType(v.getExternalForm()));
                service.setSupportedGrantTypes(rp.getSupportedGrantTypes().stream().map(OIDCGrantType::getExternalForm).collect(Collectors.toSet()));
                service.setSupportedResponseTypes(rp.getSupportedResponseTypes().stream().map(OIDCResponseType::getExternalForm).collect(Collectors.toSet()));
                service.setLogoutUrl(rp.getLogoutUri());
                service.setTokenEndpointAuthenticationMethod(rp.getTokenEndpointAuthenticationMethod().name());
                service.setScopes(new HashSet(rp.getScopes()));
                if (attributeReleasePolicy instanceof OidcCustomScopeAttributeReleasePolicy) break block12;
                if (!(attributeReleasePolicy instanceof ChainingAttributeReleasePolicy)) break block13;
                ChainingAttributeReleasePolicy chain = (ChainingAttributeReleasePolicy)attributeReleasePolicy;
                if (!chain.getPolicies().stream().anyMatch(OidcCustomScopeAttributeReleasePolicy.class::isInstance)) break block13;
            }
            service.getScopes().add("syncope");
        }
        this.setPolicies((BaseWebBasedRegisteredService)service, authPolicy, mfaPolicy, accessStrategy, attributeReleasePolicy, tgtExpirationPolicy, stExpirationPolicy, tgtProxyExpirationPolicy, stProxyExpirationPolicy);
        if (rp.getAccessTokenMaxTimeToLive() != null || rp.getAccessTokenTimeToKill() != null || rp.getAccessTokenMaxActiveTokens() != null) {
            DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy accessTokenExpirationPolicy = new DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy();
            Optional.ofNullable(rp.getAccessTokenMaxTimeToLive()).ifPresent(arg_0 -> ((DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy)accessTokenExpirationPolicy).setMaxTimeToLive(arg_0));
            Optional.ofNullable(rp.getAccessTokenTimeToKill()).ifPresent(arg_0 -> ((DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy)accessTokenExpirationPolicy).setTimeToKill(arg_0));
            Optional.ofNullable(rp.getAccessTokenMaxActiveTokens()).ifPresent(arg_0 -> ((DefaultRegisteredServiceOAuthAccessTokenExpirationPolicy)accessTokenExpirationPolicy).setMaxActiveTokens(arg_0));
            service.setAccessTokenExpirationPolicy((RegisteredServiceOAuthAccessTokenExpirationPolicy)accessTokenExpirationPolicy);
        }
        if (rp.getRefreshTokenTimeToKill() != null || rp.getRefreshTokenMaxActiveTokens() != null) {
            DefaultRegisteredServiceOAuthRefreshTokenExpirationPolicy refreshTokenExpirationPolicy = new DefaultRegisteredServiceOAuthRefreshTokenExpirationPolicy();
            Optional.ofNullable(rp.getRefreshTokenTimeToKill()).ifPresent(arg_0 -> ((DefaultRegisteredServiceOAuthRefreshTokenExpirationPolicy)refreshTokenExpirationPolicy).setTimeToKill(arg_0));
            Optional.ofNullable(rp.getRefreshTokenMaxActiveTokens()).ifPresent(arg_0 -> ((DefaultRegisteredServiceOAuthRefreshTokenExpirationPolicy)refreshTokenExpirationPolicy).setMaxActiveTokens(arg_0));
            service.setRefreshTokenExpirationPolicy((RegisteredServiceOAuthRefreshTokenExpirationPolicy)refreshTokenExpirationPolicy);
        }
        if (rp.getDeviceTokenTimeToKill() != null) {
            DefaultRegisteredServiceOAuthDeviceTokenExpirationPolicy deviceTokenExpirationPolicy = new DefaultRegisteredServiceOAuthDeviceTokenExpirationPolicy();
            deviceTokenExpirationPolicy.setTimeToKill(rp.getDeviceTokenTimeToKill());
            service.setDeviceTokenExpirationPolicy((RegisteredServiceOAuthDeviceTokenExpirationPolicy)deviceTokenExpirationPolicy);
        }
        return service;
    }
}

