/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import kafka.utils.Log4jController;
import kafka.utils.Logging;
import kafka.utils.LoggingTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005U2Aa\u0002\u0005\u0001\u001b!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C\u00019!)Q\u0006\u0001C\u00019!)q\u0006\u0001C\u00019!)\u0011\u0007\u0001C\u00019!)1\u0007\u0001C\u00019\tYAj\\4hS:<G+Z:u\u0015\tI!\"A\u0003vi&d7OC\u0001\f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0011%\u0011q\u0003\u0003\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u0016\u0001\u0005!B/Z:u)f\u0004Xm\u00144HKRdunZ4feN$\u0012!\b\t\u0003\u001fyI!a\b\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0005\u0002\"AI\u0016\u000e\u0003\rR!\u0001J\u0013\u0002\u0007\u0005\u0004\u0018N\u0003\u0002'O\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0015*\u0003\u0015QWO\\5u\u0015\u0005Q\u0013aA8sO&\u0011Af\t\u0002\u0005)\u0016\u001cH/A\u0010uKN$Hj\\45U\u000e{g\u000e\u001e:pY2,'/S:SK\u001eL7\u000f^3sK\u0012D#aA\u0011\u0002'Q,7\u000f\u001e'pO:\u000bW.Z(wKJ\u0014\u0018\u000eZ3)\u0005\u0011\t\u0013a\u0003;fgRdun\u001a(b[\u0016D#!B\u0011\u00023Q,7\u000f\u001e'pO\u001e,'\u000fT3wK2L5OU3t_24X\r\u001a\u0015\u0003\r\u0005\u0002")
public class LoggingTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void testTypeOfGetLoggers() {
        Log4jController log4jController = new Log4jController();
        Assertions.assertEquals(ArrayList.class, log4jController.getLoggers().getClass());
    }

    @Test
    public void testLog4jControllerIsRegistered() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName log4jControllerName = ObjectName.getInstance("kafka:type=kafka.Log4jController");
        Assertions.assertTrue((boolean)mbs.isRegistered(log4jControllerName), (String)"kafka.utils.Log4jController is not registered");
        ObjectInstance instance = mbs.getObjectInstance(log4jControllerName);
        Assertions.assertEquals((Object)"kafka.utils.Log4jController", (Object)instance.getClassName());
    }

    @Test
    public void testLogNameOverride() {
        String overriddenLogName = "OverriddenLogName";
        public class Kafka_utils_LoggingTest$TestLogging$1
        implements Logging {
            private final String overriddenLogName;
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Logging.debug$((Logging)this, msg, e);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Logging.warn$((Logging)this, msg, e);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Logging.error$((Logging)this, msg, e);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public Logger log() {
                return this.logger();
            }

            public String loggerName() {
                return this.overriddenLogName;
            }

            public Kafka_utils_LoggingTest$TestLogging$1(LoggingTest $outer, String overriddenLogName) {
                this.overriddenLogName = overriddenLogName;
            }
        }
        Kafka_utils_LoggingTest$TestLogging$1 logging = new Kafka_utils_LoggingTest$TestLogging$1(null, overriddenLogName);
        Assertions.assertEquals((Object)overriddenLogName, (Object)logging.logger().underlying().getName());
    }

    @Test
    public void testLogName() {
        public class Kafka_utils_LoggingTest$TestLogging$2
        implements Logging {
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Logging.debug$((Logging)this, msg, e);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Logging.warn$((Logging)this, msg, e);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Logging.error$((Logging)this, msg, e);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public Logger log() {
                return this.logger();
            }

            public Kafka_utils_LoggingTest$TestLogging$2(LoggingTest $outer) {
            }
        }
        Kafka_utils_LoggingTest$TestLogging$2 logging = new Kafka_utils_LoggingTest$TestLogging$2(null);
        Assertions.assertEquals((Object)logging.getClass().getName(), (Object)logging.logger().underlying().getName());
    }

    @Test
    public void testLoggerLevelIsResolved() {
        Log4jController controller = new Log4jController();
        String previousLevel = controller.getLogLevel("kafka");
        try {
            controller.setLogLevel("kafka", "TRACE");
            LoggerFactory.getLogger((String)"kafka.utils.Log4jControllerTest").trace("test");
            Assertions.assertEquals((Object)"TRACE", (Object)controller.getLogLevel("kafka"));
            Assertions.assertEquals((Object)"TRACE", (Object)controller.getLogLevel("kafka.utils.Log4jControllerTest"));
            Assertions.assertTrue((boolean)controller.getLoggers().contains("kafka=TRACE"));
            Assertions.assertTrue((boolean)controller.getLoggers().contains("kafka.utils.Log4jControllerTest=TRACE"));
        }
        finally {
            controller.setLogLevel("kafka", previousLevel);
        }
    }
}

