/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import java.util.List;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.group.GroupTypeExtension;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyTypeClassRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTypeClass;

public class AnyTypeClassRepoExtImpl
implements AnyTypeClassRepoExt {
    protected final AnyTypeDAO anyTypeDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final GroupDAO groupDAO;
    protected final RelationshipTypeDAO relationshipTypeDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityManager entityManager;

    public AnyTypeClassRepoExtImpl(AnyTypeDAO anyTypeDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, GroupDAO groupDAO, RelationshipTypeDAO relationshipTypeDAO, ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        this.anyTypeDAO = anyTypeDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.groupDAO = groupDAO;
        this.relationshipTypeDAO = relationshipTypeDAO;
        this.resourceDAO = resourceDAO;
        this.entityManager = entityManager;
    }

    @Override
    public AnyTypeClass save(AnyTypeClass anyTypeClass) {
        AnyTypeClass merge = (AnyTypeClass)this.entityManager.merge((Object)anyTypeClass);
        for (PlainSchema schema : merge.getPlainSchemas()) {
            schema.setAnyTypeClass(merge);
        }
        for (PlainSchema schema : merge.getDerSchemas()) {
            schema.setAnyTypeClass(merge);
        }
        return merge;
    }

    @Override
    public void deleteById(String key) {
        AnyTypeClass anyTypeClass = (AnyTypeClass)this.entityManager.find(JPAAnyTypeClass.class, (Object)key);
        if (anyTypeClass == null) {
            return;
        }
        for (PlainSchema schema : this.plainSchemaDAO.findByAnyTypeClasses(List.of(anyTypeClass))) {
            schema.setAnyTypeClass(null);
        }
        for (PlainSchema schema : this.derSchemaDAO.findByAnyTypeClasses(List.of(anyTypeClass))) {
            schema.setAnyTypeClass(null);
        }
        for (AnyType type : this.anyTypeDAO.findByClassesContaining(anyTypeClass)) {
            type.getClasses().remove(anyTypeClass);
        }
        for (GroupTypeExtension typeExt : this.groupDAO.findTypeExtensions(anyTypeClass)) {
            typeExt.getAuxClasses().remove(anyTypeClass);
            if (!typeExt.getAuxClasses().isEmpty()) continue;
            typeExt.getGroup().getTypeExtensions().remove(typeExt);
            typeExt.setGroup(null);
        }
        for (GroupTypeExtension typeExt : this.relationshipTypeDAO.findTypeExtensions(anyTypeClass)) {
            typeExt.getAuxClasses().remove(anyTypeClass);
            if (!typeExt.getAuxClasses().isEmpty()) continue;
            typeExt.getRelationshipType().getTypeExtensions().remove(typeExt);
            typeExt.setRelationshipType(null);
        }
        this.resourceDAO.findAll().stream().flatMap(resource -> resource.getProvisions().stream()).filter(provision -> provision.getAuxClasses().contains(anyTypeClass.getKey())).forEach(provision -> provision.getAuxClasses().remove(anyTypeClass.getKey()));
        this.entityManager.remove((Object)anyTypeClass);
    }
}

