/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.cookie.PinnableCookieProperties;
import org.apereo.cas.configuration.model.support.interrupt.InterruptCookieProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.idp.slo.SamlIdPProfileSingleLogoutRequestProcessor;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlIdPResponseCustomizer;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.cipher.DefaultCipherExecutorResolver;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutorResolver;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.DelegatedClientAuthenticationDistributedSessionCookieCipherExecutor;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.actions.logout.DelegatedSaml2ClientIdPRestoreSloRequestAction;
import org.apereo.cas.web.saml2.DelegatedAuthenticationSamlIdPResponseCustomizer;
import org.apereo.cas.web.saml2.DelegatedAuthenticationSamlIdPSingleLogoutRequestProcessor;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.mgmr.DefaultCasCookieValueManager;
import org.apereo.cas.web.support.mgmr.DefaultCookieSameSitePolicy;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.execution.Action;

@ConditionalOnClass(value={SamlIdPResponseCustomizer.class, SamlIdPProfileSingleLogoutRequestProcessor.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication}, module="saml-idp")
@Configuration(value="DelegatedAuthenticationSaml2IdPConfiguration", proxyBeanMethods=false)
class DelegatedAuthenticationSaml2IdPConfiguration {
    DelegatedAuthenticationSaml2IdPConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"delegatedSaml2IdPResponseCustomizer"})
    public SamlIdPResponseCustomizer delegatedSaml2IdPResponseCustomizer(@Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders) {
        return new DelegatedAuthenticationSamlIdPResponseCustomizer(identityProviders);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"delegatedSaml2ClientIdPRestoreSloRequestAction"})
    public Action delegatedSaml2ClientIdPRestoreSloRequestAction(@Qualifier(value="delegatedSaml2IdPSloRequestProcessor") SamlIdPProfileSingleLogoutRequestProcessor delegatedSaml2IdPSloRequestProcessor, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedSaml2ClientIdPRestoreSloRequestAction(delegatedSaml2IdPSloRequestProcessor)).withId("delegatedSaml2ClientIdPRestoreSloRequestAction").build().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"delegatedSaml2IdPSloRequestProcessor"})
    public SamlIdPProfileSingleLogoutRequestProcessor delegatedSaml2IdPSloRequestProcessor(@Qualifier(value="webApplicationServiceFactory") ServiceFactory serviceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="delegatedSaml2IdPSloRequestCookieGenerator") CasCookieBuilder delegatedSaml2IdPSloRequestCookieGenerator) {
        return new DelegatedAuthenticationSamlIdPSingleLogoutRequestProcessor(delegatedSaml2IdPSloRequestCookieGenerator, serviceFactory, servicesManager, casProperties);
    }

    @ConditionalOnMissingBean(name={"delegatedSaml2IdPSloRequestCookieGenerator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Deprecated(since="7.3.0", forRemoval=true)
    public CasCookieBuilder delegatedSaml2IdPSloRequestCookieGenerator(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService, @Qualifier(value="delegatedClientDistributedSessionCookieCipherExecutor") CipherExecutor delegatedClientDistributedSessionCookieCipherExecutor, CasConfigurationProperties casProperties) {
        CookieSessionReplicationProperties sessionReplicationCookieProps = casProperties.getAuthn().getPac4j().getCore().getSessionReplication().getCookie();
        PinnableCookieProperties logoutRequestCookie = sessionReplicationCookieProps.withPinToSession(true);
        logoutRequestCookie.setName("Saml2LogoutRequest");
        DefaultCipherExecutorResolver cipherExecutorResolver = new DefaultCipherExecutorResolver(delegatedClientDistributedSessionCookieCipherExecutor, tenantExtractor, InterruptCookieProperties.class, bindingContext -> {
            CasConfigurationProperties properties = (CasConfigurationProperties)bindingContext.value();
            EncryptionJwtSigningJwtCryptographyProperties crypto = properties.getAuthn().getPac4j().getCore().getSessionReplication().getCookie().getCrypto();
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, DelegatedClientAuthenticationDistributedSessionCookieCipherExecutor.class);
        });
        DefaultCasCookieValueManager cookieValueManager = new DefaultCasCookieValueManager((CipherExecutorResolver)cipherExecutorResolver, tenantExtractor, geoLocationService, DefaultCookieSameSitePolicy.INSTANCE, logoutRequestCookie);
        return CookieUtils.buildCookieRetrievingGenerator((CookieProperties)logoutRequestCookie, (CookieValueManager)cookieValueManager);
    }
}

