/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nonnull;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.jooq.lambda.Unchecked;

@MappedSuperclass
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OneTimeTokenAccount
implements Serializable,
Comparable<OneTimeTokenAccount>,
Cloneable {
    public static final String TABLE_NAME_SCRATCH_CODES = "scratch_codes";
    public static final String TABLE_NAME_OTP_PROPERTIES = "otp_properties";
    private static final long serialVersionUID = -8289105320642735252L;
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    @Id
    @Transient
    @JsonProperty(value="id")
    private long id;
    @Column(nullable=false, length=2048)
    @JsonProperty(value="secretKey")
    private String secretKey;
    @Column(nullable=false)
    @JsonProperty(value="validationCode")
    private int validationCode;
    @ElementCollection(targetClass=BigInteger.class)
    @CollectionTable(name="scratch_codes", joinColumns={@JoinColumn(name="id")})
    @Column(nullable=false, columnDefinition="numeric", precision=255, scale=0)
    private List<Number> scratchCodes;
    @ElementCollection(targetClass=String.class)
    @CollectionTable(name="otp_properties", joinColumns={@JoinColumn(name="id")})
    @Column(nullable=false, columnDefinition="VARCHAR(1024)")
    private List<String> properties;
    @Column(nullable=false)
    @JsonProperty(value="username")
    private String username;
    @Column(nullable=false)
    @JsonProperty(value="name")
    private String name;
    @Column
    @JsonProperty(value="registrationDate")
    private ZonedDateTime registrationDate;
    @Column
    @JsonProperty(value="lastUsedDateTime")
    private String lastUsedDateTime;
    @Column
    @JsonProperty(value="source")
    private String source;
    @Column
    @JsonProperty(value="tenant")
    private String tenant;

    @Override
    public int compareTo(@Nonnull OneTimeTokenAccount tokenAccount) {
        return Comparator.comparing(account -> account.getScratchCodes().toArray(), Comparator.comparing(Arrays::toString)).thenComparingInt(OneTimeTokenAccount::getValidationCode).thenComparing(OneTimeTokenAccount::getSecretKey).thenComparing(OneTimeTokenAccount::getUsername).thenComparing(OneTimeTokenAccount::getName).thenComparing(acct -> Objects.requireNonNullElse(acct.getLastUsedDateTime(), "")).thenComparing(acct -> StringUtils.defaultString((String)acct.getSource())).thenComparing(acct -> StringUtils.defaultString((String)acct.getTenant())).compare(this, tokenAccount);
    }

    public final OneTimeTokenAccount clone() {
        return (OneTimeTokenAccount)Unchecked.supplier(() -> (OneTimeTokenAccount)super.clone()).get();
    }

    @JsonIgnore
    public String toJson() {
        return (String)FunctionUtils.doUnchecked(() -> MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this));
    }

    @CanIgnoreReturnValue
    public OneTimeTokenAccount assignIdIfNecessary() {
        if (this.getId() <= 0L) {
            this.setId(System.currentTimeMillis());
        }
        return this;
    }

    @Generated
    private static List<Number> $default$scratchCodes() {
        return new ArrayList<Number>();
    }

    @Generated
    private static List<String> $default$properties() {
        return new ArrayList<String>();
    }

    @Generated
    private static ZonedDateTime $default$registrationDate() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    @Generated
    protected OneTimeTokenAccount(OneTimeTokenAccountBuilder<?, ?> b) {
        this.id = b.id;
        this.secretKey = b.secretKey;
        this.validationCode = b.validationCode;
        this.scratchCodes = b.scratchCodes$set ? b.scratchCodes$value : OneTimeTokenAccount.$default$scratchCodes();
        this.properties = b.properties$set ? b.properties$value : OneTimeTokenAccount.$default$properties();
        this.username = b.username;
        this.name = b.name;
        this.registrationDate = b.registrationDate$set ? b.registrationDate$value : OneTimeTokenAccount.$default$registrationDate();
        this.lastUsedDateTime = b.lastUsedDateTime;
        this.source = b.source;
        this.tenant = b.tenant;
    }

    @Generated
    public static OneTimeTokenAccountBuilder<?, ?> builder() {
        return new OneTimeTokenAccountBuilderImpl();
    }

    @Generated
    public String toString() {
        return "OneTimeTokenAccount(id=" + this.id + ", validationCode=" + this.validationCode + ", properties=" + String.valueOf(this.properties) + ", username=" + this.username + ", name=" + this.name + ", registrationDate=" + String.valueOf(this.registrationDate) + ", lastUsedDateTime=" + this.lastUsedDateTime + ", source=" + this.source + ", tenant=" + this.tenant + ")";
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public int getValidationCode() {
        return this.validationCode;
    }

    @Generated
    public List<Number> getScratchCodes() {
        return this.scratchCodes;
    }

    @Generated
    public List<String> getProperties() {
        return this.properties;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ZonedDateTime getRegistrationDate() {
        return this.registrationDate;
    }

    @Generated
    public String getLastUsedDateTime() {
        return this.lastUsedDateTime;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public void setValidationCode(int validationCode) {
        this.validationCode = validationCode;
    }

    @Generated
    public void setScratchCodes(List<Number> scratchCodes) {
        this.scratchCodes = scratchCodes;
    }

    @Generated
    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRegistrationDate(ZonedDateTime registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Generated
    public void setLastUsedDateTime(String lastUsedDateTime) {
        this.lastUsedDateTime = lastUsedDateTime;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OneTimeTokenAccount)) {
            return false;
        }
        OneTimeTokenAccount other = (OneTimeTokenAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.validationCode != other.validationCode) {
            return false;
        }
        String this$secretKey = this.secretKey;
        String other$secretKey = other.secretKey;
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        List<Number> this$scratchCodes = this.scratchCodes;
        List<Number> other$scratchCodes = other.scratchCodes;
        if (this$scratchCodes == null ? other$scratchCodes != null : !((Object)this$scratchCodes).equals(other$scratchCodes)) {
            return false;
        }
        List<String> this$properties = this.properties;
        List<String> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ZonedDateTime this$registrationDate = this.registrationDate;
        ZonedDateTime other$registrationDate = other.registrationDate;
        if (this$registrationDate == null ? other$registrationDate != null : !((Object)this$registrationDate).equals(other$registrationDate)) {
            return false;
        }
        String this$lastUsedDateTime = this.lastUsedDateTime;
        String other$lastUsedDateTime = other.lastUsedDateTime;
        if (this$lastUsedDateTime == null ? other$lastUsedDateTime != null : !this$lastUsedDateTime.equals(other$lastUsedDateTime)) {
            return false;
        }
        String this$source = this.source;
        String other$source = other.source;
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$tenant = this.tenant;
        String other$tenant = other.tenant;
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OneTimeTokenAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.id;
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.validationCode;
        String $secretKey = this.secretKey;
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        List<Number> $scratchCodes = this.scratchCodes;
        result = result * 59 + ($scratchCodes == null ? 43 : ((Object)$scratchCodes).hashCode());
        List<String> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ZonedDateTime $registrationDate = this.registrationDate;
        result = result * 59 + ($registrationDate == null ? 43 : ((Object)$registrationDate).hashCode());
        String $lastUsedDateTime = this.lastUsedDateTime;
        result = result * 59 + ($lastUsedDateTime == null ? 43 : $lastUsedDateTime.hashCode());
        String $source = this.source;
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $tenant = this.tenant;
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    @Generated
    public OneTimeTokenAccount() {
        this.scratchCodes = OneTimeTokenAccount.$default$scratchCodes();
        this.properties = OneTimeTokenAccount.$default$properties();
        this.registrationDate = OneTimeTokenAccount.$default$registrationDate();
    }

    @Generated
    public static abstract class OneTimeTokenAccountBuilder<C extends OneTimeTokenAccount, B extends OneTimeTokenAccountBuilder<C, B>> {
        @Generated
        private long id;
        @Generated
        private String secretKey;
        @Generated
        private int validationCode;
        @Generated
        private boolean scratchCodes$set;
        @Generated
        private List<Number> scratchCodes$value;
        @Generated
        private boolean properties$set;
        @Generated
        private List<String> properties$value;
        @Generated
        private String username;
        @Generated
        private String name;
        @Generated
        private boolean registrationDate$set;
        @Generated
        private ZonedDateTime registrationDate$value;
        @Generated
        private String lastUsedDateTime;
        @Generated
        private String source;
        @Generated
        private String tenant;

        @JsonProperty(value="id")
        @Generated
        public B id(long id) {
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="secretKey")
        @Generated
        public B secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this.self();
        }

        @JsonProperty(value="validationCode")
        @Generated
        public B validationCode(int validationCode) {
            this.validationCode = validationCode;
            return this.self();
        }

        @Generated
        public B scratchCodes(List<Number> scratchCodes) {
            this.scratchCodes$value = scratchCodes;
            this.scratchCodes$set = true;
            return this.self();
        }

        @Generated
        public B properties(List<String> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this.self();
        }

        @JsonProperty(value="username")
        @Generated
        public B username(String username) {
            this.username = username;
            return this.self();
        }

        @JsonProperty(value="name")
        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @JsonProperty(value="registrationDate")
        @Generated
        public B registrationDate(ZonedDateTime registrationDate) {
            this.registrationDate$value = registrationDate;
            this.registrationDate$set = true;
            return this.self();
        }

        @JsonProperty(value="lastUsedDateTime")
        @Generated
        public B lastUsedDateTime(String lastUsedDateTime) {
            this.lastUsedDateTime = lastUsedDateTime;
            return this.self();
        }

        @JsonProperty(value="source")
        @Generated
        public B source(String source) {
            this.source = source;
            return this.self();
        }

        @JsonProperty(value="tenant")
        @Generated
        public B tenant(String tenant) {
            this.tenant = tenant;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OneTimeTokenAccount.OneTimeTokenAccountBuilder(id=" + this.id + ", secretKey=" + this.secretKey + ", validationCode=" + this.validationCode + ", scratchCodes$value=" + String.valueOf(this.scratchCodes$value) + ", properties$value=" + String.valueOf(this.properties$value) + ", username=" + this.username + ", name=" + this.name + ", registrationDate$value=" + String.valueOf(this.registrationDate$value) + ", lastUsedDateTime=" + this.lastUsedDateTime + ", source=" + this.source + ", tenant=" + this.tenant + ")";
        }
    }

    @Generated
    private static final class OneTimeTokenAccountBuilderImpl
    extends OneTimeTokenAccountBuilder<OneTimeTokenAccount, OneTimeTokenAccountBuilderImpl> {
        @Generated
        private OneTimeTokenAccountBuilderImpl() {
        }

        @Override
        @Generated
        protected OneTimeTokenAccountBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OneTimeTokenAccount build() {
            return new OneTimeTokenAccount(this);
        }
    }
}

