/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels.any;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.layout.CustomizationOption;
import org.apache.syncope.client.enduser.panels.any.AbstractAttrs;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.EncryptedFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;

public class PlainAttrs
extends AbstractAttrs<PlainSchemaTO> {
    private static final long serialVersionUID = 552437609667518888L;
    protected final AnyTO anyTO;
    protected final AnyTO previousObject;
    protected String fileKey = "";

    public PlainAttrs(String id, UserWrapper modelObject, List<String> anyTypeClasses, Map<String, CustomizationOption> whichPlainAttrs) throws IllegalArgumentException {
        super(id, (AnyWrapper<UserTO>)modelObject, anyTypeClasses, whichPlainAttrs);
        this.anyTO = (AnyTO)modelObject.getInnerObject();
        this.previousObject = modelObject.getPreviousUserTO();
        this.fileKey = ((UserTO)modelObject.getInnerObject()).getUsername();
        this.add(new Component[]{new PlainSchemas("plainSchemas", null, this.schemas, (IModel<List<Attr>>)this.attrs).setOutputMarkupId(true)});
        this.add(new Component[]{new ListView<MembershipTO>("membershipsPlainSchemas", this.membershipTOs){
            private static final long serialVersionUID = 6741044372185745296L;

            protected void populateItem(ListItem<MembershipTO> item) {
                final MembershipTO membershipTO = (MembershipTO)item.getModelObject();
                item.add(new Component[]{new Accordion("membershipPlainSchemas", List.of(new AbstractTab(this, (IModel)new StringResourceModel("attributes.membership.accordion", (Component)PlainAttrs.this, (IModel)Model.of((Serializable)membershipTO))){
                    private static final long serialVersionUID = 1037272333056449378L;
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(title);
                    }

                    public WebMarkupContainer getPanel(String panelId) {
                        return new PlainSchemas(panelId, membershipTO.getGroupName(), (Map)this.this$1.PlainAttrs.this.membershipSchemas.get(membershipTO.getGroupKey()), (IModel<List<Attr>>)new ListModel(membershipTO.getPlainAttrs().stream().sorted(this.this$1.PlainAttrs.this.attrComparator).collect(Collectors.toList())));
                    }
                }), (IModel)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        }});
        this.add(new Component[]{new ListView<RelationshipTO>("relationshipsPlainSchemas", this.relationshipTOs){
            private static final long serialVersionUID = 6741044372185745296L;

            protected void populateItem(ListItem<RelationshipTO> item) {
                final RelationshipTO relationshipTO = (RelationshipTO)item.getModelObject();
                item.add(new Component[]{new Accordion("relationshipPlainSchemas", List.of(new AbstractTab(this, (IModel)new StringResourceModel("attributes.relationship.accordion", (Component)PlainAttrs.this, (IModel)Model.of((Serializable)relationshipTO))){
                    private static final long serialVersionUID = 1037272333056449378L;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        super(title);
                    }

                    public WebMarkupContainer getPanel(String panelId) {
                        return new PlainSchemas(panelId, relationshipTO.getOtherEndName(), (Map)this.this$1.PlainAttrs.this.relationshipSchemas.get(Pair.of((Object)relationshipTO.getType(), (Object)relationshipTO.getOtherEndKey())), (IModel<List<Attr>>)new ListModel(relationshipTO.getPlainAttrs().stream().sorted(this.this$1.PlainAttrs.this.attrComparator).collect(Collectors.toList())));
                    }
                }), (IModel)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        }});
    }

    @Override
    protected SchemaType getSchemaType() {
        return SchemaType.PLAIN;
    }

    @Override
    protected List<Attr> getAttrsFromTO() {
        return this.userTO.getPlainAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected List<Attr> getAttrsFromTO(MembershipTO membershipTO) {
        return membershipTO.getPlainAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected void setAttrs() {
        Map attrMap = EntityTOUtils.buildAttrMap((Collection)this.userTO.getPlainAttrs());
        List<Attr> plainAttrs = this.schemas.values().stream().map(schema -> {
            Attr attr = new Attr();
            attr.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((Attr)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                if (schema.getType() != AttrSchemaType.Dropdown || !schema.isMultivalue()) {
                    attr.getValues().add("");
                }
            } else {
                attr = (Attr)attrMap.get(schema.getKey());
            }
            return attr;
        }).toList();
        this.userTO.getPlainAttrs().clear();
        this.userTO.getPlainAttrs().addAll(plainAttrs);
    }

    @Override
    protected void setAttrs(MembershipTO membershipTO) {
        Map attrMap = this.userTO.getMembership(membershipTO.getGroupKey()).map(gr -> EntityTOUtils.buildAttrMap((Collection)gr.getPlainAttrs())).orElseGet(HashMap::new);
        List<Attr> plainAttrs = ((Map)this.membershipSchemas.get(membershipTO.getGroupKey())).values().stream().map(schema -> {
            Attr attr = new Attr();
            attr.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((Attr)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                if (schema.getType() != AttrSchemaType.Dropdown || !schema.isMultivalue()) {
                    attr.getValues().add("");
                }
            } else {
                attr.getValues().addAll(((Attr)attrMap.get(schema.getKey())).getValues());
            }
            return attr;
        }).toList();
        membershipTO.getPlainAttrs().clear();
        membershipTO.getPlainAttrs().addAll(plainAttrs);
    }

    @Override
    protected void setAttrs(RelationshipTO relationshipTO) {
        Map attrMap = this.userTO.getRelationship(relationshipTO.getType(), relationshipTO.getOtherEndKey()).map(gr -> EntityTOUtils.buildAttrMap((Collection)gr.getPlainAttrs())).orElseGet(HashMap::new);
        List<Attr> plainAttrs = ((Map)this.relationshipSchemas.get(Pair.of((Object)relationshipTO.getType(), (Object)relationshipTO.getOtherEndKey()))).values().stream().map(schema -> {
            Attr attr = new Attr();
            attr.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((Attr)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                if (schema.getType() != AttrSchemaType.Dropdown || !schema.isMultivalue()) {
                    attr.getValues().add("");
                }
            } else {
                attr.getValues().addAll(((Attr)attrMap.get(schema.getKey())).getValues());
            }
            return attr;
        }).toList();
        relationshipTO.getPlainAttrs().clear();
        relationshipTO.getPlainAttrs().addAll(plainAttrs);
    }

    protected AbstractFieldPanel<?> getFieldPanel(PlainSchemaTO plainSchema) {
        Object panel;
        boolean required = plainSchema.getMandatoryCondition().equalsIgnoreCase("true");
        boolean readOnly = plainSchema.isReadonly() || this.renderAsReadonly(plainSchema.getKey(), null);
        AttrSchemaType type = plainSchema.getType();
        boolean jexlHelp = false;
        switch (type) {
            case Boolean: {
                panel = new AjaxCheckBoxPanel("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), (IModel)new Model(), true);
                panel.setRequired(required);
                break;
            }
            case Date: {
                String datePattern = plainSchema.getConversionPattern() == null ? DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.getPattern() : plainSchema.getConversionPattern();
                panel = Strings.CI.contains((CharSequence)datePattern, (CharSequence)"H") ? new AjaxDateTimeFieldPanel("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), (IModel)new Model(), FastDateFormat.getInstance((String)datePattern)) : new AjaxDateFieldPanel("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), (IModel)new Model(), FastDateFormat.getInstance((String)datePattern));
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), (IModel)new Model(), true);
                ((AjaxDropDownChoicePanel)panel).setChoices(plainSchema.getEnumValues().keySet().stream().sorted().toList());
                if (!plainSchema.getEnumValues().isEmpty()) {
                    final Map valueMap = plainSchema.getEnumValues();
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;
                        final /* synthetic */ PlainAttrs this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public String getDisplayValue(String value) {
                            return valueMap.get(value) == null ? value : (String)valueMap.get(value);
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }

                        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                            return id;
                        }
                    });
                }
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Dropdown: {
                List<String> dropdownValues = this.schemaRestClient.getDropdownValues(plainSchema.getKey(), this.anyTO);
                if (plainSchema.isMultivalue()) {
                    panel = new AjaxPalettePanel.Builder().setName(plainSchema.getLabel(SyncopeEnduserSession.get().getLocale())).build("panel", (IModel)new ListModel(), (IModel)new ListModel(dropdownValues));
                } else {
                    panel = new AjaxDropDownChoicePanel("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), (IModel)new Model(), true);
                    ((AjaxDropDownChoicePanel)panel).setChoices(dropdownValues);
                }
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Long: {
                panel = new AjaxNumberFieldPanel.Builder().enableOnChange().build("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), Long.class, (IModel)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Double: {
                panel = new AjaxNumberFieldPanel.Builder().enableOnChange().step((Number)0.1).build("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), Double.class, (IModel)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Binary: {
                panel = new BinaryFieldPanel("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), (IModel)new Model(), plainSchema.getMimeType(), this.fileKey);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Encrypted: {
                panel = new EncryptedFieldPanel("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), (IModel)new Model(), true);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", plainSchema.getLabel(SyncopeEnduserSession.get().getLocale()), (IModel)new Model(), true);
                if (jexlHelp) {
                    ((AjaxTextFieldPanel)AjaxTextFieldPanel.class.cast(panel)).enableJexlHelp();
                }
                if (!required) break;
                panel.addRequiredLabel();
            }
        }
        panel.setReadOnly(readOnly);
        panel.setMarkupId(plainSchema.getKey());
        Label label = (Label)panel.get("field-label");
        label.add(new Behavior[]{new AttributeModifier("for", (Serializable)((Object)("form_" + plainSchema.getKey())))});
        return panel;
    }

    protected class PlainSchemas
    extends AbstractAttrs.Schemas {
        private static final long serialVersionUID = 456754923340249215L;

        protected PlainSchemas(String id, final String groupName, final Map<String, PlainSchemaTO> schemas, IModel<List<Attr>> attrs) {
            super(id);
            this.add(new Component[]{new ListView<Attr>(this, "schemas", attrs){
                private static final long serialVersionUID = 5306618783986001008L;
                final /* synthetic */ PlainSchemas this$1;
                {
                    this.this$1 = this$1;
                    super(id, model);
                }

                protected void populateItem(ListItem<Attr> item) {
                    Attr attr = (Attr)item.getModelObject();
                    PlainSchemaTO schema = (PlainSchemaTO)schemas.get(attr.getSchema());
                    if (attr.getValues().stream().noneMatch(StringUtils::isNotBlank)) {
                        attr.getValues().clear();
                        attr.getValues().addAll(this.this$1.PlainAttrs.this.getDefaultValues(attr.getSchema(), groupName));
                    }
                    MultiFieldPanel panel = this.this$1.PlainAttrs.this.getFieldPanel(schema);
                    panel.setReadOnly(schema.isReadonly());
                    if (schema.isMultivalue() && schema.getType() != AttrSchemaType.Dropdown) {
                        panel = new MultiFieldPanel.Builder((IModel)new PropertyModel((Object)attr, "values")).build("panel", schema.getLabel(SyncopeEnduserSession.get().getLocale()), (FieldPanel)FieldPanel.class.cast(panel));
                    } else if (panel instanceof AjaxPalettePanel) {
                        AjaxPalettePanel ajaxPalettePanel = (AjaxPalettePanel)panel;
                        ajaxPalettePanel.setModelObject(attr.getValues());
                    } else {
                        ((FieldPanel)FieldPanel.class.cast(panel)).setNewModel(attr.getValues());
                    }
                    item.add(new Component[]{panel});
                }
            }});
        }
    }
}

