/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.LdapPasswordManagementService;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.impl.NoOpPasswordManagementService;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.ldaptive.ConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordManagement}, module="ldap")
@AutoConfiguration
public class CasLdapPasswordManagementAutoConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.pm.ldap[0].ldap-url");

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"ldapPasswordChangeService"})
    public PasswordManagementService passwordChangeService(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordManagementCipherExecutor") CipherExecutor passwordManagementCipherExecutor, @Qualifier(value="passwordHistoryService") PasswordHistoryService passwordHistoryService) {
        return (PasswordManagementService)BeanSupplier.of(PasswordManagementService.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            ConcurrentHashMap<String, ConnectionFactory> connectionFactoryMap = new ConcurrentHashMap<String, ConnectionFactory>();
            PasswordManagementProperties passwordManagerProperties = casProperties.getAuthn().getPm();
            passwordManagerProperties.getLdap().forEach(ldap -> connectionFactoryMap.put(ldap.getLdapUrl(), LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap)));
            return new LdapPasswordManagementService((CipherExecutor<Serializable, String>)passwordManagementCipherExecutor, casProperties, passwordHistoryService, connectionFactoryMap);
        }).otherwise(() -> new NoOpPasswordManagementService(passwordManagementCipherExecutor, casProperties)).get();
    }
}

