/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm;

import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;

public class PasswordChangeRequest
implements Serializable {
    private static final long serialVersionUID = 8885460875620586503L;
    private String username;
    private char[] currentPassword;
    @Size(min=1, message="required.password")
    private @Size(min=1, message="required.password") char[] password;
    @Size(min=1, message="required.confirmedPassword")
    private @Size(min=1, message="required.confirmedPassword") char[] confirmedPassword;

    public String toCurrentPassword() {
        return this.currentPassword == null ? "" : new String(this.currentPassword);
    }

    public String toPassword() {
        return Optional.ofNullable(this.password).map(String::new).orElse(null);
    }

    public String toConfirmedPassword() {
        return new String(this.confirmedPassword);
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getCurrentPassword() {
        return this.currentPassword;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public char[] getConfirmedPassword() {
        return this.confirmedPassword;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setCurrentPassword(char[] currentPassword) {
        this.currentPassword = currentPassword;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setConfirmedPassword(char[] confirmedPassword) {
        this.confirmedPassword = confirmedPassword;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PasswordChangeRequest)) {
            return false;
        }
        PasswordChangeRequest other = (PasswordChangeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.currentPassword, other.currentPassword)) {
            return false;
        }
        if (!Arrays.equals(this.password, other.password)) {
            return false;
        }
        return Arrays.equals(this.confirmedPassword, other.confirmedPassword);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PasswordChangeRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.currentPassword);
        result = result * 59 + Arrays.hashCode(this.password);
        result = result * 59 + Arrays.hashCode(this.confirmedPassword);
        return result;
    }

    @Generated
    public PasswordChangeRequest() {
    }

    @Generated
    public PasswordChangeRequest(String username, char[] currentPassword, char[] password, char[] confirmedPassword) {
        this.username = username;
        this.currentPassword = currentPassword;
        this.password = password;
        this.confirmedPassword = confirmedPassword;
    }
}

