/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.topology;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.client.console.topology.TopologyNodePanel;
import org.apache.syncope.client.console.topology.TopologyTogglePanel;
import org.apache.syncope.client.console.topology.TopologyWebSocketBehavior;
import org.apache.syncope.client.console.wicket.markup.html.WebMarkupContainerNoVeil;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.resources.AbstractResourceWizardBuilder;
import org.apache.syncope.client.ui.commons.annotations.IdMPage;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

@IdMPage(label="Topology", icon="fas fa-plug", listEntitlement="RESOURCE_LIST", priority=0)
public class Topology
extends BasePage {
    private static final long serialVersionUID = -1100228004207271272L;
    public static final String CONNECTOR_SERVER_LOCATION_PREFIX = "connid://";
    @SpringBean
    protected ResourceRestClient resourceRestClient;
    @SpringBean
    protected ConnectorRestClient connectorRestClient;
    protected final int origX = 3100;
    protected final int origY = 2800;
    protected final BaseModal<Serializable> modal;
    protected final WebMarkupContainer newlyCreatedContainer;
    protected final ListView<TopologyNode> newlyCreated;
    protected final TopologyTogglePanel togglePanel;
    protected final LoadableDetachableModel<List<ResourceTO>> resModel = new LoadableDetachableModel<List<ResourceTO>>(){
        private static final long serialVersionUID = 5275935387613157431L;

        protected List<ResourceTO> load() {
            return Topology.this.resourceRestClient.list();
        }
    };
    protected final LoadableDetachableModel<Map<String, List<ConnInstanceTO>>> connModel = new LoadableDetachableModel<Map<String, List<ConnInstanceTO>>>(){
        private static final long serialVersionUID = 5275935387613157432L;

        protected Map<String, List<ConnInstanceTO>> load() {
            HashMap<String, List<ConnInstanceTO>> res = new HashMap<String, List<ConnInstanceTO>>();
            Topology.this.connectorRestClient.getAllConnectors().forEach(conn -> {
                List<ConnInstanceTO> conns;
                if (res.containsKey(conn.getLocation())) {
                    conns = (List)res.get(conn.getLocation());
                } else {
                    conns = new ArrayList();
                    res.put(conn.getLocation(), conns);
                }
                conns.add((ConnInstanceTO)conn);
            });
            return res;
        }
    };
    protected final LoadableDetachableModel<Pair<List<URI>, List<URI>>> csModel = new LoadableDetachableModel<Pair<List<URI>, List<URI>>>(){
        private static final long serialVersionUID = 5275935387613157433L;

        protected Pair<List<URI>, List<URI>> load() {
            ArrayList connectorServers = new ArrayList();
            ArrayList filePaths = new ArrayList();
            SyncopeConsoleSession.get().getPlatformInfo().getConnIdLocations().forEach(location -> {
                if (location.startsWith(Topology.CONNECTOR_SERVER_LOCATION_PREFIX)) {
                    connectorServers.add(URI.create(location));
                } else {
                    filePaths.add(URI.create(location));
                }
            });
            return Pair.of(connectorServers, filePaths);
        }
    };

    public Topology() {
        this.modal = new BaseModal("resource-modal");
        this.body.add(new Component[]{this.modal.size(Modal.Size.Large)});
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> this.modal.show(false));
        final TopologyWebSocketBehavior websocket = new TopologyWebSocketBehavior();
        this.body.add(new Behavior[]{websocket});
        this.togglePanel = new TopologyTogglePanel("toggle", this.getPageReference());
        this.body.add(new Component[]{this.togglePanel});
        ActionsPanel zoomActionPanel = new ActionsPanel("zoom", null);
        zoomActionPanel.add((ActionLink)new ActionLink<Serializable>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.appendJavaScript((CharSequence)"zoomIn($('#drawing')[0]);");
            }
        }, ActionLink.ActionType.ZOOM_IN, "CONNECTOR_LIST").disableIndicator().hideLabel();
        zoomActionPanel.add((ActionLink)new ActionLink<Serializable>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.appendJavaScript((CharSequence)"zoomOut($('#drawing')[0]);");
            }
        }, ActionLink.ActionType.ZOOM_OUT, "CONNECTOR_LIST").disableIndicator().hideLabel();
        this.body.add(new Component[]{zoomActionPanel});
        String rootName = StringUtils.capitalize((String)"syncope");
        final TopologyNode syncopeTopologyNode = new TopologyNode(rootName, rootName, TopologyNode.Kind.SYNCOPE);
        syncopeTopologyNode.setX(3100);
        syncopeTopologyNode.setY(2800);
        URI uri = WebClient.client((Object)SyncopeConsoleSession.get().getService(SyncopeService.class)).getBaseURI();
        syncopeTopologyNode.setHost(uri.getHost());
        syncopeTopologyNode.setPort(uri.getPort());
        this.body.add(new Component[]{this.topologyNodePanel("syncope", syncopeTopologyNode, false)});
        final HashMap connections = new HashMap();
        final HashMap syncopeConnections = new HashMap();
        connections.put(syncopeTopologyNode.getKey(), syncopeConnections);
        final HashMap servers = new HashMap();
        final HashMap connectors = new HashMap();
        ListView<URI> connectorServers = new ListView<URI>(this, "connectorServers", (List)((Pair)this.csModel.getObject()).getLeft()){
            private static final long serialVersionUID = 6978621871488360380L;
            private final int size;
            final /* synthetic */ Topology this$0;
            {
                this.this$0 = this$0;
                super(id, list);
                this.size = ((List)((Pair)this.this$0.csModel.getObject()).getLeft()).size() + 1;
            }

            protected void populateItem(ListItem<URI> item) {
                int kx = this.size >= 4 ? 800 : 200 * this.size;
                int x = (int)Math.round(3100.0 + (double)kx * Math.cos(Math.PI + Math.PI * (double)(item.getIndex() + 1) / (double)this.size));
                int y = (int)Math.round(2800.0 + 100.0 * Math.sin(Math.PI + Math.PI * (double)(item.getIndex() + 1) / (double)this.size));
                URI location = (URI)item.getModelObject();
                String url = location.toASCIIString();
                TopologyNode topologynode = new TopologyNode(url, url, TopologyNode.Kind.CONNECTOR_SERVER);
                topologynode.setHost(location.getHost());
                topologynode.setPort(location.getPort());
                topologynode.setX(x);
                topologynode.setY(y);
                servers.put(topologynode.getKey(), topologynode);
                item.add(new Component[]{this.this$0.topologyNodePanel("cs", topologynode, false)});
                syncopeConnections.put(url, topologynode);
                connections.put(url, new HashMap());
            }
        };
        connectorServers.setOutputMarkupId(true);
        this.body.add(new Component[]{connectorServers});
        ListView<URI> filePaths = new ListView<URI>(this, "filePaths", (List)((Pair)this.csModel.getObject()).getRight()){
            private static final long serialVersionUID = 6978621871488360380L;
            private final int size;
            final /* synthetic */ Topology this$0;
            {
                this.this$0 = this$0;
                super(id, list);
                this.size = ((List)((Pair)this.this$0.csModel.getObject()).getRight()).size() + 1;
            }

            protected void populateItem(ListItem<URI> item) {
                int kx = this.size >= 4 ? 800 : 200 * this.size;
                int x = (int)Math.round(3100.0 + (double)kx * Math.cos(Math.PI * (double)(item.getIndex() + 1) / (double)this.size));
                int y = (int)Math.round(2800.0 + 100.0 * Math.sin(Math.PI * (double)(item.getIndex() + 1) / (double)this.size));
                URI location = (URI)item.getModelObject();
                String url = location.toASCIIString();
                TopologyNode topologynode = new TopologyNode(url, url, TopologyNode.Kind.FS_PATH);
                topologynode.setHost(location.getHost());
                topologynode.setPort(location.getPort());
                topologynode.setX(x);
                topologynode.setY(y);
                servers.put(topologynode.getKey(), topologynode);
                item.add(new Component[]{this.this$0.topologyNodePanel("fp", topologynode, false)});
                syncopeConnections.put(url, topologynode);
                connections.put(url, new HashMap());
            }
        };
        filePaths.setOutputMarkupId(true);
        this.body.add(new Component[]{filePaths});
        ListView<List<ConnInstanceTO>> conns = new ListView<List<ConnInstanceTO>>(this, "conns", new ArrayList(((Map)this.connModel.getObject()).values())){
            private static final long serialVersionUID = 697862187148836036L;
            final /* synthetic */ Topology this$0;
            {
                this.this$0 = this$0;
                super(id, list);
            }

            protected void populateItem(ListItem<List<ConnInstanceTO>> item) {
                final int size = ((List)item.getModelObject()).size() + 1;
                ListView<ConnInstanceTO> conns = new ListView<ConnInstanceTO>(this, "conns", (List)item.getModelObject()){
                    private static final long serialVersionUID = 6978621871488360381L;
                    final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                        super(id, list);
                    }

                    protected void populateItem(ListItem<ConnInstanceTO> item) {
                        Map<String, TopologyNode> remoteConnections;
                        ConnInstanceTO conn = (ConnInstanceTO)item.getModelObject();
                        TopologyNode topologynode = new TopologyNode(conn.getKey(), StringUtils.isBlank((CharSequence)conn.getDisplayName()) ? conn.getBundleName() : conn.getDisplayName(), TopologyNode.Kind.CONNECTOR);
                        TopologyNode parent = (TopologyNode)servers.get(conn.getLocation());
                        int kx = size >= 6 ? 800 : 130 * size;
                        double hpos = conn.getLocation().startsWith(Topology.CONNECTOR_SERVER_LOCATION_PREFIX) ? Math.PI : 0.0;
                        int x = (int)Math.round((double)Optional.ofNullable(parent).map(TopologyNode::getX).orElse(3100).intValue() + (double)kx * Math.cos(hpos + Math.PI * (double)(item.getIndex() + 1) / (double)size));
                        int y = (int)Math.round((double)Optional.ofNullable(parent).map(TopologyNode::getY).orElse(2800).intValue() + 100.0 * Math.sin(hpos + Math.PI * (double)(item.getIndex() + 1) / (double)size));
                        topologynode.setConnectionDisplayName(conn.getBundleName());
                        topologynode.setX(x);
                        topologynode.setY(y);
                        connectors.put(topologynode.getKey(), topologynode);
                        item.add(new Component[]{this.this$1.this$0.topologyNodePanel("conn", topologynode, conn.isErrored())});
                        if (connections.containsKey(conn.getLocation())) {
                            remoteConnections = (Map)connections.get(conn.getLocation());
                        } else {
                            remoteConnections = new HashMap();
                            connections.put(conn.getLocation(), remoteConnections);
                        }
                        remoteConnections.put(conn.getKey(), topologynode);
                    }
                };
                conns.setOutputMarkupId(true);
                item.add(new Component[]{conns});
            }
        };
        conns.setOutputMarkupId(true);
        this.body.add(new Component[]{conns});
        final HashSet adminConns = new HashSet();
        ((Map)this.connModel.getObject()).values().forEach(connInstances -> adminConns.addAll(connInstances.stream().map(ConnInstanceTO::getKey).toList()));
        final HashSet adminRes = new HashSet();
        ArrayList connToBeProcessed = new ArrayList();
        ((List)this.resModel.getObject()).stream().filter(resourceTO -> adminConns.contains(resourceTO.getConnector())).forEach(resourceTO -> {
            Map<String, TopologyNode> remoteConnections;
            TopologyNode topologynode = new TopologyNode(resourceTO.getKey(), resourceTO.getKey(), TopologyNode.Kind.RESOURCE);
            if (connections.containsKey(resourceTO.getConnector())) {
                remoteConnections = (Map)connections.get(resourceTO.getConnector());
            } else {
                remoteConnections = new HashMap();
                connections.put(resourceTO.getConnector(), remoteConnections);
            }
            remoteConnections.put(topologynode.getKey(), topologynode);
            adminRes.add(resourceTO.getKey());
            if (!connToBeProcessed.contains(resourceTO.getConnector())) {
                connToBeProcessed.add(resourceTO.getConnector());
            }
        });
        ListView<String> resources = new ListView<String>(this, "resources", connToBeProcessed){
            private static final long serialVersionUID = 697862187148836038L;
            final /* synthetic */ Topology this$0;
            {
                this.this$0 = this$0;
                super(id, list);
            }

            protected void populateItem(ListItem<String> item) {
                final String connectorKey = (String)item.getModelObject();
                ListView<TopologyNode> innerListView = new ListView<TopologyNode>(this, "resources", new ArrayList(((Map)connections.get(connectorKey)).values())){
                    private static final long serialVersionUID = -3447760771863754342L;
                    private final int size;
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                        super(id, list);
                        this.size = this.getModelObject().size() + 1;
                    }

                    protected void populateItem(ListItem<TopologyNode> item) {
                        int kx;
                        TopologyNode topologynode = (TopologyNode)item.getModelObject();
                        TopologyNode parent = (TopologyNode)connectors.get(connectorKey);
                        int n = kx = this.size >= 16 ? 800 : 48 * this.size;
                        int ky = this.size < 4 ? 100 : (this.size < 6 ? 350 : 750);
                        double hpos = parent == null || parent.getY() < syncopeTopologyNode.getY() ? Math.PI : 0.0;
                        int x = (int)Math.round((double)Optional.ofNullable(parent).map(TopologyNode::getX).orElse(3100).intValue() + (double)kx * Math.cos(hpos + Math.PI * (double)(item.getIndex() + 1) / (double)this.size));
                        int y = (int)Math.round((double)Optional.ofNullable(parent).map(TopologyNode::getY).orElse(2800).intValue() + (double)ky * Math.sin(hpos + Math.PI * (double)(item.getIndex() + 1) / (double)this.size));
                        topologynode.setX(x);
                        topologynode.setY(y);
                        item.add(new Component[]{this.this$1.this$0.topologyNodePanel("res", topologynode, false)});
                    }
                };
                innerListView.setOutputMarkupId(true);
                item.add(new Component[]{innerListView});
            }
        };
        resources.setOutputMarkupId(true);
        this.body.add(new Component[]{resources});
        WebMarkupContainerNoVeil jsPlace = new WebMarkupContainerNoVeil("jsPlace");
        jsPlace.setOutputMarkupId(true);
        this.body.add(new Component[]{jsPlace});
        jsPlace.add(new Behavior[]{new Behavior(this){
            private static final long serialVersionUID = 2661717818979056044L;
            final /* synthetic */ Topology this$0;
            {
                this.this$0 = this$0;
            }

            public void renderHead(Component component, IHeaderResponse response) {
                StringBuilder jsPlumbConf = new StringBuilder();
                jsPlumbConf.append(String.format(Locale.US, "activate(%.2f);", Float.valueOf(0.68f)));
                Topology.createConnections(connections).forEach(jsPlumbConf::append);
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)jsPlumbConf.toString()));
            }
        }});
        jsPlace.add(new Behavior[]{new AbstractAjaxTimerBehavior(this, Duration.of(2L, ChronoUnit.SECONDS)){
            private static final long serialVersionUID = -4426283634345968585L;
            final /* synthetic */ Topology this$0;
            {
                this.this$0 = this$0;
                super(updateInterval);
            }

            protected void onTimer(AjaxRequestTarget target) {
                if (websocket.connCheckDone(adminConns) && websocket.resCheckDone(adminRes)) {
                    this.stop((IPartialPageRequestHandler)target);
                }
                target.appendJavaScript((CharSequence)"checkConnection()");
                if ((double)this.getUpdateInterval().getSeconds() < 5.0) {
                    this.setUpdateInterval(Duration.of(5L, ChronoUnit.SECONDS));
                } else if ((double)this.getUpdateInterval().getSeconds() < 10.0) {
                    this.setUpdateInterval(Duration.of(10L, ChronoUnit.SECONDS));
                } else if ((double)this.getUpdateInterval().getSeconds() < 15.0) {
                    this.setUpdateInterval(Duration.of(15L, ChronoUnit.SECONDS));
                } else if ((double)this.getUpdateInterval().getSeconds() < 20.0) {
                    this.setUpdateInterval(Duration.of(20L, ChronoUnit.SECONDS));
                } else if ((double)this.getUpdateInterval().getSeconds() < 30.0) {
                    this.setUpdateInterval(Duration.of(30L, ChronoUnit.SECONDS));
                } else if ((double)this.getUpdateInterval().getSeconds() < 60.0) {
                    this.setUpdateInterval(Duration.of(60L, ChronoUnit.SECONDS));
                }
            }
        }});
        this.newlyCreatedContainer = new WebMarkupContainer("newlyCreatedContainer");
        this.newlyCreatedContainer.setOutputMarkupId(true);
        this.body.add(new Component[]{this.newlyCreatedContainer});
        this.newlyCreated = new ListView<TopologyNode>("newlyCreated", new ArrayList()){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<TopologyNode> item) {
                item.add(new Component[]{Topology.this.topologyNodePanel("el", (TopologyNode)item.getModelObject(), false)});
            }
        };
        this.newlyCreated.setOutputMarkupId(true);
        this.newlyCreated.setReuseItems(true);
        this.newlyCreatedContainer.add(new Component[]{this.newlyCreated});
    }

    private static List<String> createConnections(Map<Serializable, Map<Serializable, TopologyNode>> targets) {
        ArrayList<String> list = new ArrayList<String>();
        targets.forEach((key, value) -> value.forEach((label, node) -> list.add(String.format("connect('%s','%s','%s');", new Object[]{key, label, node.getKind()}))));
        return list;
    }

    private TopologyNodePanel topologyNodePanel(String id, final TopologyNode node, boolean errored) {
        TopologyNodePanel panel = new TopologyNodePanel(id, node, errored);
        panel.setMarkupId(String.valueOf(node.getKey()));
        panel.setOutputMarkupId(true);
        ArrayList<Object> behaviors = new ArrayList<Object>();
        behaviors.add(new Behavior(this){
            private static final long serialVersionUID = 2661717818979056044L;
            final /* synthetic */ Topology this$0;
            {
                this.this$0 = this$0;
            }

            public void renderHead(Component component, IHeaderResponse response) {
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("setPosition('%s', %d, %d)", node.getKey(), node.getX(), node.getY())));
            }
        });
        behaviors.add(new AjaxEventBehavior(this, "click"){
            private static final long serialVersionUID = -9027652037484739586L;
            final /* synthetic */ Topology this$0;
            {
                this.this$0 = this$0;
                super(event);
            }

            protected String findIndicatorId() {
                return "";
            }

            protected void onEvent(AjaxRequestTarget target) {
                this.this$0.togglePanel.toggleWithContent(target, node);
                target.appendJavaScript((CharSequence)String.format("$('.window').removeClass(\"active-window\").addClass(\"inactive-window\"); $(document.getElementById('%s')).removeClass(\"inactive-window\").addClass(\"active-window\");", node.getKey()));
            }
        });
        panel.add((Behavior[])behaviors.toArray(Behavior[]::new));
        return panel;
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        Object object = event.getPayload();
        if (object instanceof AbstractResourceWizardBuilder.CreateEvent) {
            AbstractResourceWizardBuilder.CreateEvent payload = (AbstractResourceWizardBuilder.CreateEvent)((Object)object);
            TopologyNode node = new TopologyNode(payload.getKey(), payload.getDisplayName(), payload.getKind());
            this.newlyCreated.getModelObject().add(node);
            payload.getTarget().add(new Component[]{this.newlyCreatedContainer});
            payload.getTarget().appendJavaScript((CharSequence)String.format("window.Wicket.WebSocket.send('{\"kind\":\"%s\",\"target\":\"%s\",\"source\":\"%s\",\"scope\":\"%s\"}');", new Object[]{SupportedOperation.ADD_ENDPOINT, payload.getKey(), payload.getParent(), payload.getKind()}));
        }
    }

    protected static enum SupportedOperation {
        CHECK_RESOURCE,
        CHECK_CONNECTOR,
        ADD_ENDPOINT;

    }
}

