/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.multitenancy;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantsManager;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.execution.RequestContext;

public interface TenantExtractor {
    public static final FlowUrlHandler FLOW_URL_HANDLER = new DefaultFlowUrlHandler();
    public static final Pattern PATTERN_TENANTS = Pattern.compile("/?tenants/([^/]+)(?:/.*)?", 2);
    public static final String BEAN_NAME = "tenantExtractor";

    public TenantsManager getTenantsManager();

    public ApplicationContext getApplicationContext();

    default public Optional<TenantDefinition> extract(HttpServletRequest request) {
        String flowId = request != null ? FLOW_URL_HANDLER.getFlowId(request) : "";
        return this.extract(flowId);
    }

    default public Optional<TenantDefinition> extract(RequestContext requestContext) {
        HttpServletRequest request = (HttpServletRequest)requestContext.getExternalContext().getNativeRequest();
        return this.extract(request);
    }

    public Optional<TenantDefinition> extract(String var1);

    public static String tenantIdFromPath(String requestPath) {
        if (StringUtils.isBlank((CharSequence)requestPath)) {
            return null;
        }
        Matcher matcher = PATTERN_TENANTS.matcher(requestPath);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    public String getTenantKey(TenantDefinition var1);
}

