/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.web.AbstractServiceValidateController;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="CAS")
public class LegacyValidateController
extends AbstractServiceValidateController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyValidateController.class);

    public LegacyValidateController(ServiceValidateConfigurationContext serviceValidateConfigurationContext) {
        super(serviceValidateConfigurationContext);
    }

    @GetMapping(path={"/validate", "/tenants/{tenant}//validate"})
    @Operation(summary="Validate a service ticket", parameters={@Parameter(name="tenant", description="The tenant definition", in=ParameterIn.PATH), @Parameter(name="service", description="The service identifier"), @Parameter(name="ticket", description="The service ticket identifier")})
    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleRequestInternal(request, response);
    }

    @Override
    protected void prepareForTicketValidation(HttpServletRequest request, WebApplicationService service, String serviceTicketId) {
        super.prepareForTicketValidation(request, service, serviceTicketId);
        LOGGER.debug("Preparing to validate ticket [{}] for service [{}] via [{}]. Do note that this validation event is not equipped to release principal attributes to applications. To access the authenticated principal along with attributes, invoke the [{}] endpoint instead.", new Object[]{"/validate", serviceTicketId, service, "/p3/serviceValidate"});
    }
}

