/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcDiscoveryProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class OidcServerDiscoverySettingsFactory
implements FactoryBean<OidcServerDiscoverySettings> {
    protected final CasConfigurationProperties casProperties;
    protected final OidcIssuerService issuerService;
    protected final ConfigurableApplicationContext applicationContext;

    public OidcServerDiscoverySettings getObject() {
        return this.populateDiscovery(this.createDiscovery());
    }

    protected OidcServerDiscoverySettings createDiscovery() {
        return new OidcServerDiscoverySettings(this.issuerService.determineIssuer(Optional.empty()));
    }

    protected OidcServerDiscoverySettings populateDiscovery(OidcServerDiscoverySettings discovery) {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        OidcDiscoveryProperties discoveryConfig = oidc.getDiscovery();
        discovery.setClaimsSupported(new LinkedHashSet<String>(discoveryConfig.getClaims()));
        discovery.setScopesSupported(new LinkedHashSet<String>(discoveryConfig.getScopes()));
        discovery.setResponseTypesSupported(new LinkedHashSet<String>(discoveryConfig.getResponseTypesSupported()));
        discovery.setResponseModesSupported(new LinkedHashSet<String>(discoveryConfig.getResponseModesSupported()));
        discovery.setSubjectTypesSupported(new LinkedHashSet<String>(discoveryConfig.getSubjectTypes()));
        discovery.setClaimTypesSupported(new LinkedHashSet<String>(discoveryConfig.getClaimTypesSupported()));
        discovery.setIntrospectionSupportedAuthenticationMethods(new LinkedHashSet<String>(discoveryConfig.getIntrospectionSupportedAuthenticationMethods()));
        discovery.setGrantTypesSupported(new LinkedHashSet<String>(discoveryConfig.getGrantTypesSupported()));
        discovery.setTokenEndpointAuthMethodsSupported(new LinkedHashSet<String>(discoveryConfig.getTokenEndpointAuthMethodsSupported()));
        discovery.setClaimsParameterSupported(discoveryConfig.isClaimsParameterSupported());
        discovery.setPromptValuesSupported(new LinkedHashSet<String>(discoveryConfig.getPromptValuesSupported()));
        discovery.setIdTokenSigningAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getIdTokenSigningAlgValuesSupported()));
        discovery.setIdTokenEncryptionAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getIdTokenEncryptionAlgValuesSupported()));
        discovery.setIdTokenEncryptionEncodingValuesSupported(new LinkedHashSet<String>(discoveryConfig.getIdTokenEncryptionEncodingValuesSupported()));
        discovery.setIntrospectionSignedResponseAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getIntrospectionSignedResponseAlgValuesSupported()));
        discovery.setIntrospectionEncryptedResponseAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getIntrospectionEncryptedResponseAlgValuesSupported()));
        discovery.setIntrospectionEncryptedResponseEncodingValuesSupported(new LinkedHashSet<String>(discoveryConfig.getIntrospectionEncryptedResponseEncodingValuesSupported()));
        discovery.setBackchannelLogoutSupported(oidc.getLogout().isBackchannelLogoutSupported());
        discovery.setFrontchannelLogoutSupported(oidc.getLogout().isFrontchannelLogoutSupported());
        discovery.setDPopSigningAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getDpopSigningAlgValuesSupported()));
        discovery.setUserInfoSigningAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getUserInfoSigningAlgValuesSupported()));
        discovery.setUserInfoEncryptionAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getUserInfoEncryptionAlgValuesSupported()));
        discovery.setUserInfoEncryptionEncodingValuesSupported(new LinkedHashSet<String>(discoveryConfig.getUserInfoEncryptionEncodingValuesSupported()));
        discovery.setCodeChallengeMethodsSupported(new LinkedHashSet<String>(discoveryConfig.getCodeChallengeMethodsSupported()));
        discovery.setRequirePushedAuthorizationRequests(discoveryConfig.isRequirePushedAuthorizationRequests());
        discovery.setNativeSsoSupported(discoveryConfig.isNativeSsoSupported());
        discovery.setRequestParameterSupported(discoveryConfig.isRequestParameterSupported());
        discovery.setRequestUriParameterSupported(discoveryConfig.isRequestUriParameterSupported());
        discovery.setRequestObjectSigningAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getRequestObjectSigningAlgValuesSupported()));
        discovery.setRequestObjectEncryptionAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getRequestObjectEncryptionAlgValuesSupported()));
        discovery.setRequestObjectEncryptionEncodingValuesSupported(new LinkedHashSet<String>(discoveryConfig.getRequestObjectEncryptionEncodingValuesSupported()));
        discovery.setAuthorizationResponseIssuerParameterSupported(discoveryConfig.isAuthorizationResponseIssuerParameterSupported());
        discovery.setTlsClientCertificateBoundAccessTokens(discoveryConfig.isTlsClientCertificateBoundAccessTokens());
        discovery.setAcrValuesSupported(new LinkedHashSet<String>(discoveryConfig.getAcrValuesSupported()));
        if (discoveryConfig.getAcrValuesSupported().isEmpty()) {
            Set<String> providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext).values().stream().map(MultifactorAuthenticationProvider::getId).collect(Collectors.toSet());
            discovery.setAcrValuesSupported(providers);
        }
        discovery.setVerifiedClaimsSupported(discoveryConfig.isVerifiedClaimsSupported());
        discovery.setTrustFrameworksSupported(discoveryConfig.getTrustFrameworksSupported());
        discovery.setEvidenceSupported(discoveryConfig.getEvidenceSupported());
        discovery.setDocumentsSupported(discoveryConfig.getDocumentsSupported());
        discovery.setDocumentsValidationMethodsSupported(discoveryConfig.getDocumentsValidationMethodsSupported());
        discovery.setDocumentsVerificationMethodsSupported(discoveryConfig.getDocumentsVerificationMethodsSupported());
        discovery.setElectronicRecordsSupported(discoveryConfig.getElectronicRecordsSupported());
        discovery.setClaimsInVerifiedClaimsSupported(discoveryConfig.getClaimsInVerifiedClaimsSupported());
        discovery.setBackchannelUserCodeParameterSupported(discoveryConfig.isBackchannelUserCodeParameterSupported());
        discovery.setBackchannelTokenDeliveryModesSupported(new LinkedHashSet<String>(discoveryConfig.getBackchannelTokenDeliveryModesSupported()));
        discovery.setBackchannelAuthenticationRequestSigningAlgValuesSupported(new LinkedHashSet<String>(discoveryConfig.getBackchannelAuthenticationRequestSigningAlgValuesSupported()));
        return discovery;
    }

    public Class<?> getObjectType() {
        return OidcServerDiscoverySettings.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Generated
    public OidcServerDiscoverySettingsFactory(CasConfigurationProperties casProperties, OidcIssuerService issuerService, ConfigurableApplicationContext applicationContext) {
        this.casProperties = casProperties;
        this.issuerService = issuerService;
        this.applicationContext = applicationContext;
    }
}

