/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.security.Key;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.token.BaseOidcJsonWebKeyTokenSigningAndEncryptionService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.jwt.JsonWebTokenEncryptor;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcIdTokenSigningAndEncryptionService
extends BaseOidcJsonWebKeyTokenSigningAndEncryptionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIdTokenSigningAndEncryptionService.class);
    private final OidcServerDiscoverySettings discoverySettings;

    public OidcIdTokenSigningAndEncryptionService(LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache, LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache, OidcIssuerService issuerService, OidcServerDiscoverySettings discoverySettings, CasConfigurationProperties casProperties) {
        super(defaultJsonWebKeystoreCache, serviceJsonWebKeystoreCache, issuerService, casProperties);
        this.discoverySettings = discoverySettings;
    }

    public String getJsonWebKeySigningAlgorithm(OAuthRegisteredService registeredService, JsonWebKey jsonWebKey) {
        OidcRegisteredService svc = (OidcRegisteredService)registeredService;
        if (StringUtils.isBlank((CharSequence)svc.getIdTokenSigningAlg())) {
            return super.getJsonWebKeySigningAlgorithm(registeredService, jsonWebKey);
        }
        return svc.getIdTokenSigningAlg();
    }

    public boolean shouldSignToken(OAuthRegisteredService registeredService) {
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService service = (OidcRegisteredService)registeredService;
            if (!service.isSignIdToken()) {
                LOGGER.trace("Service [{}] does not require ID token to be signed", (Object)registeredService.getServiceId());
                return false;
            }
            if ("none".equalsIgnoreCase(service.getIdTokenSigningAlg())) {
                if (!this.discoverySettings.getIdTokenSigningAlgValuesSupported().contains("none")) {
                    LOGGER.error("Service [{}] has defined 'none' for ID token signing algorithm, yet CAS is configured to support the following signing algorithms: [{}]. This is quite likely due to misconfiguration of the CAS server or the service definition", (Object)registeredService.getServiceId(), this.discoverySettings.getIdTokenSigningAlgValuesSupported());
                    throw new IllegalArgumentException("Unable to use 'none' as ID token signing algorithm");
                }
                LOGGER.error("Service [{}] has defined 'none' for ID token signing algorithm", (Object)registeredService.getServiceId());
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean shouldEncryptToken(OAuthRegisteredService registeredService) {
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService service = (OidcRegisteredService)registeredService;
            if (service.isEncryptIdToken() && "none".equalsIgnoreCase(service.getIdTokenEncryptionAlg())) {
                if (!this.discoverySettings.getIdTokenSigningAlgValuesSupported().contains("none")) {
                    LOGGER.error("Service [{}] has defined 'none' for ID token encryption algorithm, yet CAS is configured to support the following encryption algorithms: [{}]. This is quite likely due to misconfiguration of the CAS server or the service definition", (Object)registeredService.getServiceId(), this.discoverySettings.getIdTokenEncryptionAlgValuesSupported());
                    throw new IllegalArgumentException("Unable to use 'none' as ID token encryption algorithm");
                }
                LOGGER.error("Service [{}] has defined 'none' for ID token encryption algorithm", (Object)registeredService.getServiceId());
                return false;
            }
            return service.isEncryptIdToken() && StringUtils.isNotBlank((CharSequence)service.getIdTokenEncryptionAlg()) && StringUtils.isNotBlank((CharSequence)service.getIdTokenEncryptionEncoding());
        }
        return false;
    }

    public Set<String> getAllowedSigningAlgorithms(OAuthRegisteredService registeredService) {
        return this.discoverySettings.getIdTokenSigningAlgValuesSupported();
    }

    @Override
    protected String encryptToken(OAuthRegisteredService service, String innerJwt) {
        if (service instanceof OidcRegisteredService) {
            OidcRegisteredService registeredService = (OidcRegisteredService)service;
            PublicJsonWebKey jsonWebKey = this.getJsonWebKeyForEncryption((OAuthRegisteredService)registeredService);
            if (jsonWebKey == null && registeredService.isIdTokenEncryptionOptional()) {
                return innerJwt;
            }
            return JsonWebTokenEncryptor.builder().key((Key)jsonWebKey.getPublicKey()).keyId(jsonWebKey.getKeyId()).algorithm(registeredService.getIdTokenEncryptionAlg()).encryptionMethod(registeredService.getIdTokenEncryptionEncoding()).allowedAlgorithms(this.discoverySettings.getIdTokenEncryptionAlgValuesSupported()).allowedContentEncryptionAlgorithms(this.discoverySettings.getIdTokenEncryptionEncodingValuesSupported()).headers(Map.of("client_id", registeredService.getClientId())).build().encrypt((Serializable)((Object)innerJwt));
        }
        return innerJwt;
    }
}

