/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20TokenExchangeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20DefaultAccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.idtoken.IdTokenGenerationContext;
import org.apereo.cas.ticket.idtoken.OidcIdToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class OidcAccessTokenResponseGenerator
extends OAuth20DefaultAccessTokenResponseGenerator<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAccessTokenResponseGenerator.class);

    public OidcAccessTokenResponseGenerator(ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
        super(oidcConfigurationContext);
    }

    protected String encodeOAuthToken(OAuth20Token accessToken, OAuth20AccessTokenResponseResult result) {
        Optional<OidcRegisteredService> oidcRegisteredService = Optional.ofNullable(result.getRegisteredService()).filter(OidcRegisteredService.class::isInstance).map(OidcRegisteredService.class::cast);
        String oidcIssuer = ((OidcConfigurationContext)((Object)this.configurationContext.getObject())).getIssuerService().determineIssuer(oidcRegisteredService);
        EncodableCipher cipher = OAuth20JwtAccessTokenEncoder.toEncodableCipher((OAuth20ConfigurationContext)((OAuth20ConfigurationContext)this.configurationContext.getObject()), (OAuth20AccessTokenResponseResult)result, (OAuth20Token)accessToken, (String)oidcIssuer);
        return (String)cipher.encode((Object)accessToken.getId(), new Object[]{accessToken, result});
    }

    protected Map<String, Object> getAccessTokenResponseModel(OAuth20AccessTokenResponseResult result) {
        Optional accessToken = result.getGeneratedToken().getAccessToken();
        Map model = super.getAccessTokenResponseModel(result);
        if (result.getGrantType() == OAuth20GrantTypes.TOKEN_EXCHANGE) {
            this.buildResponseModelForTokenExchange(result, model);
        } else {
            accessToken.map(at -> (OAuth20AccessToken)this.resolveToken((Ticket)at, OAuth20AccessToken.class)).ifPresent(token -> {
                if (result.getRegisteredService() instanceof OidcRegisteredService && !token.getScopes().contains("client_registration_scope")) {
                    this.collectIdToken(result, (OAuth20AccessToken)token, model);
                }
            });
        }
        return model;
    }

    protected void buildResponseModelForTokenExchange(OAuth20AccessTokenResponseResult result, Map<String, Object> model) {
        if (result.getRequestedTokenType() == OAuth20TokenExchangeTypes.ID_TOKEN) {
            Optional accessToken = result.getGeneratedToken().getAccessToken();
            accessToken.map(at -> (OAuth20AccessToken)this.resolveToken((Ticket)at, OAuth20AccessToken.class)).ifPresent(at -> this.collectIdToken(result, (OAuth20AccessToken)at, model));
        }
        model.put("issued_token_type", result.getRequestedTokenType().getType());
    }

    protected void collectIdToken(OAuth20AccessTokenResponseResult result, OAuth20AccessToken token, Map<String, Object> model) {
        OidcIdToken idToken = this.generateIdToken(result, token);
        if (idToken != null) {
            String idTokenValue = idToken.token();
            LOGGER.debug("Generated ID token [{}] based on grant type [{}]", (Object)idTokenValue, (Object)result.getGrantType());
            FunctionUtils.doIfNotBlank((CharSequence)idTokenValue, v -> model.put("id_token", v));
            FunctionUtils.doIfNotBlank((CharSequence)idToken.deviceSecret(), v -> model.put("device_secret", v));
        }
    }

    protected OidcIdToken generateIdToken(OAuth20AccessTokenResponseResult result, OAuth20AccessToken accessToken) {
        return (OidcIdToken)FunctionUtils.doUnchecked(() -> {
            Ticket refreshToken = result.getGeneratedToken().getRefreshToken().orElse(null);
            IdTokenGenerationContext idTokenContext = IdTokenGenerationContext.builder().accessToken(accessToken).userProfile(result.getUserProfile()).responseType(result.getResponseType()).grantType(result.getGrantType()).registeredService((OAuthRegisteredService)result.getRegisteredService()).refreshToken((OAuth20RefreshToken)this.resolveToken(refreshToken, OAuth20RefreshToken.class)).build();
            LOGGER.debug("Generating ID token for access token [{}]", (Object)accessToken.getId());
            return ((OidcConfigurationContext)((Object)((Object)this.configurationContext.getObject()))).getIdTokenGeneratorService().generate(idTokenContext);
        });
    }
}

