/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.extension.uvm.KeyProtectionType;
import com.yubico.webauthn.extension.uvm.MatcherProtectionType;
import com.yubico.webauthn.extension.uvm.UserVerificationMethod;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Extensions {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Extensions.class);

    @Generated
    private Extensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Uvm {
        static final String EXTENSION_ID = "uvm";

        static Optional<List<UvmEntry>> parseAuthenticatorExtensionOutput(CBORObject cbor) {
            if (Uvm.validateAuthenticatorExtensionOutput(cbor)) {
                return Optional.of(cbor.get(EXTENSION_ID).getValues().stream().map(uvmEntry -> new UvmEntry(UserVerificationMethod.fromValue(uvmEntry.get(0).AsInt32Value()), KeyProtectionType.fromValue(uvmEntry.get(1).AsNumber().ToInt16IfExact()), MatcherProtectionType.fromValue(uvmEntry.get(2).AsNumber().ToInt16IfExact()))).collect(Collectors.toList()));
            }
            return Optional.empty();
        }

        private static boolean validateAuthenticatorExtensionOutput(CBORObject extensions) {
            if (!extensions.ContainsKey(EXTENSION_ID)) {
                return false;
            }
            CBORObject uvm = extensions.get(EXTENSION_ID);
            if (uvm.getType() != CBORType.Array) {
                log.debug("Invalid CBOR type for \"{}\" extension output: expected array, was: {}", (Object)EXTENSION_ID, (Object)uvm.getType());
                return false;
            }
            if (uvm.size() < 1 || uvm.size() > 3) {
                log.debug("Invalid length \"{}\" extension output array: expected 1 to 3 (inclusive), was: {}", (Object)EXTENSION_ID, (Object)uvm.size());
                return false;
            }
            for (CBORObject entry : uvm.getValues()) {
                if (entry.getType() != CBORType.Array) {
                    log.debug("Invalid CBOR type for uvmEntry: expected array, was: {}", (Object)entry.getType());
                    return false;
                }
                if (entry.size() != 3) {
                    log.debug("Invalid length for uvmEntry: expected 3, was: {}", (Object)entry.size());
                    return false;
                }
                for (CBORObject i : entry.getValues()) {
                    if (i.isNumber() && i.AsNumber().IsInteger()) continue;
                    log.debug("Invalid type for uvmEntry element: expected integer, was: {}", (Object)i.getType());
                    return false;
                }
            }
            return true;
        }

        public static final class UvmEntry {
            private final UserVerificationMethod userVerificationMethod;
            private final KeyProtectionType keyProtectionType;
            private final MatcherProtectionType matcherProtectionType;

            public UvmEntry(@JsonProperty(value="userVerificationMethod") UserVerificationMethod userVerificationMethod, @JsonProperty(value="keyProtectionType") KeyProtectionType keyProtectionType, @JsonProperty(value="matcherProtectionType") MatcherProtectionType matcherProtectionType) {
                this.userVerificationMethod = userVerificationMethod;
                this.keyProtectionType = keyProtectionType;
                this.matcherProtectionType = matcherProtectionType;
            }

            @Generated
            public UserVerificationMethod getUserVerificationMethod() {
                return this.userVerificationMethod;
            }

            @Generated
            public KeyProtectionType getKeyProtectionType() {
                return this.keyProtectionType;
            }

            @Generated
            public MatcherProtectionType getMatcherProtectionType() {
                return this.matcherProtectionType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UvmEntry)) {
                    return false;
                }
                UvmEntry other = (UvmEntry)o;
                UserVerificationMethod this$userVerificationMethod = this.getUserVerificationMethod();
                UserVerificationMethod other$userVerificationMethod = other.getUserVerificationMethod();
                if (this$userVerificationMethod == null ? other$userVerificationMethod != null : !((Object)((Object)this$userVerificationMethod)).equals((Object)other$userVerificationMethod)) {
                    return false;
                }
                KeyProtectionType this$keyProtectionType = this.getKeyProtectionType();
                KeyProtectionType other$keyProtectionType = other.getKeyProtectionType();
                if (this$keyProtectionType == null ? other$keyProtectionType != null : !((Object)((Object)this$keyProtectionType)).equals((Object)other$keyProtectionType)) {
                    return false;
                }
                MatcherProtectionType this$matcherProtectionType = this.getMatcherProtectionType();
                MatcherProtectionType other$matcherProtectionType = other.getMatcherProtectionType();
                return !(this$matcherProtectionType == null ? other$matcherProtectionType != null : !((Object)((Object)this$matcherProtectionType)).equals((Object)other$matcherProtectionType));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UserVerificationMethod $userVerificationMethod = this.getUserVerificationMethod();
                result = result * 59 + ($userVerificationMethod == null ? 43 : ((Object)((Object)$userVerificationMethod)).hashCode());
                KeyProtectionType $keyProtectionType = this.getKeyProtectionType();
                result = result * 59 + ($keyProtectionType == null ? 43 : ((Object)((Object)$keyProtectionType)).hashCode());
                MatcherProtectionType $matcherProtectionType = this.getMatcherProtectionType();
                result = result * 59 + ($matcherProtectionType == null ? 43 : ((Object)((Object)$matcherProtectionType)).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.Uvm.UvmEntry(userVerificationMethod=" + (Object)((Object)this.getUserVerificationMethod()) + ", keyProtectionType=" + (Object)((Object)this.getKeyProtectionType()) + ", matcherProtectionType=" + (Object)((Object)this.getMatcherProtectionType()) + ")";
            }
        }
    }

    public static class Prf {
        static final String EXTENSION_ID = "prf";

        public static final class PrfAuthenticationOutput {
            @JsonProperty
            private final PrfValues results;

            @JsonCreator
            PrfAuthenticationOutput(@JsonProperty(value="results") PrfValues results) {
                this.results = results;
            }

            public Optional<PrfValues> getResults() {
                return Optional.ofNullable(this.results);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PrfAuthenticationOutput)) {
                    return false;
                }
                PrfAuthenticationOutput other = (PrfAuthenticationOutput)o;
                Optional<PrfValues> this$results = this.getResults();
                Optional<PrfValues> other$results = other.getResults();
                return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<PrfValues> $results = this.getResults();
                result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.Prf.PrfAuthenticationOutput(results=" + this.getResults() + ")";
            }
        }

        public static final class PrfAuthenticationInput {
            @JsonProperty
            private final PrfValues eval;
            @JsonProperty
            private final Map<ByteArray, PrfValues> evalByCredential;

            @JsonCreator
            private PrfAuthenticationInput(@JsonProperty(value="eval") PrfValues eval, @JsonProperty(value="evalByCredential") Map<ByteArray, PrfValues> evalByCredential) {
                this.eval = eval;
                this.evalByCredential = evalByCredential == null ? null : Collections.unmodifiableMap(evalByCredential);
            }

            public Optional<PrfValues> getEval() {
                return Optional.ofNullable(this.eval);
            }

            public Optional<Map<ByteArray, PrfValues>> getEvalByCredential() {
                return Optional.ofNullable(this.evalByCredential);
            }

            private static HashMap<ByteArray, PrfValues> descriptorsToIds(Map<PublicKeyCredentialDescriptor, PrfValues> evalByCredential) {
                return evalByCredential.entrySet().stream().reduce(new HashMap(), (ebc, entry) -> {
                    ebc.put(((PublicKeyCredentialDescriptor)entry.getKey()).getId(), (PrfValues)entry.getValue());
                    return ebc;
                }, (a, b) -> {
                    a.putAll(b);
                    return a;
                });
            }

            public static PrfAuthenticationInput eval(@NonNull PrfValues eval) {
                if (eval == null) {
                    throw new NullPointerException("eval is marked non-null but is null");
                }
                return new PrfAuthenticationInput(eval, null);
            }

            public static PrfAuthenticationInput evalByCredential(@NonNull Map<PublicKeyCredentialDescriptor, PrfValues> evalByCredential) {
                if (evalByCredential == null) {
                    throw new NullPointerException("evalByCredential is marked non-null but is null");
                }
                return new PrfAuthenticationInput(null, PrfAuthenticationInput.descriptorsToIds(evalByCredential));
            }

            public static PrfAuthenticationInput evalByCredentialWithFallback(@NonNull Map<PublicKeyCredentialDescriptor, PrfValues> evalByCredential, @NonNull PrfValues eval) {
                if (evalByCredential == null) {
                    throw new NullPointerException("evalByCredential is marked non-null but is null");
                }
                if (eval == null) {
                    throw new NullPointerException("eval is marked non-null but is null");
                }
                return new PrfAuthenticationInput(eval, PrfAuthenticationInput.descriptorsToIds(evalByCredential));
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PrfAuthenticationInput)) {
                    return false;
                }
                PrfAuthenticationInput other = (PrfAuthenticationInput)o;
                Optional<PrfValues> this$eval = this.getEval();
                Optional<PrfValues> other$eval = other.getEval();
                if (this$eval == null ? other$eval != null : !((Object)this$eval).equals(other$eval)) {
                    return false;
                }
                Optional<Map<ByteArray, PrfValues>> this$evalByCredential = this.getEvalByCredential();
                Optional<Map<ByteArray, PrfValues>> other$evalByCredential = other.getEvalByCredential();
                return !(this$evalByCredential == null ? other$evalByCredential != null : !((Object)this$evalByCredential).equals(other$evalByCredential));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<PrfValues> $eval = this.getEval();
                result = result * 59 + ($eval == null ? 43 : ((Object)$eval).hashCode());
                Optional<Map<ByteArray, PrfValues>> $evalByCredential = this.getEvalByCredential();
                result = result * 59 + ($evalByCredential == null ? 43 : ((Object)$evalByCredential).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.Prf.PrfAuthenticationInput(eval=" + this.getEval() + ", evalByCredential=" + this.getEvalByCredential() + ")";
            }
        }

        public static final class PrfRegistrationOutput {
            @JsonProperty
            private final Boolean enabled;
            @JsonProperty
            private final PrfValues results;

            @JsonCreator
            PrfRegistrationOutput(@JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="results") PrfValues results) {
                this.enabled = enabled;
                this.results = results;
            }

            public Optional<Boolean> getEnabled() {
                return Optional.ofNullable(this.enabled);
            }

            public Optional<PrfValues> getResults() {
                return Optional.ofNullable(this.results);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PrfRegistrationOutput)) {
                    return false;
                }
                PrfRegistrationOutput other = (PrfRegistrationOutput)o;
                Optional<Boolean> this$enabled = this.getEnabled();
                Optional<Boolean> other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Optional<PrfValues> this$results = this.getResults();
                Optional<PrfValues> other$results = other.getResults();
                return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<Boolean> $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Optional<PrfValues> $results = this.getResults();
                result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.Prf.PrfRegistrationOutput(enabled=" + this.getEnabled() + ", results=" + this.getResults() + ")";
            }
        }

        public static final class PrfRegistrationInput {
            @JsonProperty
            private final PrfValues eval;

            @JsonCreator
            private PrfRegistrationInput(@JsonProperty(value="eval") PrfValues eval) {
                this.eval = eval;
            }

            public Optional<PrfValues> getEval() {
                return Optional.ofNullable(this.eval);
            }

            public static PrfRegistrationInput enable() {
                return new PrfRegistrationInput(null);
            }

            public static PrfRegistrationInput eval(@NonNull PrfValues eval) {
                if (eval == null) {
                    throw new NullPointerException("eval is marked non-null but is null");
                }
                return new PrfRegistrationInput(eval);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PrfRegistrationInput)) {
                    return false;
                }
                PrfRegistrationInput other = (PrfRegistrationInput)o;
                Optional<PrfValues> this$eval = this.getEval();
                Optional<PrfValues> other$eval = other.getEval();
                return !(this$eval == null ? other$eval != null : !((Object)this$eval).equals(other$eval));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<PrfValues> $eval = this.getEval();
                result = result * 59 + ($eval == null ? 43 : ((Object)$eval).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.Prf.PrfRegistrationInput(eval=" + this.getEval() + ")";
            }
        }

        public static final class PrfValues {
            @JsonProperty
            @NonNull
            private final ByteArray first;
            @JsonProperty
            private final ByteArray second;

            @JsonCreator
            private PrfValues(@JsonProperty(value="first") @NonNull ByteArray first, @JsonProperty(value="second") ByteArray second) {
                if (first == null) {
                    throw new NullPointerException("first is marked non-null but is null");
                }
                this.first = first;
                this.second = second;
            }

            public Optional<ByteArray> getSecond() {
                return Optional.ofNullable(this.second);
            }

            public static PrfValues one(@NonNull ByteArray first) {
                if (first == null) {
                    throw new NullPointerException("first is marked non-null but is null");
                }
                return new PrfValues(first, null);
            }

            public static PrfValues two(@NonNull ByteArray first, @NonNull ByteArray second) {
                if (first == null) {
                    throw new NullPointerException("first is marked non-null but is null");
                }
                if (second == null) {
                    throw new NullPointerException("second is marked non-null but is null");
                }
                return new PrfValues(first, second);
            }

            public static PrfValues oneOrTwo(@NonNull ByteArray first, @NonNull Optional<ByteArray> second) {
                if (first == null) {
                    throw new NullPointerException("first is marked non-null but is null");
                }
                if (second == null) {
                    throw new NullPointerException("second is marked non-null but is null");
                }
                return new PrfValues(first, second.orElse(null));
            }

            @NonNull
            @Generated
            public ByteArray getFirst() {
                return this.first;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PrfValues)) {
                    return false;
                }
                PrfValues other = (PrfValues)o;
                ByteArray this$first = this.getFirst();
                ByteArray other$first = other.getFirst();
                if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
                    return false;
                }
                Optional<ByteArray> this$second = this.getSecond();
                Optional<ByteArray> other$second = other.getSecond();
                return !(this$second == null ? other$second != null : !((Object)this$second).equals(other$second));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ByteArray $first = this.getFirst();
                result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
                Optional<ByteArray> $second = this.getSecond();
                result = result * 59 + ($second == null ? 43 : ((Object)$second).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.Prf.PrfValues(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
            }
        }
    }

    public static class LargeBlob {
        static final String EXTENSION_ID = "largeBlob";

        public static final class LargeBlobAuthenticationOutput {
            @JsonProperty
            private final ByteArray blob;
            @JsonProperty
            private final Boolean written;

            @JsonCreator
            private LargeBlobAuthenticationOutput(@JsonProperty(value="blob") ByteArray blob, @JsonProperty(value="written") Boolean written) {
                this.blob = blob;
                this.written = written;
            }

            public static LargeBlobAuthenticationOutput read(ByteArray blob) {
                return new LargeBlobAuthenticationOutput(blob, null);
            }

            public static LargeBlobAuthenticationOutput write(boolean write) {
                return new LargeBlobAuthenticationOutput(null, write);
            }

            public Optional<ByteArray> getBlob() {
                return Optional.ofNullable(this.blob);
            }

            public Optional<Boolean> getWritten() {
                return Optional.ofNullable(this.written);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LargeBlobAuthenticationOutput)) {
                    return false;
                }
                LargeBlobAuthenticationOutput other = (LargeBlobAuthenticationOutput)o;
                Optional<Boolean> this$written = this.getWritten();
                Optional<Boolean> other$written = other.getWritten();
                if (this$written == null ? other$written != null : !((Object)this$written).equals(other$written)) {
                    return false;
                }
                Optional<ByteArray> this$blob = this.getBlob();
                Optional<ByteArray> other$blob = other.getBlob();
                return !(this$blob == null ? other$blob != null : !((Object)this$blob).equals(other$blob));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<Boolean> $written = this.getWritten();
                result = result * 59 + ($written == null ? 43 : ((Object)$written).hashCode());
                Optional<ByteArray> $blob = this.getBlob();
                result = result * 59 + ($blob == null ? 43 : ((Object)$blob).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.LargeBlob.LargeBlobAuthenticationOutput(blob=" + this.getBlob() + ", written=" + this.getWritten() + ")";
            }
        }

        public static final class LargeBlobRegistrationOutput {
            @JsonProperty
            private final boolean supported;

            @JsonCreator
            private LargeBlobRegistrationOutput(@JsonProperty(value="supported") boolean supported) {
                this.supported = supported;
            }

            public static LargeBlobRegistrationOutput supported(boolean supported) {
                return new LargeBlobRegistrationOutput(supported);
            }

            @Generated
            public boolean isSupported() {
                return this.supported;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LargeBlobRegistrationOutput)) {
                    return false;
                }
                LargeBlobRegistrationOutput other = (LargeBlobRegistrationOutput)o;
                return this.isSupported() == other.isSupported();
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isSupported() ? 79 : 97);
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.LargeBlob.LargeBlobRegistrationOutput(supported=" + this.isSupported() + ")";
            }
        }

        public static final class LargeBlobAuthenticationInput {
            @JsonProperty
            private final boolean read;
            @JsonProperty
            private final ByteArray write;

            @JsonCreator
            private LargeBlobAuthenticationInput(@JsonProperty(value="read") Boolean read, @JsonProperty(value="write") ByteArray write) {
                if (read != null && read.booleanValue() && write != null) {
                    throw new IllegalArgumentException("Parameters \"read\" and \"write\" of largeBlob extension must not both be present.");
                }
                this.read = read != null && read != false;
                this.write = write;
            }

            public static LargeBlobAuthenticationInput read() {
                return new LargeBlobAuthenticationInput(true, null);
            }

            public static LargeBlobAuthenticationInput write(@NonNull ByteArray write) {
                if (write == null) {
                    throw new NullPointerException("write is marked non-null but is null");
                }
                return new LargeBlobAuthenticationInput(false, write);
            }

            public boolean getRead() {
                return this.read;
            }

            public Optional<ByteArray> getWrite() {
                return Optional.ofNullable(this.write);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LargeBlobAuthenticationInput)) {
                    return false;
                }
                LargeBlobAuthenticationInput other = (LargeBlobAuthenticationInput)o;
                if (this.getRead() != other.getRead()) {
                    return false;
                }
                Optional<ByteArray> this$write = this.getWrite();
                Optional<ByteArray> other$write = other.getWrite();
                return !(this$write == null ? other$write != null : !((Object)this$write).equals(other$write));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.getRead() ? 79 : 97);
                Optional<ByteArray> $write = this.getWrite();
                result = result * 59 + ($write == null ? 43 : ((Object)$write).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.LargeBlob.LargeBlobAuthenticationInput(read=" + this.getRead() + ", write=" + this.getWrite() + ")";
            }
        }

        public static final class LargeBlobRegistrationInput {
            @JsonProperty
            private final LargeBlobSupport support;

            @JsonCreator
            public LargeBlobRegistrationInput(@JsonProperty(value="support") LargeBlobSupport support) {
                this.support = support;
            }

            @Generated
            public LargeBlobSupport getSupport() {
                return this.support;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LargeBlobRegistrationInput)) {
                    return false;
                }
                LargeBlobRegistrationInput other = (LargeBlobRegistrationInput)o;
                LargeBlobSupport this$support = this.getSupport();
                LargeBlobSupport other$support = other.getSupport();
                return !(this$support == null ? other$support != null : !((Object)this$support).equals(other$support));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                LargeBlobSupport $support = this.getSupport();
                result = result * 59 + ($support == null ? 43 : ((Object)$support).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.LargeBlob.LargeBlobRegistrationInput(support=" + this.getSupport() + ")";
            }

            public static final class LargeBlobSupport {
                public static final LargeBlobSupport REQUIRED = new LargeBlobSupport("required");
                public static final LargeBlobSupport PREFERRED = new LargeBlobSupport("preferred");
                @JsonValue
                private final String value;

                public static Set<LargeBlobSupport> values() {
                    return Stream.of(REQUIRED, PREFERRED).collect(Collectors.toSet());
                }

                @Generated
                public LargeBlobSupport(String value) {
                    this.value = value;
                }

                @Generated
                public String getValue() {
                    return this.value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LargeBlobSupport)) {
                        return false;
                    }
                    LargeBlobSupport other = (LargeBlobSupport)o;
                    String this$value = this.getValue();
                    String other$value = other.getValue();
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "Extensions.LargeBlob.LargeBlobRegistrationInput.LargeBlobSupport(value=" + this.getValue() + ")";
                }
            }
        }
    }

    public static class CredentialProtection {
        static final String EXTENSION_ID = "credProtect";

        public static void validateExtensionOutput(PublicKeyCredentialCreationOptions request, PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response) {
            request.getExtensions().getCredProtect().ifPresent(credProtectInput -> {
                if (credProtectInput.isEnforceCredentialProtectionPolicy() && credProtectInput.getCredentialProtectionPolicy() != CredentialProtectionPolicy.UV_OPTIONAL) {
                    Optional outputPolicy = ((AuthenticatorAttestationResponse)response.getResponse()).getParsedAuthenticatorData().getExtensions().flatMap(CredentialProtection::parseAuthenticatorExtensionOutput);
                    ExceptionUtil.assertTrue((boolean)outputPolicy.equals(Optional.of(credProtectInput.getCredentialProtectionPolicy())), (String)"Unsatisfied credProtect policy: required %s, got: %s", (Object[])new Object[]{credProtectInput.getCredentialProtectionPolicy(), outputPolicy});
                }
            });
        }

        static Optional<CredentialProtectionPolicy> parseAuthenticatorExtensionOutput(CBORObject cbor) {
            return Optional.ofNullable(cbor.get(EXTENSION_ID)).map(cborObject -> cborObject.isNumber() && cborObject.AsNumber().IsInteger() ? Integer.valueOf(cborObject.AsInt32()) : null).flatMap(x$0 -> CredentialProtectionPolicy.fromCbor(x$0));
        }

        public static enum CredentialProtectionPolicy {
            UV_OPTIONAL(1, "userVerificationOptional"),
            UV_OPTIONAL_WITH_CREDENTIAL_ID_LIST(2, "userVerificationOptionalWithCredentialIDList"),
            UV_REQUIRED(3, "userVerificationRequired");

            final int cborValue;
            @JsonValue
            private final String jsValue;

            private static Optional<CredentialProtectionPolicy> fromCbor(int cborValue) {
                return Arrays.stream(CredentialProtectionPolicy.values()).filter(policy -> policy.cborValue == cborValue).findAny();
            }

            private static Optional<CredentialProtectionPolicy> fromJs(String jsonValue) {
                return Arrays.stream(CredentialProtectionPolicy.values()).filter(policy -> policy.jsValue.equals(jsonValue)).findAny();
            }

            @JsonCreator
            private static CredentialProtectionPolicy fromJsonString(@NonNull String value) {
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                return CredentialProtectionPolicy.fromJs(value).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown %s value: %s", CredentialProtectionPolicy.class.getSimpleName(), value)));
            }

            @Generated
            private CredentialProtectionPolicy(int cborValue, String jsValue) {
                this.cborValue = cborValue;
                this.jsValue = jsValue;
            }
        }

        public static final class CredentialProtectionInput {
            private final CredentialProtectionPolicy credentialProtectionPolicy;
            private final boolean enforceCredentialProtectionPolicy;

            @JsonCreator
            private CredentialProtectionInput(@JsonProperty(value="credentialProtectionPolicy") CredentialProtectionPolicy credentialProtectionPolicy, @JsonProperty(value="enforceCredentialProtectionPolicy") Boolean enforceCredentialProtectionPolicy) {
                this.credentialProtectionPolicy = credentialProtectionPolicy;
                this.enforceCredentialProtectionPolicy = enforceCredentialProtectionPolicy != null && enforceCredentialProtectionPolicy != false;
            }

            public static CredentialProtectionInput prefer(@NonNull CredentialProtectionPolicy policy) {
                if (policy == null) {
                    throw new NullPointerException("policy is marked non-null but is null");
                }
                return new CredentialProtectionInput(policy, false);
            }

            public static CredentialProtectionInput require(@NonNull CredentialProtectionPolicy policy) {
                if (policy == null) {
                    throw new NullPointerException("policy is marked non-null but is null");
                }
                return new CredentialProtectionInput(policy, true);
            }

            @Generated
            public CredentialProtectionPolicy getCredentialProtectionPolicy() {
                return this.credentialProtectionPolicy;
            }

            @Generated
            public boolean isEnforceCredentialProtectionPolicy() {
                return this.enforceCredentialProtectionPolicy;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CredentialProtectionInput)) {
                    return false;
                }
                CredentialProtectionInput other = (CredentialProtectionInput)o;
                if (this.isEnforceCredentialProtectionPolicy() != other.isEnforceCredentialProtectionPolicy()) {
                    return false;
                }
                CredentialProtectionPolicy this$credentialProtectionPolicy = this.getCredentialProtectionPolicy();
                CredentialProtectionPolicy other$credentialProtectionPolicy = other.getCredentialProtectionPolicy();
                return !(this$credentialProtectionPolicy == null ? other$credentialProtectionPolicy != null : !((Object)((Object)this$credentialProtectionPolicy)).equals((Object)other$credentialProtectionPolicy));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isEnforceCredentialProtectionPolicy() ? 79 : 97);
                CredentialProtectionPolicy $credentialProtectionPolicy = this.getCredentialProtectionPolicy();
                result = result * 59 + ($credentialProtectionPolicy == null ? 43 : ((Object)((Object)$credentialProtectionPolicy)).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.CredentialProtection.CredentialProtectionInput(credentialProtectionPolicy=" + (Object)((Object)this.getCredentialProtectionPolicy()) + ", enforceCredentialProtectionPolicy=" + this.isEnforceCredentialProtectionPolicy() + ")";
            }
        }
    }

    public static class CredentialProperties {
        static final String EXTENSION_ID = "credProps";

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class CredentialPropertiesOutput {
            @JsonProperty(value="rk")
            private final Boolean rk;

            @JsonCreator
            private CredentialPropertiesOutput(@JsonProperty(value="rk") Boolean rk) {
                this.rk = rk;
            }

            public Optional<Boolean> getRk() {
                return Optional.ofNullable(this.rk);
            }

            @Generated
            public static CredentialPropertiesOutputBuilder builder() {
                return new CredentialPropertiesOutputBuilder();
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CredentialPropertiesOutput)) {
                    return false;
                }
                CredentialPropertiesOutput other = (CredentialPropertiesOutput)o;
                Optional<Boolean> this$rk = this.getRk();
                Optional<Boolean> other$rk = other.getRk();
                return !(this$rk == null ? other$rk != null : !((Object)this$rk).equals(other$rk));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<Boolean> $rk = this.getRk();
                result = result * 59 + ($rk == null ? 43 : ((Object)$rk).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.CredentialProperties.CredentialPropertiesOutput(rk=" + this.getRk() + ")";
            }

            @Generated
            public static class CredentialPropertiesOutputBuilder {
                @Generated
                private Boolean rk;

                @Generated
                CredentialPropertiesOutputBuilder() {
                }

                @JsonProperty(value="rk")
                @Generated
                public CredentialPropertiesOutputBuilder rk(Boolean rk) {
                    this.rk = rk;
                    return this;
                }

                @Generated
                public CredentialPropertiesOutput build() {
                    return new CredentialPropertiesOutput(this.rk);
                }

                @Generated
                public String toString() {
                    return "Extensions.CredentialProperties.CredentialPropertiesOutput.CredentialPropertiesOutputBuilder(rk=" + this.rk + ")";
                }
            }
        }
    }

    public static class AppidExclude {
        static final String EXTENSION_ID = "appidExclude";
    }

    public static class Appid {
        static final String EXTENSION_ID = "appid";
    }
}

