/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.ExtensionInputs;
import com.yubico.webauthn.data.Extensions;
import com.yubico.webauthn.extension.appid.AppId;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class RegistrationExtensionInputs
implements ExtensionInputs {
    private final AppId appidExclude;
    private final Boolean credProps;
    private final Extensions.CredentialProtection.CredentialProtectionInput credProtect;
    private final Extensions.LargeBlob.LargeBlobRegistrationInput largeBlob;
    private final Extensions.Prf.PrfRegistrationInput prf;
    private final Boolean uvm;

    private RegistrationExtensionInputs(AppId appidExclude, Boolean credProps, Extensions.CredentialProtection.CredentialProtectionInput credProtect, Extensions.LargeBlob.LargeBlobRegistrationInput largeBlob, Extensions.Prf.PrfRegistrationInput prf, Boolean uvm) {
        this.appidExclude = appidExclude;
        this.credProps = credProps;
        this.credProtect = credProtect;
        this.largeBlob = largeBlob;
        this.prf = prf;
        this.uvm = uvm;
    }

    @JsonCreator
    private RegistrationExtensionInputs(@JsonProperty(value="appidExclude") AppId appidExclude, @JsonProperty(value="credProps") Boolean credProps, @JsonProperty(value="credentialProtectionPolicy") Extensions.CredentialProtection.CredentialProtectionPolicy credProtectPolicy, @JsonProperty(value="enforceCredentialProtectionPolicy") Boolean enforceCredProtectPolicy, @JsonProperty(value="largeBlob") Extensions.LargeBlob.LargeBlobRegistrationInput largeBlob, @JsonProperty(value="prf") Extensions.Prf.PrfRegistrationInput prf, @JsonProperty(value="uvm") Boolean uvm) {
        this(appidExclude, credProps, Optional.ofNullable(credProtectPolicy).map(policy -> enforceCredProtectPolicy != null && enforceCredProtectPolicy != false ? Extensions.CredentialProtection.CredentialProtectionInput.require(policy) : Extensions.CredentialProtection.CredentialProtectionInput.prefer(policy)).orElse(null), largeBlob, prf, uvm);
    }

    public RegistrationExtensionInputs merge(RegistrationExtensionInputs other) {
        return new RegistrationExtensionInputs(this.appidExclude != null ? this.appidExclude : other.appidExclude, this.credProps != null ? this.credProps : other.credProps, this.credProtect != null ? this.credProtect : other.credProtect, this.largeBlob != null ? this.largeBlob : other.largeBlob, this.prf != null ? this.prf : other.prf, this.uvm != null ? this.uvm : other.uvm);
    }

    public Optional<AppId> getAppidExclude() {
        return Optional.ofNullable(this.appidExclude);
    }

    public boolean getCredProps() {
        return this.credProps != null && this.credProps != false;
    }

    @JsonProperty(value="credProps")
    private Boolean getCredPropsJson() {
        return this.getCredProps() ? Boolean.valueOf(true) : null;
    }

    @JsonIgnore
    public Optional<Extensions.CredentialProtection.CredentialProtectionInput> getCredProtect() {
        return Optional.ofNullable(this.credProtect);
    }

    @JsonProperty(value="credentialProtectionPolicy")
    private Optional<Extensions.CredentialProtection.CredentialProtectionPolicy> getCredProtectPolicy() {
        return this.getCredProtect().map(Extensions.CredentialProtection.CredentialProtectionInput::getCredentialProtectionPolicy);
    }

    @JsonProperty(value="enforceCredentialProtectionPolicy")
    private Optional<Boolean> getEnforceCredProtectPolicy() {
        return this.getCredProtect().map(Extensions.CredentialProtection.CredentialProtectionInput::isEnforceCredentialProtectionPolicy);
    }

    public Optional<Extensions.LargeBlob.LargeBlobRegistrationInput> getLargeBlob() {
        return Optional.ofNullable(this.largeBlob);
    }

    public Optional<Extensions.Prf.PrfRegistrationInput> getPrf() {
        return Optional.ofNullable(this.prf);
    }

    public boolean getUvm() {
        return this.uvm != null && this.uvm != false;
    }

    @JsonProperty(value="uvm")
    private Boolean getUvmJson() {
        return this.getUvm() ? Boolean.valueOf(true) : null;
    }

    @Override
    public Set<String> getExtensionIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.appidExclude != null) {
            ids.add("appidExclude");
        }
        if (this.getCredProps()) {
            ids.add("credProps");
        }
        if (this.getCredProtect().isPresent()) {
            ids.add("credProtect");
        }
        if (this.largeBlob != null) {
            ids.add("largeBlob");
        }
        if (this.prf != null) {
            ids.add("prf");
        }
        if (this.getUvm()) {
            ids.add("uvm");
        }
        return Collections.unmodifiableSet(ids);
    }

    @Generated
    public static RegistrationExtensionInputsBuilder builder() {
        return new RegistrationExtensionInputsBuilder();
    }

    @Generated
    public RegistrationExtensionInputsBuilder toBuilder() {
        return new RegistrationExtensionInputsBuilder().appidExclude(this.appidExclude).credProps(this.credProps).credProtect(this.credProtect).largeBlob(this.largeBlob).prf(this.prf).uvm(this.uvm);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistrationExtensionInputs)) {
            return false;
        }
        RegistrationExtensionInputs other = (RegistrationExtensionInputs)o;
        if (this.getCredProps() != other.getCredProps()) {
            return false;
        }
        if (this.getUvm() != other.getUvm()) {
            return false;
        }
        Optional<AppId> this$appidExclude = this.getAppidExclude();
        Optional<AppId> other$appidExclude = other.getAppidExclude();
        if (this$appidExclude == null ? other$appidExclude != null : !((Object)this$appidExclude).equals(other$appidExclude)) {
            return false;
        }
        Optional<Extensions.CredentialProtection.CredentialProtectionInput> this$credProtect = this.getCredProtect();
        Optional<Extensions.CredentialProtection.CredentialProtectionInput> other$credProtect = other.getCredProtect();
        if (this$credProtect == null ? other$credProtect != null : !((Object)this$credProtect).equals(other$credProtect)) {
            return false;
        }
        Optional<Extensions.LargeBlob.LargeBlobRegistrationInput> this$largeBlob = this.getLargeBlob();
        Optional<Extensions.LargeBlob.LargeBlobRegistrationInput> other$largeBlob = other.getLargeBlob();
        if (this$largeBlob == null ? other$largeBlob != null : !((Object)this$largeBlob).equals(other$largeBlob)) {
            return false;
        }
        Optional<Extensions.Prf.PrfRegistrationInput> this$prf = this.getPrf();
        Optional<Extensions.Prf.PrfRegistrationInput> other$prf = other.getPrf();
        return !(this$prf == null ? other$prf != null : !((Object)this$prf).equals(other$prf));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getCredProps() ? 79 : 97);
        result = result * 59 + (this.getUvm() ? 79 : 97);
        Optional<AppId> $appidExclude = this.getAppidExclude();
        result = result * 59 + ($appidExclude == null ? 43 : ((Object)$appidExclude).hashCode());
        Optional<Extensions.CredentialProtection.CredentialProtectionInput> $credProtect = this.getCredProtect();
        result = result * 59 + ($credProtect == null ? 43 : ((Object)$credProtect).hashCode());
        Optional<Extensions.LargeBlob.LargeBlobRegistrationInput> $largeBlob = this.getLargeBlob();
        result = result * 59 + ($largeBlob == null ? 43 : ((Object)$largeBlob).hashCode());
        Optional<Extensions.Prf.PrfRegistrationInput> $prf = this.getPrf();
        result = result * 59 + ($prf == null ? 43 : ((Object)$prf).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegistrationExtensionInputs(appidExclude=" + this.getAppidExclude() + ", credProps=" + this.getCredProps() + ", credProtect=" + this.getCredProtect() + ", largeBlob=" + this.getLargeBlob() + ", prf=" + this.getPrf() + ", uvm=" + this.getUvm() + ")";
    }

    public static class RegistrationExtensionInputsBuilder {
        @Generated
        private AppId appidExclude;
        @Generated
        private Boolean credProps;
        @Generated
        private Extensions.CredentialProtection.CredentialProtectionInput credProtect;
        @Generated
        private Extensions.LargeBlob.LargeBlobRegistrationInput largeBlob;
        @Generated
        private Extensions.Prf.PrfRegistrationInput prf;
        @Generated
        private Boolean uvm;

        public RegistrationExtensionInputsBuilder appidExclude(Optional<AppId> appidExclude) {
            this.appidExclude = appidExclude.orElse(null);
            return this;
        }

        public RegistrationExtensionInputsBuilder appidExclude(AppId appidExclude) {
            this.appidExclude = appidExclude;
            return this;
        }

        public RegistrationExtensionInputsBuilder credProps() {
            this.credProps = true;
            return this;
        }

        public RegistrationExtensionInputsBuilder credProps(Boolean credProps) {
            this.credProps = credProps;
            return this;
        }

        public RegistrationExtensionInputsBuilder credProtect(Optional<Extensions.CredentialProtection.CredentialProtectionInput> credProtect) {
            this.credProtect = credProtect.orElse(null);
            return this;
        }

        public RegistrationExtensionInputsBuilder credProtect(Extensions.CredentialProtection.CredentialProtectionInput credProtect) {
            this.credProtect = credProtect;
            return this;
        }

        public RegistrationExtensionInputsBuilder largeBlob(Extensions.LargeBlob.LargeBlobRegistrationInput.LargeBlobSupport support) {
            this.largeBlob = new Extensions.LargeBlob.LargeBlobRegistrationInput(support);
            return this;
        }

        public RegistrationExtensionInputsBuilder largeBlob(Extensions.LargeBlob.LargeBlobRegistrationInput largeBlob) {
            this.largeBlob = largeBlob;
            return this;
        }

        public RegistrationExtensionInputsBuilder prf(Extensions.Prf.PrfRegistrationInput prf) {
            this.prf = prf;
            return this;
        }

        public RegistrationExtensionInputsBuilder uvm() {
            this.uvm = true;
            return this;
        }

        private RegistrationExtensionInputsBuilder uvm(Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        @Generated
        RegistrationExtensionInputsBuilder() {
        }

        @Generated
        public RegistrationExtensionInputs build() {
            return new RegistrationExtensionInputs(this.appidExclude, this.credProps, this.credProtect, this.largeBlob, this.prf, this.uvm);
        }

        @Generated
        public String toString() {
            return "RegistrationExtensionInputs.RegistrationExtensionInputsBuilder(appidExclude=" + this.appidExclude + ", credProps=" + this.credProps + ", credProtect=" + this.credProtect + ", largeBlob=" + this.largeBlob + ", prf=" + this.prf + ", uvm=" + this.uvm + ")";
        }
    }
}

