/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.decoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.binding.impl.SAMLSOAPDecoderBodyHandler;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.slf4j.Logger;

public class HTTPSOAP11Decoder
extends org.opensaml.soap.soap11.decoder.http.impl.HTTPSOAP11Decoder
implements SAMLMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Decoder.class);
    @Nullable
    private BindingDescriptor bindingDescriptor;

    public HTTPSOAP11Decoder() {
        this.setProtocolMessageLoggerSubCategory("SAML");
    }

    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding";
    }

    @Nullable
    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    public void setBindingDescriptor(@Nullable BindingDescriptor descriptor) {
        this.bindingDescriptor = descriptor;
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.getBodyHandler() == null) {
            SAMLSOAPDecoderBodyHandler handler = new SAMLSOAPDecoderBodyHandler();
            handler.initialize();
            this.setBodyHandler((MessageHandler)handler);
        }
        super.doInitialize();
    }

    protected void doDecode() throws MessageDecodingException {
        super.doDecode();
        MessageContext msgCtx = this.getMessageContext();
        assert (msgCtx != null);
        this.populateBindingContext(msgCtx);
        Object samlMessage = msgCtx.getMessage();
        if (!(samlMessage instanceof SAMLObject)) {
            throw new MessageDecodingException("Decoded message was not a SAMLObject");
        }
        this.log.debug("Decoded SOAP messaged which included SAML message of type {}", (Object)((SAMLObject)samlMessage).getElementQName());
    }

    protected void populateBindingContext(@Nonnull MessageContext messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.ensureSubcontext(SAMLBindingContext.class);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.bindingDescriptor);
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }
}

