/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.tomcat.util.descriptor.web.ContextEjb;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextLocalEjb;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextResourceLink;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.MessageDestinationRef;
import org.apache.tomcat.util.descriptor.web.ResourceBase;

public class OpenEJBNamingResource
extends NamingResourcesImpl {
    private static final String JAVA_PREFIX = "java:";
    private boolean isTomcatResource;
    private final Collection<ResourceBase> tomcatResources = new ArrayList<ResourceBase>();

    public OpenEJBNamingResource() {
    }

    public OpenEJBNamingResource(NamingResourcesImpl namingResources) {
        if (namingResources != null) {
            this.isTomcatResource = true;
            for (ContextResource contextResource : namingResources.findResources()) {
                this.addResource(contextResource);
            }
            for (ContextResource contextResource : namingResources.findResourceEnvRefs()) {
                this.addResourceEnvRef((ContextResourceEnvRef)contextResource);
            }
            for (ContextResource contextResource : namingResources.findEjbs()) {
                this.addEjb((ContextEjb)contextResource);
            }
            for (ContextResource contextResource : namingResources.findLocalEjbs()) {
                this.addLocalEjb((ContextLocalEjb)contextResource);
            }
            for (ContextResource contextResource : namingResources.findResourceLinks()) {
                this.addResourceLink((ContextResourceLink)contextResource);
            }
            for (ContextResource contextResource : namingResources.findServices()) {
                this.addService((ContextService)contextResource);
            }
            for (ContextResource contextResource : namingResources.findMessageDestinationRefs()) {
                this.addMessageDestinationRef((MessageDestinationRef)contextResource);
            }
            for (ContextResource contextResource : namingResources.findEnvironments()) {
                this.addEnvironment((ContextEnvironment)contextResource);
            }
            this.isTomcatResource = false;
        }
    }

    public void addEnvironment(ContextEnvironment environment) {
        this.normalize((ResourceBase)environment);
        super.addEnvironment(environment);
    }

    public void addResourceEnvRef(ContextResourceEnvRef ref) {
        this.normalize((ResourceBase)ref);
        super.addResourceEnvRef(ref);
    }

    public void addEjb(ContextEjb ref) {
        this.normalize((ResourceBase)ref);
        super.addEjb(ref);
    }

    public void addLocalEjb(ContextLocalEjb ref) {
        this.normalize((ResourceBase)ref);
        super.addLocalEjb(ref);
    }

    public void addResource(ContextResource ref) {
        this.normalize((ResourceBase)ref);
        super.addResource(ref);
        if (this.isTomcatResource) {
            this.pushResourceToAddInOpenEJB(ref);
        }
    }

    public void addMessageDestinationRef(MessageDestinationRef ref) {
        this.normalize((ResourceBase)ref);
        super.addMessageDestinationRef(ref);
    }

    public void addService(ContextService ref) {
        this.normalize((ResourceBase)ref);
        super.addService(ref);
    }

    public void addResourceLink(ContextResourceLink ref) {
        this.normalize((ResourceBase)ref);
        super.addResourceLink(ref);
    }

    private void normalize(ResourceBase ref) {
        String name = ref.getName();
        if (name.startsWith(JAVA_PREFIX)) {
            ref.setName(name.substring(JAVA_PREFIX.length()));
        } else if (name.startsWith("openejb/Resource/")) {
            String id = (String)ref.getProperty("resourceid");
            if (id != null) {
                ref.setProperty("jndiname", (Object)("openejb:Resource/" + id));
            } else {
                ref.setProperty("jndiname", (Object)("openejb:" + name.substring("openejb/".length())));
            }
        }
        if (ref.getType() == null) {
            ref.setType("");
        }
    }

    public void setTomcatResource(boolean tomcatResource) {
        this.isTomcatResource = tomcatResource;
    }

    private void pushResourceToAddInOpenEJB(ContextResource ref) {
        this.tomcatResources.add((ResourceBase)ref);
    }

    public Collection<ResourceBase> getTomcatResources() {
        return this.tomcatResources;
    }
}

