/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openejb.jee.BooleanAdapter;
import org.apache.openejb.jee.CmpField;
import org.apache.openejb.jee.CmpVersion;
import org.apache.openejb.jee.ContextService;
import org.apache.openejb.jee.DataSource;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.JMSConnectionFactory;
import org.apache.openejb.jee.JMSDestination;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.LocalCollection;
import org.apache.openejb.jee.ManagedExecutor;
import org.apache.openejb.jee.ManagedScheduledExecutor;
import org.apache.openejb.jee.ManagedThreadFactory;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceType;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.Query;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.SecurityIdentity;
import org.apache.openejb.jee.SecurityRoleRef;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;
import org.apache.openejb.jee.TransactionType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="entity-beanType", propOrder={"descriptions", "displayNames", "icon", "ejbName", "mappedName", "home", "remote", "localHome", "local", "ejbClass", "persistenceType", "primKeyClass", "reentrant", "cmpVersion", "abstractSchemaName", "cmpField", "primkeyField", "envEntry", "ejbRef", "ejbLocalRef", "serviceRef", "resourceRef", "resourceEnvRef", "messageDestinationRef", "persistenceContextRef", "persistenceUnitRef", "postConstruct", "preDestroy", "dataSource", "jmsConnectionFactories", "jmsDestinations", "securityRoleRef", "securityIdentity", "query", "contextService", "managedExecutor", "managedScheduledExecutor", "managedThreadFactory"})
public class EntityBean
implements RemoteBean {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlTransient
    protected TextMap displayName = new TextMap();
    @XmlElement(name="icon", required=true)
    protected LocalCollection<Icon> icon = new LocalCollection();
    @XmlElement(name="ejb-name", required=true)
    protected String ejbName;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    protected String home;
    protected String remote;
    @XmlElement(name="local-home")
    protected String localHome;
    protected String local;
    @XmlElement(name="ejb-class", required=true)
    protected String ejbClass;
    @XmlElement(name="persistence-type", required=true)
    protected PersistenceType persistenceType;
    @XmlElement(name="prim-key-class", required=true)
    protected String primKeyClass;
    @XmlJavaTypeAdapter(type=boolean.class, value=BooleanAdapter.class)
    @XmlElement(required=true)
    protected boolean reentrant;
    @XmlElement(name="cmp-version", defaultValue="2.x")
    protected CmpVersion cmpVersion;
    @XmlElement(name="abstract-schema-name")
    protected String abstractSchemaName;
    @XmlElement(name="cmp-field", required=true)
    protected List<CmpField> cmpField;
    @XmlElement(name="primkey-field")
    protected String primkeyField;
    @XmlElement(name="env-entry", required=true)
    protected KeyedCollection<String, EnvEntry> envEntry;
    @XmlElement(name="ejb-ref", required=true)
    protected KeyedCollection<String, EjbRef> ejbRef;
    @XmlElement(name="ejb-local-ref", required=true)
    protected KeyedCollection<String, EjbLocalRef> ejbLocalRef;
    @XmlElement(name="service-ref", required=true)
    protected KeyedCollection<String, ServiceRef> serviceRef;
    @XmlElement(name="resource-ref", required=true)
    protected KeyedCollection<String, ResourceRef> resourceRef;
    @XmlElement(name="resource-env-ref", required=true)
    protected KeyedCollection<String, ResourceEnvRef> resourceEnvRef;
    @XmlElement(name="message-destination-ref", required=true)
    protected KeyedCollection<String, MessageDestinationRef> messageDestinationRef;
    @XmlElement(name="persistence-context-ref", required=true)
    protected KeyedCollection<String, PersistenceContextRef> persistenceContextRef;
    @XmlElement(name="persistence-unit-ref", required=true)
    protected KeyedCollection<String, PersistenceUnitRef> persistenceUnitRef;
    @XmlElement(name="post-construct", required=true)
    protected List<LifecycleCallback> postConstruct;
    @XmlElement(name="pre-destroy", required=true)
    protected List<LifecycleCallback> preDestroy;
    @XmlElement(name="data-source")
    protected KeyedCollection<String, DataSource> dataSource;
    @XmlElement(name="jms-connection-factory", required=true)
    protected KeyedCollection<String, JMSConnectionFactory> jmsConnectionFactories;
    @XmlElement(name="jms-destination")
    protected KeyedCollection<String, JMSDestination> jmsDestinations;
    @XmlElement(name="security-role-ref", required=true)
    protected List<SecurityRoleRef> securityRoleRef;
    @XmlElement(name="security-identity")
    protected SecurityIdentity securityIdentity;
    @XmlElement(required=true)
    protected List<Query> query;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;
    @XmlElement(name="context-service")
    protected KeyedCollection<String, ContextService> contextService;
    @XmlElement(name="managed-executor")
    protected KeyedCollection<String, ManagedExecutor> managedExecutor;
    @XmlElement(name="managed-scheduled-executor")
    protected KeyedCollection<String, ManagedScheduledExecutor> managedScheduledExecutor;
    @XmlElement(name="managed-thread-factory")
    protected KeyedCollection<String, ManagedThreadFactory> managedThreadFactory;

    public EntityBean() {
        Set<String> publicIds = JaxbJavaee.currentPublicId.get();
        this.cmpVersion = publicIds != null && publicIds.contains("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN") ? CmpVersion.CMP1 : CmpVersion.CMP2;
    }

    public EntityBean(String ejbName, String ejbClass, PersistenceType persistenceType) {
        this();
        this.ejbName = ejbName;
        this.ejbClass = ejbClass;
        this.persistenceType = persistenceType;
    }

    public EntityBean(Class<?> ejbClass, PersistenceType persistenceType) {
        this(ejbClass.getSimpleName(), ejbClass.getName(), persistenceType);
    }

    @Override
    public String getJndiConsumerName() {
        return this.ejbName;
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    @XmlElement(name="display-name", required=true)
    public Text[] getDisplayNames() {
        return this.displayName.toArray();
    }

    public void setDisplayNames(Text[] text) {
        this.displayName.set(text);
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    public Collection<Icon> getIcons() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon;
    }

    public Map<String, Icon> getIconMap() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon.toMap();
    }

    public Icon getIcon() {
        return this.icon.getLocal();
    }

    @Override
    public String getEjbName() {
        return this.ejbName;
    }

    @Override
    public void setEjbName(String value) {
        this.ejbName = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public void setHome(String value) {
        this.home = value;
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Override
    public void setRemote(String value) {
        this.remote = value;
    }

    @Override
    public String getLocalHome() {
        return this.localHome;
    }

    @Override
    public void setLocalHome(String value) {
        this.localHome = value;
    }

    @Override
    public String getLocal() {
        return this.local;
    }

    @Override
    public void setLocal(String value) {
        this.local = value;
    }

    @Override
    public String getEjbClass() {
        return this.ejbClass;
    }

    @Override
    public void setEjbClass(String value) {
        this.ejbClass = value;
    }

    @Override
    public void setEjbClass(Class value) {
        this.ejbClass = value.getName();
    }

    public PersistenceType getPersistenceType() {
        return this.persistenceType;
    }

    public void setPersistenceType(PersistenceType value) {
        this.persistenceType = value;
    }

    public String getPrimKeyClass() {
        return this.primKeyClass;
    }

    public void setPrimKeyClass(String value) {
        this.primKeyClass = value;
    }

    public boolean getReentrant() {
        return this.reentrant;
    }

    public void setReentrant(boolean value) {
        this.reentrant = value;
    }

    public CmpVersion getCmpVersion() {
        return this.cmpVersion;
    }

    public void setCmpVersion(CmpVersion value) {
        this.cmpVersion = value;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String value) {
        this.abstractSchemaName = value;
    }

    public List<CmpField> getCmpField() {
        if (this.cmpField == null) {
            this.cmpField = new ArrayList<CmpField>();
        }
        return this.cmpField;
    }

    public void addCmpField(String fieldName) {
        if (fieldName == null) {
            return;
        }
        for (CmpField field : this.cmpField) {
            if (!fieldName.equals(field.getFieldName())) continue;
            return;
        }
        this.cmpField.add(new CmpField(fieldName));
    }

    public String getPrimkeyField() {
        return this.primkeyField;
    }

    public void setPrimkeyField(String value) {
        this.primkeyField = value;
    }

    @Override
    public Collection<EnvEntry> getEnvEntry() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry;
    }

    @Override
    public Map<String, EnvEntry> getEnvEntryMap() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry.toMap();
    }

    @Override
    public Collection<EjbRef> getEjbRef() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef;
    }

    @Override
    public Map<String, EjbRef> getEjbRefMap() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef.toMap();
    }

    @Override
    public Collection<EjbLocalRef> getEjbLocalRef() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef;
    }

    @Override
    public Map<String, EjbLocalRef> getEjbLocalRefMap() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef.toMap();
    }

    @Override
    public Collection<ServiceRef> getServiceRef() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef;
    }

    @Override
    public Map<String, ServiceRef> getServiceRefMap() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef.toMap();
    }

    @Override
    public Collection<ResourceRef> getResourceRef() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef;
    }

    @Override
    public Map<String, ResourceRef> getResourceRefMap() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef.toMap();
    }

    @Override
    public Collection<ResourceEnvRef> getResourceEnvRef() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef;
    }

    @Override
    public Map<String, ResourceEnvRef> getResourceEnvRefMap() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef.toMap();
    }

    @Override
    public Collection<MessageDestinationRef> getMessageDestinationRef() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef;
    }

    @Override
    public Map<String, MessageDestinationRef> getMessageDestinationRefMap() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef.toMap();
    }

    @Override
    public Collection<PersistenceContextRef> getPersistenceContextRef() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef;
    }

    @Override
    public Map<String, PersistenceContextRef> getPersistenceContextRefMap() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef.toMap();
    }

    @Override
    public Collection<PersistenceUnitRef> getPersistenceUnitRef() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef;
    }

    @Override
    public Map<String, PersistenceUnitRef> getPersistenceUnitRefMap() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef.toMap();
    }

    @Override
    public List<LifecycleCallback> getPostConstruct() {
        if (this.postConstruct == null) {
            this.postConstruct = new ArrayList<LifecycleCallback>();
        }
        return this.postConstruct;
    }

    @Override
    public void addPostConstruct(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPostConstruct().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<LifecycleCallback> getPreDestroy() {
        if (this.preDestroy == null) {
            this.preDestroy = new ArrayList<LifecycleCallback>();
        }
        return this.preDestroy;
    }

    @Override
    public void addPreDestroy(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPreDestroy().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public Collection<DataSource> getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new KeyedCollection();
        }
        return this.dataSource;
    }

    @Override
    public Map<String, DataSource> getDataSourceMap() {
        if (this.dataSource == null) {
            this.dataSource = new KeyedCollection();
        }
        return this.dataSource.toMap();
    }

    @Override
    public List<SecurityRoleRef> getSecurityRoleRef() {
        if (this.securityRoleRef == null) {
            this.securityRoleRef = new ArrayList<SecurityRoleRef>();
        }
        return this.securityRoleRef;
    }

    @Override
    public Collection<String> getBusinessLocal() {
        return Collections.emptySet();
    }

    @Override
    public Collection<String> getBusinessRemote() {
        return Collections.emptySet();
    }

    @Override
    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    @Override
    public void setSecurityIdentity(SecurityIdentity value) {
        this.securityIdentity = value;
    }

    public List<Query> getQuery() {
        if (this.query == null) {
            this.query = new ArrayList<Query>();
        }
        return this.query;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.CONTAINER;
    }

    @Override
    public void setTransactionType(TransactionType type) {
    }

    @Override
    public Collection<JMSConnectionFactory> getJMSConnectionFactories() {
        return this.jmsConnectionFactories == null ? (this.jmsConnectionFactories = new KeyedCollection()) : this.jmsConnectionFactories;
    }

    @Override
    public Map<String, JMSConnectionFactory> getJMSConnectionFactoriesMap() {
        return ((KeyedCollection)KeyedCollection.class.cast(this.getJMSConnectionFactories())).toMap();
    }

    @Override
    public Collection<JMSDestination> getJMSDestination() {
        return this.jmsDestinations == null ? (this.jmsDestinations = new KeyedCollection()) : this.jmsDestinations;
    }

    @Override
    public Map<String, JMSDestination> getJMSDestinationMap() {
        return ((KeyedCollection)KeyedCollection.class.cast(this.getJMSDestination())).toMap();
    }

    @Override
    public Map<String, ContextService> getContextServiceMap() {
        if (this.contextService == null) {
            this.contextService = new KeyedCollection();
        }
        return this.contextService.toMap();
    }

    @Override
    public Map<String, ManagedExecutor> getManagedExecutorMap() {
        if (this.managedExecutor == null) {
            this.managedExecutor = new KeyedCollection();
        }
        return this.managedExecutor.toMap();
    }

    @Override
    public Map<String, ManagedScheduledExecutor> getManagedScheduledExecutorMap() {
        if (this.managedScheduledExecutor == null) {
            this.managedScheduledExecutor = new KeyedCollection();
        }
        return this.managedScheduledExecutor.toMap();
    }

    @Override
    public Map<String, ManagedThreadFactory> getManagedThreadFactoryMap() {
        if (this.managedThreadFactory == null) {
            this.managedThreadFactory = new KeyedCollection();
        }
        return this.managedThreadFactory.toMap();
    }
}

