/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.IdGenerator;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.UniqueFilenameGenerator;
import com.github.tomakehurst.wiremock.common.VeryShortIdGenerator;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.List;
import java.util.UUID;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.Iterables;

public class StubMappingJsonRecorder
implements RequestListener {
    private final FileSource mappingsFileSource;
    private final FileSource filesFileSource;
    private final Admin admin;
    private final List<CaseInsensitiveKey> headersToMatch;
    private IdGenerator idGenerator;

    public StubMappingJsonRecorder(FileSource mappingsFileSource, FileSource filesFileSource, Admin admin, List<CaseInsensitiveKey> headersToMatch) {
        this.mappingsFileSource = mappingsFileSource;
        this.filesFileSource = filesFileSource;
        this.admin = admin;
        this.headersToMatch = headersToMatch;
        this.idGenerator = new VeryShortIdGenerator();
    }

    @Override
    public void requestReceived(Request request, Response response) {
        RequestPattern requestPattern = this.buildRequestPatternFrom(request);
        if (this.requestNotAlreadyReceived(requestPattern) && response.isFromProxy()) {
            LocalNotifier.notifier().info(String.format("Recording mappings for %s", request.getUrl()));
            this.writeToMappingAndBodyFile(request, response, requestPattern);
        } else {
            LocalNotifier.notifier().info(String.format("Not recording mapping for %s as this has already been received", request.getUrl()));
        }
    }

    private RequestPattern buildRequestPatternFrom(Request request) {
        String body;
        RequestPatternBuilder builder = RequestPatternBuilder.newRequestPattern(request.getMethod(), WireMock.urlEqualTo(request.getUrl()));
        if (!this.headersToMatch.isEmpty()) {
            for (HttpHeader header : request.getHeaders().all()) {
                if (!this.headersToMatch.contains(header.caseInsensitiveKey())) continue;
                builder.withHeader(header.key(), WireMock.equalTo(header.firstValue()));
            }
        }
        if (!(body = request.getBodyAsString()).isEmpty()) {
            builder.withRequestBody(this.valuePatternForContentType(request));
        }
        return builder.build();
    }

    private StringValuePattern valuePatternForContentType(Request request) {
        String contentType = request.getHeader("Content-Type");
        if (contentType != null) {
            if (contentType.contains("json")) {
                return WireMock.equalToJson(request.getBodyAsString(), true, true);
            }
            if (contentType.contains("xml")) {
                return WireMock.equalToXml(request.getBodyAsString());
            }
        }
        return WireMock.equalTo(request.getBodyAsString());
    }

    private void writeToMappingAndBodyFile(Request request, Response response, RequestPattern requestPattern) {
        String fileId = this.idGenerator.generate();
        byte[] body = this.bodyDecompressedIfRequired(response);
        String mappingFileName = UniqueFilenameGenerator.generate(request.getUrl(), "mapping", fileId);
        String bodyFileName = UniqueFilenameGenerator.generate(request.getUrl(), "body", fileId, ContentTypes.determineFileExtension(request.getUrl(), response.getHeaders().getContentTypeHeader(), body));
        ResponseDefinitionBuilder responseDefinitionBuilder = ResponseDefinitionBuilder.responseDefinition().withStatus(response.getStatus()).withBodyFile(bodyFileName);
        if (response.getHeaders().size() > 0) {
            responseDefinitionBuilder.withHeaders(this.withoutContentEncodingAndContentLength(response.getHeaders()));
        }
        ResponseDefinition responseToWrite = responseDefinitionBuilder.build();
        StubMapping mapping = new StubMapping(requestPattern, responseToWrite);
        mapping.setUuid(UUID.nameUUIDFromBytes(fileId.getBytes()));
        this.filesFileSource.writeBinaryFile(bodyFileName, body);
        this.mappingsFileSource.writeTextFile(mappingFileName, Json.write(mapping));
    }

    private HttpHeaders withoutContentEncodingAndContentLength(HttpHeaders httpHeaders) {
        return new HttpHeaders(Iterables.filter(httpHeaders.all(), new Predicate<HttpHeader>(){

            @Override
            public boolean apply(HttpHeader header) {
                return !header.keyEquals("Content-Encoding") && !header.keyEquals("Content-Length");
            }
        }));
    }

    private byte[] bodyDecompressedIfRequired(Response response) {
        if (response.getHeaders().getHeader("Content-Encoding").containsValue("gzip")) {
            return Gzip.unGzip(response.getBody());
        }
        return response.getBody();
    }

    private boolean requestNotAlreadyReceived(RequestPattern requestPattern) {
        VerificationResult verificationResult = this.admin.countRequestsMatching(requestPattern);
        verificationResult.assertRequestJournalEnabled();
        return verificationResult.getCount() < 1;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

