/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.adapter.DerbyAdapter;
import org.apache.torque.adapter.HsqldbAdapter;
import org.apache.torque.adapter.MssqlAdapter;
import org.apache.torque.adapter.MysqlAdapter;
import org.apache.torque.adapter.NoneAdapter;
import org.apache.torque.adapter.OracleAdapter;
import org.apache.torque.adapter.PostgresAdapter;

public final class AdapterFactory {
    private static final Logger log = LogManager.getLogger(AdapterFactory.class);
    private static Map<String, Class<? extends Adapter>> adapters = new HashMap<String, Class<? extends Adapter>>();

    private AdapterFactory() {
    }

    public static Adapter autoDetectAdapter(Connection con) throws InstantiationException, SQLException {
        DatabaseMetaData dmd = con.getMetaData();
        String dbmsName = dmd.getDatabaseProductName();
        Adapter adapter = AdapterFactory.create(dbmsName);
        if (adapter == null) {
            throw new InstantiationException("Could not detect adapter for database: " + dbmsName);
        }
        log.info("Mapped database product {} to adapter {}", (Object)dbmsName, (Object)adapter.getClass().getSimpleName());
        return adapter;
    }

    public static void setCapabilities(Connection con, Adapter adapter) throws SQLException {
        DatabaseMetaData dmd = con.getMetaData();
        adapter.setCapabilities(dmd);
    }

    public static Adapter create(String key) throws InstantiationException {
        Class<? extends Adapter> adapterClass = adapters.get(key);
        if (adapterClass == null) {
            return null;
        }
        try {
            Adapter adapter = adapterClass.newInstance();
            return adapter;
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Could not instantiate adapter for key : " + key + ": Assure that adapter classes are in your classpath");
        }
    }

    public static Adapter create(String key, String className) throws InstantiationException {
        Class<?> adapterClass;
        try {
            adapterClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Could not find adapter " + className + " for key " + key + ": Check your configuration file");
        }
        adapters.put(key, adapterClass);
        Adapter adapter = AdapterFactory.create(key);
        return adapter;
    }

    static {
        adapters.put("org.hsql.jdbcDriver", HsqldbAdapter.class);
        adapters.put("org.hsqldb.jdbcDriver", HsqldbAdapter.class);
        adapters.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", MssqlAdapter.class);
        adapters.put("com.jnetdirect.jsql.JSQLDriver", MssqlAdapter.class);
        adapters.put("org.gjt.mm.mysql.Driver", MysqlAdapter.class);
        adapters.put("com.mysql.cj.jdbc.Driver", MysqlAdapter.class);
        adapters.put("oracle.jdbc.driver.OracleDriver", OracleAdapter.class);
        adapters.put("org.postgresql.Driver", PostgresAdapter.class);
        adapters.put("org.apache.derby.jdbc.EmbeddedDriver", DerbyAdapter.class);
        adapters.put("hsqldb", HsqldbAdapter.class);
        adapters.put("mssql", MssqlAdapter.class);
        adapters.put("mysql", MysqlAdapter.class);
        adapters.put("oracle", OracleAdapter.class);
        adapters.put("postgresql", PostgresAdapter.class);
        adapters.put("derby", DerbyAdapter.class);
        adapters.put("HSQL Database Engine", HsqldbAdapter.class);
        adapters.put("Microsoft SQL Server Database", MssqlAdapter.class);
        adapters.put("Microsoft SQL Server", MssqlAdapter.class);
        adapters.put("MySQL", MysqlAdapter.class);
        adapters.put("Oracle", OracleAdapter.class);
        adapters.put("PostgreSQL", PostgresAdapter.class);
        adapters.put("Apache Derby", DerbyAdapter.class);
        adapters.put("", NoneAdapter.class);
    }
}

