/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull.tools;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.ui.UIService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;

public class UITool
implements ApplicationTool {
    private static final Logger log = LogManager.getLogger(UITool.class);
    public static final String SKIN_ATTRIBUTE = UITool.class.getName() + ".skin";
    private String skinName;
    @TurbineService
    private UIService uiService;

    @Override
    public void refresh() {
        this.uiService.refresh(this.getSkin());
        log.debug("UITool refreshed for skin: {}", new Supplier[]{this::getSkin});
    }

    public String[] getSkinNames() {
        return this.uiService.getSkinNames();
    }

    public String getWebappSkinName() {
        return this.uiService.getWebappSkinName();
    }

    public String get(String key) {
        return this.uiService.get(this.getSkin(), key);
    }

    public String getSkin() {
        return this.skinName;
    }

    public void setSkin() {
        this.skinName = this.uiService.getWebappSkinName();
    }

    public void setSkin(String skinName) {
        this.skinName = skinName;
    }

    protected void setSkin(RunData data) {
        this.setSkin();
    }

    protected void setSkin(User user) {
        if (user.getTemp(SKIN_ATTRIBUTE) == null) {
            this.setSkin();
        } else {
            this.setSkin((String)user.getTemp(SKIN_ATTRIBUTE));
        }
    }

    public static void setSkin(User user, String skin) {
        user.setTemp(SKIN_ATTRIBUTE, skin);
    }

    public String image(String imageId, RunData data) {
        return this.image(imageId, data.getServerData());
    }

    public String image(String imageId, ServerData serverData) {
        return this.uiService.image(this.getSkin(), imageId, serverData);
    }

    public String image(String imageId) {
        return this.uiService.image(this.getSkin(), imageId);
    }

    public String getStylecss(RunData data) {
        return this.getStylecss(data.getServerData());
    }

    public String getStylecss(ServerData serverData) {
        return this.uiService.getStylecss(this.getSkin(), serverData);
    }

    public String getStylecss() {
        return this.uiService.getStylecss(this.getSkin());
    }

    public String getScript(String filename, RunData data) {
        return this.getScript(filename, data.getServerData());
    }

    public String getScript(String filename, ServerData serverData) {
        return this.uiService.getScript(this.getSkin(), filename, serverData);
    }

    public String getScript(String filename) {
        return this.uiService.getScript(this.getSkin(), filename);
    }

    @Override
    public void init(Object data) {
        if (data == null) {
            log.debug("UITool scope is global");
            this.setSkin();
        } else if (data instanceof RunData) {
            log.debug("UITool scope is request");
            this.setSkin((RunData)data);
        } else if (data instanceof PipelineData) {
            PipelineData pipelineData = (PipelineData)data;
            RunData runData = (RunData)pipelineData;
            log.debug("UITool scope is request");
            this.setSkin(runData);
        } else if (data instanceof User) {
            log.debug("UITool scope is session");
            this.setSkin((User)data);
        }
    }
}

