/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractUnaryStringStringEval;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

@MissingNullInOutFunction
public class DecodeDataverseDisplayNameDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = DecodeDataverseDisplayNameDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractUnaryStringStringEval(ctx, args[0], DecodeDataverseDisplayNameDescriptor.this.getIdentifier(), DecodeDataverseDisplayNameDescriptor.this.sourceLoc){
                    private final StringBuilder sb;
                    {
                        this.sb = new StringBuilder();
                    }

                    @Override
                    void process(UTF8StringPointable inputString, IPointable resultPointable) throws IOException {
                        String dataverseCanonicalName = inputString.toString();
                        this.sb.setLength(0);
                        DataverseName.getDisplayFormFromCanonicalForm((String)dataverseCanonicalName, (StringBuilder)this.sb);
                        this.resultBuilder.reset(this.resultArray, inputString.getUTF8Length());
                        this.resultBuilder.appendString((CharSequence)this.sb);
                        this.resultBuilder.finish();
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.DECODE_DATAVERSE_DISPLAY_NAME;
    }
}

