/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.pointables.nonvisitor.AIntervalPointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.temporal.IntervalLogic;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractIntervalLogicFuncDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final IntervalLogic il = new IntervalLogic();
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private TaggedValuePointable argPtr0 = TaggedValuePointable.FACTORY.createPointable();
                    private TaggedValuePointable argPtr1 = TaggedValuePointable.FACTORY.createPointable();
                    private AIntervalPointable interval0 = (AIntervalPointable)AIntervalPointable.FACTORY.createPointable();
                    private AIntervalPointable interval1 = (AIntervalPointable)AIntervalPointable.FACTORY.createPointable();
                    private IScalarEvaluator eval0;
                    private IScalarEvaluator eval1;
                    private ISerializerDeserializer<ABoolean> booleanSerde;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, (IPointable)this.argPtr0);
                        this.eval1.evaluate(tuple, (IPointable)this.argPtr1);
                        if (PointableHelper.checkAndSetMissingOrNull(result, (IPointable)this.argPtr0, (IPointable)this.argPtr1)) {
                            return;
                        }
                        byte typeTag0 = this.argPtr0.getTag();
                        if (typeTag0 != ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG) {
                            throw new TypeMismatchException(AbstractIntervalLogicFuncDescriptor.this.sourceLoc, AbstractIntervalLogicFuncDescriptor.this.getIdentifier(), (Integer)0, typeTag0, ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                        }
                        byte typeTag1 = this.argPtr1.getTag();
                        if (typeTag1 != ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG) {
                            throw new TypeMismatchException(AbstractIntervalLogicFuncDescriptor.this.sourceLoc, AbstractIntervalLogicFuncDescriptor.this.getIdentifier(), (Integer)1, typeTag1, ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                        }
                        this.argPtr0.getValue((IPointable)this.interval0);
                        this.argPtr1.getValue((IPointable)this.interval1);
                        ABoolean res = AbstractIntervalLogicFuncDescriptor.this.compareIntervals(this.il, this.interval0, this.interval1) ? ABoolean.TRUE : ABoolean.FALSE;
                        this.booleanSerde.serialize((Object)res, this.out);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    protected abstract boolean compareIntervals(IntervalLogic var1, AIntervalPointable var2, AIntervalPointable var3) throws HyracksDataException;
}

