/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mindrot.jbcrypt.BCrypt;

public class BasicAuthServlet
implements IServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    public static String BASIC_AUTH_METHOD_NAME = "Basic";
    private Base64.Decoder b64Decoder;
    Map<String, String> storedCredentials;
    Map<String, String> ephemeralCredentials;
    private String sysAuthHeader;
    private final IServlet delegate;
    private ConcurrentMap<String, Object> ctx;

    public BasicAuthServlet(ConcurrentMap<String, Object> ctx, IServlet delegate) {
        String sysUser;
        this.delegate = delegate;
        this.b64Decoder = Base64.getDecoder();
        this.storedCredentials = (Map)ctx.get("org.apache.asterix.CREDENTIAL_MAP");
        this.ctx = ctx;
        while (this.storedCredentials.containsKey(sysUser = BasicAuthServlet.generateRandomString(32))) {
        }
        String sysPassword = BasicAuthServlet.generateRandomString(128);
        this.ephemeralCredentials = Collections.singletonMap(sysUser, BasicAuthServlet.hashPassword(sysPassword));
        this.sysAuthHeader = BasicAuthServlet.createAuthHeader(sysUser, sysPassword);
        ctx.put("org.apache.asterix.SYS_AUTH_HEADER", this.sysAuthHeader);
    }

    public String[] getPaths() {
        return this.delegate.getPaths();
    }

    public void init() throws IOException {
        this.delegate.init();
    }

    public ConcurrentMap<String, Object> ctx() {
        return this.ctx;
    }

    public void handle(IServletRequest request, IServletResponse response) {
        try {
            boolean authorized = this.authorize(request);
            if (!authorized) {
                response.setStatus(HttpResponseStatus.UNAUTHORIZED);
            } else {
                this.delegate.handle(request, response);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Unhandled exception", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Throwable th) {
            try {
                LOGGER.log(Level.WARN, "Unhandled throwable", th);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw th;
        }
    }

    private boolean authorize(IServletRequest request) {
        String authVal = request.getHeader((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if (authVal == null) {
            LOGGER.debug("Request missing Authorization header");
            return false;
        }
        String[] authString = authVal.split(" ");
        if (!BASIC_AUTH_METHOD_NAME.equals(authString[0]) || authString.length != 2) {
            LOGGER.debug("Malformed Authorization header or unsupported Authentication method");
            return false;
        }
        String credentialEncoded = authString[1];
        String credential = new String(this.b64Decoder.decode(credentialEncoded));
        String[] providedCredentials = credential.split(":");
        if (providedCredentials.length != 2) {
            LOGGER.debug("Invalid Basic credential format");
            return false;
        }
        String providedUsername = providedCredentials[0];
        String storedPw = this.getStoredCredentials(request).get(providedUsername);
        if (storedPw == null) {
            LOGGER.debug("Invalid username");
            return false;
        }
        String givenPw = providedCredentials[1];
        if (BCrypt.checkpw((String)givenPw, (String)storedPw)) {
            return true;
        }
        LOGGER.debug("Wrong password for user " + providedUsername);
        return false;
    }

    protected Map<String, String> getStoredCredentials(IServletRequest request) {
        return request.getHttpRequest().method().equals((Object)HttpMethod.GET) ? this.ephemeralCredentials : this.storedCredentials;
    }

    public static String hashPassword(String password) {
        return BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)12));
    }

    public static String createAuthHeader(String user, String password) {
        String auth = user + ":" + password;
        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.ISO_8859_1));
        return "Basic " + new String(encodedAuth);
    }

    private static String generateRandomString(int size) {
        return RandomStringUtils.randomAlphanumeric((int)size);
    }
}

