/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.active;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventSubscriber;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IRetryPolicyFactory;
import org.apache.asterix.active.NoRetryPolicyFactory;
import org.apache.asterix.active.message.ActiveManagerMessage;
import org.apache.asterix.active.message.ActivePartitionMessage;
import org.apache.asterix.active.message.ActiveStatsRequestMessage;
import org.apache.asterix.active.message.StopRuntimeParameters;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.app.active.RecoveryTask;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.metadata.IDataset;
import org.apache.asterix.external.feed.watch.WaitForStateSubscriber;
import org.apache.asterix.metadata.api.IActiveEntityController;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.util.InvokeUtil;
import org.apache.hyracks.util.ExitUtil;
import org.apache.hyracks.util.Span;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ActiveEntityEventsListener
implements IActiveEntityController {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Level level = Level.DEBUG;
    private static final ActiveEvent STATE_CHANGED = new ActiveEvent(null, ActiveEvent.Kind.STATE_CHANGED, null, null);
    private static final EnumSet<ActivityState> TRANSITION_STATES = EnumSet.of(ActivityState.RESUMING, ActivityState.STARTING, ActivityState.STOPPING, ActivityState.RECOVERING, ActivityState.CANCELLING);
    private static final String DEFAULT_ACTIVE_STATS = "{\"Stats\":\"N/A\"}";
    protected static final TimeUnit TIMEOUT_UNIT = TimeUnit.SECONDS;
    protected final IClusterStateManager clusterStateManager;
    protected final ActiveNotificationHandler handler;
    protected final List<IActiveEntityEventSubscriber> subscribers = new ArrayList<IActiveEntityEventSubscriber>();
    protected final IStatementExecutor statementExecutor;
    protected final ICcApplicationContext appCtx;
    protected final MetadataProvider metadataProvider;
    protected final IHyracksClientConnection hcc;
    protected final EntityId entityId;
    private final List<Dataset> datasets;
    protected final ActiveEvent statsUpdatedEvent;
    protected final String runtimeName;
    protected final IRetryPolicyFactory retryPolicyFactory;
    protected volatile ActivityState state;
    private AlgebricksAbsolutePartitionConstraint locations;
    protected ActivityState prevState;
    protected JobId jobId;
    protected volatile long statsTimestamp;
    protected volatile String stats;
    protected volatile boolean isFetchingStats;
    protected int numRegistered;
    protected int numDeRegistered;
    protected volatile RecoveryTask rt;
    protected volatile boolean suspended = false;
    protected Exception jobFailure;
    protected Exception resumeFailure;
    protected Exception startFailure;
    protected Exception stopFailure;
    protected Exception recoverFailure;

    public ActiveEntityEventsListener(IStatementExecutor statementExecutor, ICcApplicationContext appCtx, IHyracksClientConnection hcc, EntityId entityId, List<Dataset> datasets, AlgebricksAbsolutePartitionConstraint locations, String runtimeName, IRetryPolicyFactory retryPolicyFactory) throws HyracksDataException {
        this.statementExecutor = statementExecutor;
        this.appCtx = appCtx;
        this.clusterStateManager = appCtx.getClusterStateManager();
        this.metadataProvider = MetadataProvider.create((ICcApplicationContext)appCtx, null);
        this.hcc = hcc;
        this.entityId = entityId;
        this.datasets = datasets;
        this.retryPolicyFactory = retryPolicyFactory;
        this.state = ActivityState.STOPPED;
        this.statsTimestamp = -1L;
        this.isFetchingStats = false;
        this.statsUpdatedEvent = new ActiveEvent(null, ActiveEvent.Kind.STATS_UPDATED, entityId, null);
        this.stats = DEFAULT_ACTIVE_STATS;
        this.runtimeName = runtimeName;
        this.locations = locations;
        this.numRegistered = 0;
        this.numDeRegistered = 0;
        this.handler = (ActiveNotificationHandler)this.metadataProvider.getApplicationContext().getActiveNotificationHandler();
        this.handler.registerListener((IActiveEntityEventsListener)this);
    }

    protected synchronized void setState(ActivityState newState) {
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "State of " + this.getEntityId() + "is being set to " + newState + " from " + this.state);
        }
        this.prevState = this.state;
        this.state = newState;
        if (newState == ActivityState.STARTING || newState == ActivityState.RECOVERING || newState == ActivityState.RESUMING) {
            this.jobFailure = null;
        } else if (newState == ActivityState.SUSPENDED) {
            this.suspended = true;
        }
        this.notifySubscribers(STATE_CHANGED);
    }

    public synchronized void notify(ActiveEvent event) {
        try {
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, "EventListener is notified.");
            }
            ActiveEvent.Kind eventKind = event.getEventKind();
            switch (eventKind) {
                case JOB_CREATED: 
                case JOB_STARTED: {
                    break;
                }
                case JOB_FINISHED: {
                    this.finish(event);
                    break;
                }
                case PARTITION_EVENT: {
                    this.handle((ActivePartitionMessage)event.getEventObject());
                    break;
                }
                default: {
                    LOGGER.log(Level.DEBUG, "Unhandled feed event notification: " + event);
                }
            }
            this.notifySubscribers(event);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Unhandled Exception", (Throwable)e);
        }
    }

    protected synchronized void handle(ActivePartitionMessage message) {
        if (message.getEvent() == ActivePartitionMessage.Event.RUNTIME_REGISTERED) {
            ++this.numRegistered;
            if (this.allPartitionsRegisteredAndNotCancelling()) {
                this.setState(ActivityState.RUNNING);
            }
        } else if (message.getEvent() == ActivePartitionMessage.Event.RUNTIME_DEREGISTERED) {
            ++this.numDeRegistered;
        }
    }

    private boolean allPartitionsRegisteredAndNotCancelling() {
        return this.numRegistered == this.locations.getLocations().length && this.state != ActivityState.CANCELLING;
    }

    protected void finish(ActiveEvent event) throws HyracksDataException {
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "the job " + this.jobId + " finished");
        }
        JobId lastJobId = this.jobId;
        if (this.numRegistered != this.numDeRegistered) {
            LOGGER.log(Level.WARN, "the job {} finished with reported runtime registrations = {} and deregistrations = {}", (Object)this.jobId, (Object)this.numRegistered, (Object)this.numDeRegistered);
        }
        this.jobId = null;
        Pair status = (Pair)event.getEventObject();
        JobStatus jobStatus = (JobStatus)status.getLeft();
        List exceptions = (List)status.getRight();
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "The job finished with status: " + jobStatus);
        }
        if (!this.jobSuccessfullyTerminated(jobStatus)) {
            this.jobFailure = exceptions.isEmpty() ? new RuntimeDataException(3102, new Serializable[0]) : (Exception)exceptions.get(0);
            LOGGER.error("Active Job {} failed", (Object)lastJobId, (Object)this.jobFailure);
            this.setState(this.state == ActivityState.STOPPING || this.state == ActivityState.CANCELLING ? ActivityState.STOPPED : ActivityState.TEMPORARILY_FAILED);
            if (this.prevState == ActivityState.RUNNING) {
                this.recover();
            }
        } else {
            this.setState(this.state == ActivityState.SUSPENDING ? ActivityState.SUSPENDED : ActivityState.STOPPED);
        }
    }

    private boolean jobSuccessfullyTerminated(JobStatus jobStatus) {
        return jobStatus.equals((Object)JobStatus.TERMINATED);
    }

    public synchronized void subscribe(IActiveEntityEventSubscriber subscriber) {
        subscriber.subscribed((IActiveEntityEventsListener)this);
        if (!subscriber.isDone()) {
            this.subscribers.add(subscriber);
        }
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public ActivityState getState() {
        return this.state;
    }

    public synchronized boolean isEntityUsingDataset(IDataset dataset) {
        return this.isActive() && this.getDatasets().contains(dataset);
    }

    public synchronized void remove(Dataset dataset) throws HyracksDataException {
        if (this.isActive()) {
            throw new RuntimeDataException(3092, new Serializable[]{this.entityId, this.state});
        }
        this.getDatasets().remove(dataset);
    }

    public synchronized void add(Dataset dataset) throws HyracksDataException {
        if (this.isActive()) {
            throw new RuntimeDataException(3091, new Serializable[]{this.entityId, this.state});
        }
        this.getDatasets().add(dataset);
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public String getStats() {
        return this.stats;
    }

    public long getStatsTimeStamp() {
        return this.statsTimestamp;
    }

    public String formatStats(List<String> responses) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("{\"Stats\": [").append(responses.get(0));
        for (int i = 1; i < responses.size(); ++i) {
            strBuilder.append(", ").append(responses.get(i));
        }
        strBuilder.append("]}");
        return strBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshStats(long timeout) throws HyracksDataException {
        LOGGER.log(level, "refreshStats called");
        this.ensureRunning();
        if (this.isFetchingStats) {
            LOGGER.log(level, "returning immediately since fetchingStats = " + this.isFetchingStats);
            return;
        }
        ActiveEntityEventsListener activeEntityEventsListener = this;
        synchronized (activeEntityEventsListener) {
            this.ensureRunning();
            if (this.isFetchingStats) {
                LOGGER.log(level, "returning immediately since fetchingStats = " + this.isFetchingStats);
                return;
            }
            this.isFetchingStats = true;
        }
        ICCMessageBroker messageBroker = (ICCMessageBroker)this.metadataProvider.getApplicationContext().getServiceContext().getMessageBroker();
        long reqId = messageBroker.newRequestId();
        ArrayList<ActiveStatsRequestMessage> requests = new ArrayList<ActiveStatsRequestMessage>();
        List<String> ncs = Arrays.asList(this.locations.getLocations());
        for (int i = 0; i < ncs.size(); ++i) {
            requests.add(new ActiveStatsRequestMessage((Serializable)new ActiveRuntimeId(this.entityId, this.runtimeName, i), reqId));
        }
        try {
            List responses = (List)messageBroker.sendSyncRequestToNCs(reqId, ncs, requests, timeout);
            this.stats = this.formatStats(responses);
            this.statsTimestamp = System.currentTimeMillis();
            this.notifySubscribers(this.statsUpdatedEvent);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
        this.isFetchingStats = false;
    }

    protected void ensureRunning() throws RuntimeDataException {
        if (this.state != ActivityState.RUNNING) {
            throw new RuntimeDataException(3118, new Serializable[]{this.runtimeName, String.valueOf(this.state).toLowerCase()});
        }
    }

    protected synchronized void notifySubscribers(ActiveEvent event) {
        this.notifyAll();
        Iterator<IActiveEntityEventSubscriber> it = this.subscribers.iterator();
        while (it.hasNext()) {
            IActiveEntityEventSubscriber subscriber = it.next();
            if (subscriber.isDone()) {
                it.remove();
                continue;
            }
            subscriber.notify(event);
            if (!subscriber.isDone()) continue;
            it.remove();
        }
    }

    public AlgebricksAbsolutePartitionConstraint getLocations() {
        return this.locations;
    }

    protected synchronized void waitForNonTransitionState() throws InterruptedException {
        while (TRANSITION_STATES.contains(this.state) || this.suspended) {
            this.wait();
        }
    }

    public synchronized void recover() {
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "Recover is called on " + this.entityId);
        }
        if (this.retryPolicyFactory == NoRetryPolicyFactory.INSTANCE) {
            LOGGER.log(level, "But it has no recovery policy, so it is set to permanent failure");
            this.setState(ActivityState.STOPPED);
        } else {
            ExecutorService executor = this.appCtx.getServiceContext().getControllerService().getExecutor();
            this.setState(ActivityState.TEMPORARILY_FAILED);
            LOGGER.log(level, "Recovery task has been submitted");
            this.rt = this.createRecoveryTask();
            executor.submit(this.rt.recover());
        }
    }

    public synchronized void start(MetadataProvider metadataProvider) throws HyracksDataException, InterruptedException {
        this.waitForNonTransitionState();
        if (this.state != ActivityState.STOPPED) {
            throw new RuntimeDataException(3089, new Serializable[]{this.entityId, this.state});
        }
        try {
            this.setState(ActivityState.STARTING);
            this.doStart(metadataProvider);
            this.setRunning(metadataProvider, true);
        }
        catch (Exception e) {
            this.setState(ActivityState.STOPPED);
            LOGGER.log(Level.ERROR, "Failed to start the entity " + this.entityId, (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected synchronized void doStart(MetadataProvider metadataProvider) throws HyracksDataException {
        WaitForStateSubscriber subscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, EnumSet.of(ActivityState.RUNNING, ActivityState.TEMPORARILY_FAILED, ActivityState.STOPPED));
        this.jobId = this.compileAndStartJob(metadataProvider);
        this.numRegistered = 0;
        this.numDeRegistered = 0;
        try {
            subscriber.sync();
            if (subscriber.getFailure() != null) {
                throw subscriber.getFailure();
            }
        }
        catch (InterruptedException ie) {
            if (subscriber.isDone()) {
                if (subscriber.getFailure() != null) {
                    throw HyracksDataException.create((Throwable)subscriber.getFailure());
                }
                Thread.currentThread().interrupt();
            }
            this.setState(ActivityState.CANCELLING);
            this.cancelJob(ie);
            throw HyracksDataException.create((Throwable)ie);
        }
        catch (Throwable e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void cancelJob(Throwable th) {
        this.cancelJobSafely(this.metadataProvider, th);
        WaitForStateSubscriber cancelSubscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, EnumSet.of(ActivityState.STOPPED));
        Span span = Span.start((long)2L, (TimeUnit)TimeUnit.MINUTES);
        InvokeUtil.doUninterruptibly(() -> {
            if (!cancelSubscriber.sync(span)) {
                ExitUtil.halt((int)22);
            }
        });
    }

    protected void cancelJobSafely(MetadataProvider metadataProvider, Throwable e) {
        try {
            metadataProvider.getApplicationContext().getHcc().cancelJob(this.jobId);
        }
        catch (Throwable th) {
            LOGGER.warn("Failed to cancel active job", th);
            e.addSuppressed(th);
        }
    }

    protected abstract JobId compileAndStartJob(MetadataProvider var1) throws HyracksDataException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doStop(MetadataProvider metadataProvider, long timeout, TimeUnit unit) throws HyracksDataException {
        EnumSet<ActivityState> waitFor;
        ActivityState intention = this.state;
        if (intention == ActivityState.STOPPING) {
            waitFor = EnumSet.of(ActivityState.STOPPED);
        } else if (intention == ActivityState.SUSPENDING) {
            waitFor = EnumSet.of(ActivityState.SUSPENDED, ActivityState.TEMPORARILY_FAILED);
        } else {
            throw new IllegalStateException("stop with what intention?? Current state is " + intention);
        }
        WaitForStateSubscriber subscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, waitFor);
        String nameBefore = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(nameBefore + " : WaitForCompletionForJobId: " + this.jobId);
            this.sendStopMessages(metadataProvider, timeout, unit);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Waiting for its state to become " + waitFor);
            }
            subscriber.sync();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disconnect has been completed " + waitFor);
            }
        }
        catch (InterruptedException ie) {
            this.forceStop(subscriber, ie);
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            this.forceStop(subscriber, e);
        }
        finally {
            Thread.currentThread().setName(nameBefore);
        }
    }

    private void forceStop(WaitForStateSubscriber subscriber, Throwable e) {
        if (!subscriber.isDone()) {
            this.cancelJob(e);
        }
        LOGGER.warn("Failure encountered while stopping {}", (Object)this, (Object)e);
    }

    protected void sendStopMessages(MetadataProvider metadataProvider, long timeout, TimeUnit unit) throws Exception {
        ICcApplicationContext applicationCtx = metadataProvider.getApplicationContext();
        ICCMessageBroker messageBroker = (ICCMessageBroker)applicationCtx.getServiceContext().getMessageBroker();
        AlgebricksAbsolutePartitionConstraint runtimeLocations = this.getLocations();
        int partition = 0;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.log(Level.INFO, "Sending stop messages to " + runtimeLocations);
        }
        for (String location : runtimeLocations.getLocations()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.log(Level.INFO, "Sending to " + location);
            }
            ActiveRuntimeId runtimeId = this.getActiveRuntimeId(partition++);
            messageBroker.sendApplicationMessageToNC((INcAddressedMessage)new ActiveManagerMessage(ActiveManagerMessage.Kind.STOP_ACTIVITY, (Serializable)new StopRuntimeParameters(runtimeId, timeout, unit)), location);
        }
    }

    protected abstract ActiveRuntimeId getActiveRuntimeId(int var1);

    protected abstract void doSuspend(MetadataProvider var1) throws HyracksDataException;

    protected abstract void doResume(MetadataProvider var1) throws HyracksDataException;

    protected abstract void setRunning(MetadataProvider var1, boolean var2);

    public final synchronized void stop(MetadataProvider metadataProvider) throws HyracksDataException, InterruptedException {
        this.waitForNonTransitionState();
        if (this.state != ActivityState.RUNNING && this.state != ActivityState.TEMPORARILY_FAILED) {
            throw new RuntimeDataException(3090, new Serializable[]{this.entityId, this.state});
        }
        if (this.state == ActivityState.TEMPORARILY_FAILED) {
            if (this.rt != null) {
                this.setState(ActivityState.STOPPING);
                this.rt.cancel();
                this.rt = null;
            }
            this.setState(ActivityState.STOPPED);
            try {
                this.setRunning(metadataProvider, false);
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Failed to set the entity state as not running " + this.entityId, (Throwable)e);
                throw HyracksDataException.create((Throwable)e);
            }
        } else if (this.state == ActivityState.RUNNING) {
            this.setState(ActivityState.STOPPING);
            try {
                this.doStop(metadataProvider, this.appCtx.getActiveProperties().getActiveStopTimeout(), TIMEOUT_UNIT);
            }
            catch (Exception e) {
                this.setState(ActivityState.STOPPED);
                LOGGER.log(Level.ERROR, "Failed to stop the entity " + this.entityId, (Throwable)e);
                throw HyracksDataException.create((Throwable)e);
            }
            finally {
                this.setRunning(metadataProvider, false);
            }
        } else {
            throw new RuntimeDataException(3090, new Serializable[]{this.entityId, this.state});
        }
        this.stats = DEFAULT_ACTIVE_STATS;
        this.notifySubscribers(this.statsUpdatedEvent);
    }

    public RecoveryTask getRecoveryTask() {
        return this.rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(MetadataProvider metadataProvider) throws HyracksDataException, InterruptedException {
        Future<Void> suspendTask;
        WaitForStateSubscriber subscriber;
        ActiveEntityEventsListener activeEntityEventsListener = this;
        synchronized (activeEntityEventsListener) {
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, "suspending entity " + this.entityId);
                LOGGER.log(level, "Waiting for ongoing activities");
            }
            this.waitForNonTransitionState();
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, "Proceeding with suspension. Current state is " + this.state);
            }
            if (this.state == ActivityState.STOPPED) {
                this.suspended = true;
                return;
            }
            if (this.state == ActivityState.SUSPENDED) {
                throw new RuntimeDataException(3103, new Serializable[]{this.entityId, this.state});
            }
            if (this.state == ActivityState.TEMPORARILY_FAILED) {
                this.suspended = true;
                this.setState(ActivityState.SUSPENDED);
                return;
            }
            this.setState(ActivityState.SUSPENDING);
            subscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, EnumSet.of(ActivityState.SUSPENDED, ActivityState.TEMPORARILY_FAILED));
            suspendTask = metadataProvider.getApplicationContext().getServiceContext().getControllerService().getExecutor().submit(() -> {
                this.doSuspend(metadataProvider);
                return null;
            });
            LOGGER.log(level, "Suspension task has been submitted");
        }
        try {
            LOGGER.log(level, "Waiting for suspension task to complete");
            suspendTask.get();
            LOGGER.log(level, "waiting for state to become SUSPENDED or TEMPORARILY_FAILED");
            subscriber.sync();
        }
        catch (Exception e) {
            ActiveEntityEventsListener activeEntityEventsListener2 = this;
            synchronized (activeEntityEventsListener2) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.log(Level.ERROR, "Failure while waiting for " + this.entityId + " to become suspended", (Throwable)e);
                }
                if (this.state == ActivityState.SUSPENDING) {
                    if (this.jobId != null) {
                        this.setState(this.prevState);
                    } else {
                        this.setState(ActivityState.STOPPED);
                    }
                }
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    public synchronized void resume(MetadataProvider metadataProvider) throws HyracksDataException {
        if (this.state == ActivityState.STOPPED) {
            this.suspended = false;
            this.notifyAll();
            return;
        }
        if (this.state != ActivityState.SUSPENDED && this.state != ActivityState.TEMPORARILY_FAILED) {
            throw new RuntimeDataException(3104, new Serializable[]{this.entityId, this.state});
        }
        try {
            if (this.prevState == ActivityState.TEMPORARILY_FAILED) {
                this.setState(ActivityState.TEMPORARILY_FAILED);
                return;
            }
            this.setState(ActivityState.RESUMING);
            this.rt = new RecoveryTask(this.appCtx, this, this.retryPolicyFactory);
            try {
                this.rt.resumeOrRecover(metadataProvider);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Failure while attempting to resume " + this.entityId, (Throwable)e);
            }
        }
        finally {
            this.suspended = false;
            this.notifyAll();
        }
    }

    public boolean isActive() {
        return this.state != ActivityState.STOPPED && this.state != ActivityState.CANCELLING;
    }

    public void unregister() throws HyracksDataException {
        this.handler.unregisterListener((IActiveEntityEventsListener)this);
    }

    public void setLocations(AlgebricksAbsolutePartitionConstraint locations) {
        this.locations = locations;
    }

    public Exception getJobFailure() {
        return this.jobFailure;
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public synchronized void replace(Dataset dataset) {
        if (this.getDatasets().contains(dataset)) {
            this.getDatasets().remove(dataset);
            this.getDatasets().add(dataset);
        }
    }

    public String getDisplayName() throws HyracksDataException {
        return this.getEntityId().toString();
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    protected RecoveryTask createRecoveryTask() {
        return new RecoveryTask(this.appCtx, this, this.retryPolicyFactory);
    }

    public String toString() {
        return "{\"class\":\"" + this.getClass().getSimpleName() + "\",\"entityId\":\"" + this.entityId + "\",\"state\":\"" + this.state + "\"}";
    }
}

