/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.result.fields;

import java.io.PrintWriter;
import java.util.List;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.common.api.ICodedMessage;
import org.apache.asterix.common.api.IResponseFieldPrinter;
import org.apache.hyracks.util.JSONUtil;

public abstract class AbstractCodedMessagePrinter
implements IResponseFieldPrinter {
    private final List<ICodedMessage> messages;

    public AbstractCodedMessagePrinter(List<ICodedMessage> messages) {
        this.messages = messages;
    }

    public void print(PrintWriter pw) {
        pw.print("\t\"");
        pw.print(this.getName());
        pw.print("\": [");
        for (int i = 0; i < this.messages.size(); ++i) {
            boolean lastMsg;
            ICodedMessage codedMessage = this.messages.get(i);
            pw.print("{ \n\t");
            ResultUtil.printField(pw, CodedMessageField.CODE.str(), codedMessage.getCode());
            pw.print("\t");
            ResultUtil.printField(pw, CodedMessageField.MSG.str(), JSONUtil.escape((String)codedMessage.getMessage()), false);
            pw.print("\t} \n\t");
            boolean bl = lastMsg = i == this.messages.size() - 1;
            if (lastMsg) continue;
            pw.print(",");
        }
        pw.print("]");
    }

    private static enum CodedMessageField {
        CODE("code"),
        MSG("msg");

        private final String str;

        private CodedMessageField(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }
}

