/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.PushLimitIntoOrderByRule;
import org.apache.asterix.optimizer.rules.am.AccessMethodJobGenParams;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.rules.InlineVariablesRule;

public class PushLimitIntoPrimarySearchRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean changed;
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.LIMIT) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, op);
        Integer outputLimit = PushLimitIntoOrderByRule.getOutputLimit((LimitOperator)op);
        if (outputLimit == null) {
            return false;
        }
        Mutable childOp = (Mutable)op.getInputs().get(0);
        if (((ILogicalOperator)childOp.getValue()).getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
            childOp = (Mutable)((ILogicalOperator)childOp.getValue()).getInputs().get(0);
        }
        if (changed = ((ILogicalOperator)childOp.getValue()).getOperatorTag() == LogicalOperatorTag.SELECT ? this.rewriteSelect((Mutable<ILogicalOperator>)childOp, outputLimit, context) : this.setLimitForScanOrUnnestMap((ILogicalOperator)childOp.getValue(), outputLimit)) {
            OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        }
        return changed;
    }

    private boolean rewriteSelect(Mutable<ILogicalOperator> op, int outputLimit, IOptimizationContext context) throws AlgebricksException {
        SelectOperator select = (SelectOperator)op.getValue();
        ILogicalExpression selectCondition = (ILogicalExpression)select.getCondition().getValue();
        HashSet<LogicalVariable> selectedVariables = new HashSet<LogicalVariable>();
        selectCondition.getUsedVariables(selectedVariables);
        MutableObject selectConditionRef = new MutableObject((Object)selectCondition.cloneExpression());
        ILogicalOperator child = (ILogicalOperator)((Mutable)select.getInputs().get(0)).getValue();
        InlineVariablesRule.InlineVariablesVisitor inlineVisitor = null;
        HashMap<LogicalVariable, ILogicalExpression> varAssignRhs = null;
        while (child.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            if (varAssignRhs == null) {
                varAssignRhs = new HashMap<LogicalVariable, ILogicalExpression>();
            } else {
                varAssignRhs.clear();
            }
            AssignOperator assignOp = (AssignOperator)child;
            this.extractInlinableVariablesFromAssign(assignOp, selectedVariables, varAssignRhs);
            if (!varAssignRhs.isEmpty()) {
                if (inlineVisitor == null) {
                    inlineVisitor = new InlineVariablesRule.InlineVariablesVisitor(varAssignRhs);
                    inlineVisitor.setContext(context);
                    inlineVisitor.setOperator((ILogicalOperator)select);
                }
                if (!inlineVisitor.transform((Mutable)selectConditionRef)) break;
                selectedVariables.clear();
                ((ILogicalExpression)selectConditionRef.getValue()).getUsedVariables(selectedVariables);
            }
            child = (ILogicalOperator)((Mutable)child.getInputs().get(0)).getValue();
        }
        boolean changed = false;
        switch (child.getOperatorTag()) {
            case DATASOURCESCAN: {
                DataSourceScanOperator scan = (DataSourceScanOperator)child;
                if (!this.isScanPushable(scan, selectedVariables)) break;
                scan.setSelectCondition((Mutable)selectConditionRef);
                scan.setOutputLimit((long)outputLimit);
                changed = true;
                break;
            }
            case UNNEST_MAP: {
                UnnestMapOperator unnestMap = (UnnestMapOperator)child;
                if (!this.isUnnestMapPushable(unnestMap, selectedVariables)) break;
                unnestMap.setSelectCondition((Mutable)selectConditionRef);
                unnestMap.setOutputLimit((long)outputLimit);
                changed = true;
            }
        }
        if (changed) {
            op.setValue(((Mutable)((ILogicalOperator)op.getValue()).getInputs().get(0)).getValue());
        }
        return changed;
    }

    private boolean setLimitForScanOrUnnestMap(ILogicalOperator op, int outputLimit) {
        UnnestMapOperator unnestMap;
        if (op.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            DataSourceScanOperator scan = (DataSourceScanOperator)op;
            if (this.isScanPushable(scan, Collections.emptySet())) {
                scan.setOutputLimit((long)outputLimit);
                return true;
            }
        } else if (op.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP && this.isUnnestMapPushable(unnestMap = (UnnestMapOperator)op, Collections.emptySet())) {
            unnestMap.setOutputLimit((long)outputLimit);
            return true;
        }
        return false;
    }

    private boolean isUnnestMapPushable(UnnestMapOperator op, Set<LogicalVariable> selectedVariables) {
        if (op.getOutputLimit() >= 0L) {
            return false;
        }
        ILogicalExpression unnestExpr = (ILogicalExpression)op.getExpressionRef().getValue();
        if (op.propagatesInput() || unnestExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)unnestExpr;
        if (!f.getFunctionIdentifier().equals((Object)BuiltinFunctions.INDEX_SEARCH)) {
            return false;
        }
        AccessMethodJobGenParams jobGenParams = new AccessMethodJobGenParams();
        jobGenParams.readFromFuncArgs(f.getArguments());
        if (!jobGenParams.isPrimaryIndex()) {
            return false;
        }
        return op.getScanVariables().containsAll(selectedVariables);
    }

    private boolean isScanPushable(DataSourceScanOperator op, Set<LogicalVariable> selectedVariables) {
        if (op.getOutputLimit() >= 0L) {
            return false;
        }
        if (!op.getInputs().isEmpty() && ((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            return false;
        }
        if (((DataSource)op.getDataSource()).getDatasourceType() != 0) {
            return false;
        }
        return op.getScanVariables().containsAll(selectedVariables);
    }

    private void extractInlinableVariablesFromAssign(AssignOperator assignOp, Set<LogicalVariable> includeVariables, Map<LogicalVariable, ILogicalExpression> outVarExprs) {
        List vars = assignOp.getVariables();
        List exprs = assignOp.getExpressions();
        int ln = vars.size();
        for (int i = 0; i < ln; ++i) {
            ILogicalExpression expr;
            LogicalVariable var = (LogicalVariable)vars.get(i);
            if (!includeVariables.contains(var) || !(expr = (ILogicalExpression)((Mutable)exprs.get(i)).getValue()).isFunctional()) continue;
            outVarExprs.put(var, expr);
        }
    }
}

