/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.util;

import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;

public class InvertedIndexTokenizingTupleIterator {
    protected final int DOC_FIELD_INDEX = 0;
    protected final int invListFieldCount;
    protected final ArrayTupleBuilder tupleBuilder;
    protected final ArrayTupleReference tupleReference;
    protected final IBinaryTokenizer tokenizer;
    protected ITupleReference inputTuple;

    public InvertedIndexTokenizingTupleIterator(int tokensFieldCount, int invListFieldCount, IBinaryTokenizer tokenizer) {
        this.invListFieldCount = invListFieldCount;
        this.tupleBuilder = new ArrayTupleBuilder(tokensFieldCount + invListFieldCount);
        this.tupleReference = new ArrayTupleReference();
        this.tokenizer = tokenizer;
    }

    public void reset(ITupleReference inputTuple) {
        this.inputTuple = inputTuple;
        this.tokenizer.reset(inputTuple.getFieldData(0), inputTuple.getFieldStart(0), inputTuple.getFieldLength(0));
    }

    public boolean hasNext() {
        return this.tokenizer.hasNext();
    }

    public void next() throws HyracksDataException {
        this.tokenizer.next();
        IToken token = this.tokenizer.getToken();
        this.tupleBuilder.reset();
        try {
            token.serializeToken(this.tupleBuilder.getFieldData());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        this.tupleBuilder.addFieldEndOffset();
        for (int i = 0; i < this.invListFieldCount; ++i) {
            this.tupleBuilder.addField(this.inputTuple.getFieldData(i + 1), this.inputTuple.getFieldStart(i + 1), this.inputTuple.getFieldLength(i + 1));
        }
        this.tupleReference.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
    }

    public ITupleReference getTuple() {
        return this.tupleReference;
    }
}

