/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.typing;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.properties.TypePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.AbstractTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;

public class PropagatingTypeEnvironment
extends AbstractTypeEnvironment {
    private final TypePropagationPolicy policy;
    private final IMissableTypeComputer nullableTypeComputer;
    private final ITypeEnvPointer[] envPointers;
    private final List<LogicalVariable> nonNullVariables = new ArrayList<LogicalVariable>();
    private final List<List<LogicalVariable>> correlatedNullableVariableLists = new ArrayList<List<LogicalVariable>>();

    public PropagatingTypeEnvironment(IExpressionTypeComputer expressionTypeComputer, IMissableTypeComputer nullableTypeComputer, IMetadataProvider<?, ?> metadataProvider, TypePropagationPolicy policy, ITypeEnvPointer[] envPointers) {
        super(expressionTypeComputer, metadataProvider);
        this.nullableTypeComputer = nullableTypeComputer;
        this.policy = policy;
        this.envPointers = envPointers;
    }

    @Override
    public Object getVarType(LogicalVariable var) throws AlgebricksException {
        return this.getVarTypeFullList(var, this.nonNullVariables, this.correlatedNullableVariableLists);
    }

    public List<LogicalVariable> getNonNullVariables() {
        return this.nonNullVariables;
    }

    public List<List<LogicalVariable>> getCorrelatedMissableVariableLists() {
        return this.correlatedNullableVariableLists;
    }

    @Override
    public Object getVarType(LogicalVariable var, List<LogicalVariable> nonNullVariableList, List<List<LogicalVariable>> correlatedNullableVariableLists) throws AlgebricksException {
        for (LogicalVariable v : this.nonNullVariables) {
            if (nonNullVariableList.contains(v)) continue;
            nonNullVariableList.add(v);
        }
        Object t = this.getVarTypeFullList(var, nonNullVariableList, correlatedNullableVariableLists);
        for (List<LogicalVariable> list : this.correlatedNullableVariableLists) {
            if (correlatedNullableVariableLists.contains(list)) continue;
            correlatedNullableVariableLists.add(list);
        }
        return t;
    }

    private Object getVarTypeFullList(LogicalVariable var, List<LogicalVariable> nonNullVariableList, List<List<LogicalVariable>> correlatedNullableVariableLists) throws AlgebricksException {
        Object t = this.varTypeMap.get(var);
        if (t != null) {
            return t;
        }
        return this.policy.getVarType(var, this.nullableTypeComputer, nonNullVariableList, correlatedNullableVariableLists, this.envPointers);
    }
}

