/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import org.apache.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;

public class LSMSecondaryInsertDeleteWithNestedPlanOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    private final NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] startOfPipelines;
    private final int numberOfPrimaryKeyAndFilterFields;

    public LSMSecondaryInsertDeleteWithNestedPlanOperatorNodePushable(IHyracksTaskContext ctx, int partition, int[] fieldPermutation, RecordDescriptor inputRecDesc, IndexOperation op, IIndexDataflowHelperFactory indexHelperFactory, IModificationOperationCallbackFactory modCallbackFactory, List<AlgebricksPipeline> secondaryKeysPipeline) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, op, modCallbackFactory, null);
        this.numberOfPrimaryKeyAndFilterFields = fieldPermutation.length;
        this.startOfPipelines = new NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[secondaryKeysPipeline.size()];
        PipelineAssembler[] pipelineAssemblers = new PipelineAssembler[secondaryKeysPipeline.size()];
        for (int p = 0; p < secondaryKeysPipeline.size(); ++p) {
            IndexTupleInsertDelete outputWriter;
            AlgebricksPipeline pipeline = secondaryKeysPipeline.get(p);
            RecordDescriptor lastRecordDescriptorInPipeline = pipeline.getRecordDescriptors()[pipeline.getRecordDescriptors().length - 1];
            if (p == 0) {
                outputWriter = new IndexTupleInsertDelete(lastRecordDescriptorInPipeline);
            } else {
                IPushRuntime outputPushRuntime = PipelineAssembler.linkPipeline((AlgebricksPipeline)pipeline, (PipelineAssembler[])pipelineAssemblers, (int)p);
                if (outputPushRuntime == null) {
                    throw new RuntimeDataException(ErrorCode.ILLEGAL_STATE, new Serializable[]{"Invalid pipeline."});
                }
                outputPushRuntime.setInputRecordDescriptor(0, lastRecordDescriptorInPipeline);
                outputWriter = outputPushRuntime;
            }
            PipelineAssembler pipelineAssembler = new PipelineAssembler(pipeline, 1, 1, inputRecDesc, lastRecordDescriptorInPipeline);
            this.startOfPipelines[p] = (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime)pipelineAssembler.assemblePipeline((IFrameWriter)outputWriter, ctx);
            pipelineAssemblers[p] = pipelineAssembler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
            for (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime nts : this.startOfPipelines) {
                nts.writeTuple(buffer, i);
            }
            try {
                for (int n = 0; n < this.startOfPipelines.length; ++n) {
                    NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime nts = this.startOfPipelines[n];
                    try {
                        nts.open();
                        continue;
                    }
                    catch (Exception e) {
                        nts.fail();
                        throw e;
                    }
                }
                continue;
            }
            finally {
                for (int j = n - 1; j >= 0; --j) {
                    this.startOfPipelines[j].close();
                }
            }
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
        FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
    }

    private class IndexTupleInsertDelete
    implements IFrameWriter {
        private final RecordDescriptor inputRecordDescriptor;
        private FrameTupleAccessor endOfPipelineTupleAccessor;
        private ArrayTupleBuilder arrayTupleBuilder;
        private ArrayTupleReference arrayTupleReference;

        private IndexTupleInsertDelete(RecordDescriptor recordDescriptor) {
            this.inputRecordDescriptor = recordDescriptor;
        }

        public void open() throws HyracksDataException {
            int numSecondaryKeys = this.inputRecordDescriptor.getFieldCount();
            this.endOfPipelineTupleAccessor = new FrameTupleAccessor(this.inputRecordDescriptor);
            this.arrayTupleBuilder = new ArrayTupleBuilder(LSMSecondaryInsertDeleteWithNestedPlanOperatorNodePushable.this.numberOfPrimaryKeyAndFilterFields + numSecondaryKeys);
            this.arrayTupleReference = new ArrayTupleReference();
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            ILSMIndexAccessor workingLSMAccessor = (ILSMIndexAccessor)LSMSecondaryInsertDeleteWithNestedPlanOperatorNodePushable.this.indexAccessor;
            this.endOfPipelineTupleAccessor.reset(buffer);
            int nTuple = this.endOfPipelineTupleAccessor.getTupleCount();
            for (int t = 0; t < nTuple; ++t) {
                int f;
                this.arrayTupleBuilder.reset();
                int nFields = this.endOfPipelineTupleAccessor.getFieldCount();
                for (f = 0; f < nFields; ++f) {
                    this.arrayTupleBuilder.addField((IFrameTupleAccessor)this.endOfPipelineTupleAccessor, t, f);
                }
                for (f = 0; f < LSMSecondaryInsertDeleteWithNestedPlanOperatorNodePushable.this.numberOfPrimaryKeyAndFilterFields; ++f) {
                    this.arrayTupleBuilder.addField(LSMSecondaryInsertDeleteWithNestedPlanOperatorNodePushable.this.tuple.getFieldData(f), LSMSecondaryInsertDeleteWithNestedPlanOperatorNodePushable.this.tuple.getFieldStart(f), LSMSecondaryInsertDeleteWithNestedPlanOperatorNodePushable.this.tuple.getFieldLength(f));
                }
                this.arrayTupleReference.reset(this.arrayTupleBuilder.getFieldEndOffsets(), this.arrayTupleBuilder.getByteArray());
                if (LSMSecondaryInsertDeleteWithNestedPlanOperatorNodePushable.this.op.equals((Object)IndexOperation.INSERT)) {
                    workingLSMAccessor.forceInsert((ITupleReference)this.arrayTupleReference);
                    continue;
                }
                workingLSMAccessor.forceDelete((ITupleReference)this.arrayTupleReference);
            }
        }

        public void fail() throws HyracksDataException {
        }

        public void close() throws HyracksDataException {
        }
    }
}

