/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.unnestingfunctions.std;

import java.io.IOException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.unnestingfunctions.base.AbstractUnnestingFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ScanCollectionDescriptor
extends AbstractUnnestingFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ScanCollectionDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SCAN_COLLECTION;
    }

    public IUnnestingEvaluatorFactory createUnnestingEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        return new ScanCollectionUnnestingFunctionFactory(args[0], this.sourceLoc);
    }

    public static class ScanCollectionUnnestingFunctionFactory
    implements IUnnestingEvaluatorFactory {
        private static final long serialVersionUID = 1L;
        private IScalarEvaluatorFactory listEvalFactory;
        private final SourceLocation sourceLoc;

        public ScanCollectionUnnestingFunctionFactory(IScalarEvaluatorFactory arg, SourceLocation sourceLoc) {
            this.listEvalFactory = arg;
            this.sourceLoc = sourceLoc;
        }

        public IUnnestingEvaluator createUnnestingEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
            return new IUnnestingEvaluator(){
                private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                private final ListAccessor listAccessor = new ListAccessor();
                private final IPointable inputVal = new VoidPointable();
                private final IScalarEvaluator argEval;
                private int itemIndex;
                private boolean metUnknown;
                {
                    this.argEval = listEvalFactory.createScalarEvaluator(ctx);
                    this.metUnknown = false;
                }

                public void init(IFrameTupleReference tuple) throws HyracksDataException {
                    this.metUnknown = false;
                    this.argEval.evaluate(tuple, this.inputVal);
                    byte typeTag = this.inputVal.getByteArray()[this.inputVal.getStartOffset()];
                    if (typeTag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG || typeTag == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                        this.metUnknown = true;
                        return;
                    }
                    if (typeTag != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG && typeTag != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                        throw new TypeMismatchException(sourceLoc, typeTag, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
                    }
                    this.listAccessor.reset(this.inputVal.getByteArray(), this.inputVal.getStartOffset());
                    this.itemIndex = 0;
                }

                public boolean step(IPointable result) throws HyracksDataException {
                    try {
                        if (!this.metUnknown && this.itemIndex < this.listAccessor.size()) {
                            this.resultStorage.reset();
                            this.listAccessor.writeItem(this.itemIndex, this.resultStorage.getDataOutput());
                            result.set((IValueReference)this.resultStorage);
                            ++this.itemIndex;
                            return true;
                        }
                    }
                    catch (IOException e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                    return false;
                }
            };
        }
    }
}

