/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.builders.AbvsBuilderFactory;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.base.ListAccessorFactory;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class ArrayFlattenDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType inputListType;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ArrayFlattenDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_ARGUMENT_TYPE;
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_FLATTEN;
    }

    public void setImmutableStates(Object ... states) {
        this.inputListType = (IAType)states[0];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayFlattenEval(args, ctx);
            }
        };
    }

    public class ArrayFlattenEval
    implements IScalarEvaluator {
        private final IScalarEvaluator listEval;
        private final IScalarEvaluator depthEval;
        private final IPointable list;
        private final AbstractPointable pointable;
        private final TaggedValuePointable depthArg;
        private final IObjectPool<IMutableValueStorage, ATypeTag> storageAllocator = new ListObjectPool((IObjectFactory)new AbvsBuilderFactory());
        private final IObjectPool<ListAccessor, ATypeTag> listAccessorAllocator = new ListObjectPool((IObjectFactory)new ListAccessorFactory());
        private final CastTypeEvaluator caster;
        private final ArrayBackedValueStorage finalStorage = new ArrayBackedValueStorage();
        private ArrayBackedValueStorage storage;
        private IAsterixListBuilder orderedListBuilder;
        private IAsterixListBuilder unorderedListBuilder;

        public ArrayFlattenEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.listEval = args[0].createScalarEvaluator(ctx);
            this.depthEval = args[1].createScalarEvaluator(ctx);
            this.list = new VoidPointable();
            this.pointable = new VoidPointable();
            this.caster = new CastTypeEvaluator();
            this.depthArg = new TaggedValuePointable();
            this.orderedListBuilder = null;
            this.unorderedListBuilder = null;
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.listEval.evaluate(tuple, (IPointable)this.pointable);
            this.depthEval.evaluate(tuple, (IPointable)this.depthArg);
            if (PointableHelper.checkAndSetMissingOrNull(result, (IPointable)this.pointable, (IPointable)this.depthArg)) {
                return;
            }
            ATypeTag listType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.pointable.getByteArray()[this.pointable.getStartOffset()]);
            if (!ATypeHierarchy.isCompatible((ATypeTag)((ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.depthArg.getTag())), (ATypeTag)ATypeTag.DOUBLE) || !listType.isListType()) {
                PointableHelper.setNull(result);
                return;
            }
            String name = ArrayFlattenDescriptor.this.getIdentifier().getName();
            double depth = ATypeHierarchy.getDoubleValue((String)name, (int)1, (byte[])this.depthArg.getByteArray(), (int)this.depthArg.getStartOffset());
            if (Double.isNaN(depth) || Double.isInfinite(depth) || Math.floor(depth) < depth) {
                PointableHelper.setNull(result);
                return;
            }
            try {
                IAsterixListBuilder listBuilder;
                this.caster.resetAndAllocate(DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)listType), ArrayFlattenDescriptor.this.inputListType, this.listEval);
                this.caster.cast((IPointable)this.pointable, this.list);
                int depthInt = (int)depth;
                if (listType == ATypeTag.ARRAY) {
                    if (this.orderedListBuilder == null) {
                        this.orderedListBuilder = new OrderedListBuilder();
                    }
                    listBuilder = this.orderedListBuilder;
                } else {
                    if (this.unorderedListBuilder == null) {
                        this.unorderedListBuilder = new UnorderedListBuilder();
                    }
                    listBuilder = this.unorderedListBuilder;
                }
                ListAccessor mainListAccessor = (ListAccessor)this.listAccessorAllocator.allocate(null);
                listBuilder.reset((AbstractCollectionType)DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)listType));
                mainListAccessor.reset(this.list.getByteArray(), this.list.getStartOffset());
                this.storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
                this.process(mainListAccessor, listBuilder, 0, depthInt);
                this.finalStorage.reset();
                listBuilder.write(this.finalStorage.getDataOutput(), true);
                result.set((IValueReference)this.finalStorage);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            finally {
                this.storageAllocator.reset();
                this.listAccessorAllocator.reset();
                this.caster.deallocatePointables();
            }
        }

        private void process(ListAccessor listAccessor, IAsterixListBuilder listBuilder, int currentDepth, int depth) throws IOException {
            for (int i = 0; i < listAccessor.size(); ++i) {
                boolean itemInStorage = listAccessor.getOrWriteItem(i, (IPointable)this.pointable, this.storage);
                if (!((ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.pointable.getByteArray()[this.pointable.getStartOffset()])).isListType() || currentDepth == depth) {
                    listBuilder.addItem((IValueReference)this.pointable);
                    continue;
                }
                ListAccessor newListAccessor = (ListAccessor)this.listAccessorAllocator.allocate(null);
                newListAccessor.reset(this.pointable.getByteArray(), this.pointable.getStartOffset());
                if (itemInStorage) {
                    this.storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
                    this.storage.reset();
                }
                this.process(newListAccessor, listBuilder, currentDepth + 1, depth);
            }
        }
    }
}

