/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.parquet.CorruptDeltaByteArrays;
import org.apache.parquet.VersionParser;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.values.RequiresPreviousReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ColumnReaderBase
implements ColumnReader {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnReaderBase.class);
    private final VersionParser.ParsedVersion writerVersion;
    private final ColumnDescriptor path;
    private final long totalValueCount;
    private final PageReader pageReader;
    private final Dictionary dictionary;
    private IntIterator repetitionLevelColumn;
    private IntIterator definitionLevelColumn;
    protected ValuesReader dataColumn;
    private Encoding currentEncoding;
    private int repetitionLevel;
    private int definitionLevel;
    private int dictionaryId;
    private long endOfPageValueCount;
    private long readValues = 0L;
    private int pageValueCount = 0;
    private final PrimitiveConverter converter;
    private Binding binding;
    private final int maxDefinitionLevel;
    private boolean valueRead;

    private void bindToDictionary(final Dictionary dictionary) {
        this.binding = new Binding(){

            @Override
            void read() {
                ColumnReaderBase.this.dictionaryId = ColumnReaderBase.this.dataColumn.readValueDictionaryId();
            }

            @Override
            public void skip() {
                ColumnReaderBase.this.dataColumn.skip();
            }

            @Override
            void skip(int n) {
                ColumnReaderBase.this.dataColumn.skip(n);
            }

            @Override
            public int getDictionaryId() {
                return ColumnReaderBase.this.dictionaryId;
            }

            @Override
            void writeValue() {
                ColumnReaderBase.this.converter.addValueFromDictionary(ColumnReaderBase.this.dictionaryId);
            }

            @Override
            public int getInteger() {
                return dictionary.decodeToInt(ColumnReaderBase.this.dictionaryId);
            }

            @Override
            public boolean getBoolean() {
                return dictionary.decodeToBoolean(ColumnReaderBase.this.dictionaryId);
            }

            @Override
            public long getLong() {
                return dictionary.decodeToLong(ColumnReaderBase.this.dictionaryId);
            }

            @Override
            public Binary getBinary() {
                return dictionary.decodeToBinary(ColumnReaderBase.this.dictionaryId);
            }

            @Override
            public float getFloat() {
                return dictionary.decodeToFloat(ColumnReaderBase.this.dictionaryId);
            }

            @Override
            public double getDouble() {
                return dictionary.decodeToDouble(ColumnReaderBase.this.dictionaryId);
            }
        };
    }

    private void bind(PrimitiveType.PrimitiveTypeName type) {
        this.binding = type.convert(new PrimitiveType.PrimitiveTypeNameConverter<Binding, RuntimeException>(){

            @Override
            public Binding convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return new Binding(){
                    float current;

                    @Override
                    void read() {
                        this.current = ColumnReaderBase.this.dataColumn.readFloat();
                    }

                    @Override
                    public void skip() {
                        this.current = 0.0f;
                        ColumnReaderBase.this.dataColumn.skip();
                    }

                    @Override
                    void skip(int n) {
                        this.current = 0.0f;
                        ColumnReaderBase.this.dataColumn.skip(n);
                    }

                    @Override
                    public float getFloat() {
                        return this.current;
                    }

                    @Override
                    void writeValue() {
                        ColumnReaderBase.this.converter.addFloat(this.current);
                    }
                };
            }

            @Override
            public Binding convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return new Binding(){
                    double current;

                    @Override
                    void read() {
                        this.current = ColumnReaderBase.this.dataColumn.readDouble();
                    }

                    @Override
                    public void skip() {
                        this.current = 0.0;
                        ColumnReaderBase.this.dataColumn.skip();
                    }

                    @Override
                    void skip(int n) {
                        this.current = 0.0;
                        ColumnReaderBase.this.dataColumn.skip(n);
                    }

                    @Override
                    public double getDouble() {
                        return this.current;
                    }

                    @Override
                    void writeValue() {
                        ColumnReaderBase.this.converter.addDouble(this.current);
                    }
                };
            }

            @Override
            public Binding convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return new Binding(){
                    int current;

                    @Override
                    void read() {
                        this.current = ColumnReaderBase.this.dataColumn.readInteger();
                    }

                    @Override
                    public void skip() {
                        this.current = 0;
                        ColumnReaderBase.this.dataColumn.skip();
                    }

                    @Override
                    void skip(int n) {
                        this.current = 0;
                        ColumnReaderBase.this.dataColumn.skip(n);
                    }

                    @Override
                    public int getInteger() {
                        return this.current;
                    }

                    @Override
                    void writeValue() {
                        ColumnReaderBase.this.converter.addInt(this.current);
                    }
                };
            }

            @Override
            public Binding convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return new Binding(){
                    long current;

                    @Override
                    void read() {
                        this.current = ColumnReaderBase.this.dataColumn.readLong();
                    }

                    @Override
                    public void skip() {
                        this.current = 0L;
                        ColumnReaderBase.this.dataColumn.skip();
                    }

                    @Override
                    void skip(int n) {
                        this.current = 0L;
                        ColumnReaderBase.this.dataColumn.skip(n);
                    }

                    @Override
                    public long getLong() {
                        return this.current;
                    }

                    @Override
                    void writeValue() {
                        ColumnReaderBase.this.converter.addLong(this.current);
                    }
                };
            }

            @Override
            public Binding convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.convertBINARY(primitiveTypeName);
            }

            @Override
            public Binding convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.convertBINARY(primitiveTypeName);
            }

            @Override
            public Binding convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return new Binding(){
                    boolean current;

                    @Override
                    void read() {
                        this.current = ColumnReaderBase.this.dataColumn.readBoolean();
                    }

                    @Override
                    public void skip() {
                        this.current = false;
                        ColumnReaderBase.this.dataColumn.skip();
                    }

                    @Override
                    void skip(int n) {
                        this.current = false;
                        ColumnReaderBase.this.dataColumn.skip(n);
                    }

                    @Override
                    public boolean getBoolean() {
                        return this.current;
                    }

                    @Override
                    void writeValue() {
                        ColumnReaderBase.this.converter.addBoolean(this.current);
                    }
                };
            }

            @Override
            public Binding convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return new Binding(){
                    Binary current;

                    @Override
                    void read() {
                        this.current = ColumnReaderBase.this.dataColumn.readBytes();
                    }

                    @Override
                    public void skip() {
                        this.current = null;
                        ColumnReaderBase.this.dataColumn.skip();
                    }

                    @Override
                    void skip(int n) {
                        this.current = null;
                        ColumnReaderBase.this.dataColumn.skip(n);
                    }

                    @Override
                    public Binary getBinary() {
                        return this.current;
                    }

                    @Override
                    void writeValue() {
                        ColumnReaderBase.this.converter.addBinary(this.current);
                    }
                };
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    ColumnReaderBase(ColumnDescriptor path, PageReader pageReader, PrimitiveConverter converter, VersionParser.ParsedVersion writerVersion) {
        super();
        this.path = Objects.requireNonNull(path, "path cannot be null");
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader cannot be null");
        this.converter = Objects.requireNonNull(converter, "converter cannot be null");
        this.writerVersion = writerVersion;
        this.maxDefinitionLevel = path.getMaxDefinitionLevel();
        dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(path, dictionaryPage);
                if (!converter.hasDictionarySupport()) ** GOTO lbl19
                converter.setDictionary(this.dictionary);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + path, e);
            }
        } else {
            this.dictionary = null;
        }
lbl19:
        // 3 sources

        this.totalValueCount = pageReader.getTotalValueCount();
        if (this.totalValueCount <= 0L) {
            throw new ParquetDecodingException("totalValueCount '" + this.totalValueCount + "' <= 0");
        }
    }

    boolean isFullyConsumed() {
        return this.readValues >= this.totalValueCount;
    }

    @Override
    public void writeCurrentValueToConverter() {
        this.readValue();
        this.binding.writeValue();
    }

    @Override
    public int getCurrentValueDictionaryID() {
        this.readValue();
        return this.binding.getDictionaryId();
    }

    @Override
    public int getInteger() {
        this.readValue();
        return this.binding.getInteger();
    }

    @Override
    public boolean getBoolean() {
        this.readValue();
        return this.binding.getBoolean();
    }

    @Override
    public long getLong() {
        this.readValue();
        return this.binding.getLong();
    }

    @Override
    public Binary getBinary() {
        this.readValue();
        return this.binding.getBinary();
    }

    @Override
    public float getFloat() {
        this.readValue();
        return this.binding.getFloat();
    }

    @Override
    public double getDouble() {
        this.readValue();
        return this.binding.getDouble();
    }

    @Override
    public int getCurrentRepetitionLevel() {
        return this.repetitionLevel;
    }

    @Override
    public ColumnDescriptor getDescriptor() {
        return this.path;
    }

    public void readValue() {
        try {
            if (!this.valueRead) {
                this.binding.read();
                this.valueRead = true;
            }
        }
        catch (RuntimeException e) {
            if (CorruptDeltaByteArrays.requiresSequentialReads(this.writerVersion, this.currentEncoding) && e instanceof ArrayIndexOutOfBoundsException) {
                throw new ParquetDecodingException("Read failure possibly due to PARQUET-246: try setting parquet.split.files to false", (Throwable)((Object)new ParquetDecodingException(String.format("Can't read value in column %s at value %d out of %d, %d out of %d in currentPage. repetition level: %d, definition level: %d", this.path, this.readValues, this.totalValueCount, this.readValues - (this.endOfPageValueCount - (long)this.pageValueCount), this.pageValueCount, this.repetitionLevel, this.definitionLevel), e)));
            }
            throw new ParquetDecodingException(String.format("Can't read value in column %s at value %d out of %d, %d out of %d in currentPage. repetition level: %d, definition level: %d", this.path, this.readValues, this.totalValueCount, this.readValues - (this.endOfPageValueCount - (long)this.pageValueCount), this.pageValueCount, this.repetitionLevel, this.definitionLevel), e);
        }
    }

    @Override
    public void skip() {
        if (!this.valueRead) {
            this.binding.skip();
            this.valueRead = true;
        }
    }

    @Override
    public int getCurrentDefinitionLevel() {
        return this.definitionLevel;
    }

    private void checkRead() {
        int dl;
        int rl;
        int skipValues = 0;
        while (true) {
            if (this.isPageFullyConsumed()) {
                if (this.isFullyConsumed()) {
                    LOG.debug("end reached");
                    this.repetitionLevel = 0;
                    return;
                }
                this.readPage();
                skipValues = 0;
            }
            rl = this.repetitionLevelColumn.nextInt();
            dl = this.definitionLevelColumn.nextInt();
            ++this.readValues;
            if (!this.skipRL(rl)) break;
            if (dl != this.maxDefinitionLevel) continue;
            ++skipValues;
        }
        this.binding.skip(skipValues);
        this.repetitionLevel = rl;
        this.definitionLevel = dl;
    }

    abstract boolean skipRL(int var1);

    private void readPage() {
        LOG.debug("loading page");
        DataPage page = this.pageReader.readPage();
        page.accept(new DataPage.Visitor<Void>(){

            @Override
            public Void visit(DataPageV1 dataPageV1) {
                ColumnReaderBase.this.readPageV1(dataPageV1);
                return null;
            }

            @Override
            public Void visit(DataPageV2 dataPageV2) {
                ColumnReaderBase.this.readPageV2(dataPageV2);
                return null;
            }
        });
    }

    private void initDataReader(Encoding dataEncoding, ByteBufferInputStream in, int valueCount) {
        ValuesReader previousReader = this.dataColumn;
        this.currentEncoding = dataEncoding;
        this.pageValueCount = valueCount;
        this.endOfPageValueCount = this.readValues + (long)this.pageValueCount;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("could not read page in col " + this.path + " as the dictionary was missing for encoding " + (Object)((Object)dataEncoding));
            }
            this.dataColumn = dataEncoding.getDictionaryBasedValuesReader(this.path, ValuesType.VALUES, this.dictionary);
        } else {
            this.dataColumn = dataEncoding.getValuesReader(this.path, ValuesType.VALUES);
        }
        if (dataEncoding.usesDictionary() && this.converter.hasDictionarySupport()) {
            this.bindToDictionary(this.dictionary);
        } else {
            this.bind(this.path.getType());
        }
        try {
            this.dataColumn.initFromPage(this.pageValueCount, in);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page in col " + this.path, e);
        }
        if (CorruptDeltaByteArrays.requiresSequentialReads(this.writerVersion, dataEncoding) && previousReader != null && previousReader instanceof RequiresPreviousReader) {
            ((RequiresPreviousReader)((Object)this.dataColumn)).setPreviousReader(previousReader);
        }
    }

    private void readPageV1(DataPageV1 page) {
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.path, ValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDlEncoding().getValuesReader(this.path, ValuesType.DEFINITION_LEVEL);
        this.repetitionLevelColumn = new ValuesReaderIntIterator(rlReader);
        this.definitionLevelColumn = new ValuesReaderIntIterator(dlReader);
        int valueCount = page.getValueCount();
        try {
            BytesInput bytes = page.getBytes();
            LOG.debug("page size {} bytes and {} values", (Object)bytes.size(), (Object)valueCount);
            LOG.debug("reading repetition levels at 0");
            ByteBufferInputStream in = bytes.toInputStream();
            rlReader.initFromPage(valueCount, in);
            LOG.debug("reading definition levels at {}", (Object)in.position());
            dlReader.initFromPage(valueCount, in);
            LOG.debug("reading data at {}", (Object)in.position());
            this.initDataReader(page.getValueEncoding(), in, valueCount);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.path, e);
        }
        this.newPageInitialized(page);
    }

    private void readPageV2(DataPageV2 page) {
        this.repetitionLevelColumn = this.newRLEIterator(this.path.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionLevelColumn = this.newRLEIterator(this.path.getMaxDefinitionLevel(), page.getDefinitionLevels());
        int valueCount = page.getValueCount();
        LOG.debug("page data size {} bytes and {} values", (Object)page.getData().size(), (Object)valueCount);
        try {
            this.initDataReader(page.getDataEncoding(), page.getData().toInputStream(), valueCount);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.path, e);
        }
        this.newPageInitialized(page);
    }

    final int getPageValueCount() {
        return this.pageValueCount;
    }

    abstract void newPageInitialized(DataPage var1);

    private IntIterator newRLEIterator(int maxLevel, BytesInput bytes) {
        try {
            if (maxLevel == 0) {
                return new NullIntIterator();
            }
            return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), (InputStream)bytes.toInputStream()));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read levels in page for col " + this.path, e);
        }
    }

    boolean isPageFullyConsumed() {
        return this.readValues >= this.endOfPageValueCount;
    }

    @Override
    public void consume() {
        this.checkRead();
        this.valueRead = false;
    }

    @Override
    @Deprecated
    public long getTotalValueCount() {
        return this.totalValueCount;
    }

    private static final class NullIntIterator
    extends IntIterator {
        private NullIntIterator() {
        }

        @Override
        int nextInt() {
            return 0;
        }
    }

    static class RLEIntIterator
    extends IntIterator {
        RunLengthBitPackingHybridDecoder delegate;

        public RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() {
            try {
                return this.delegate.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException(e);
            }
        }
    }

    static class ValuesReaderIntIterator
    extends IntIterator {
        ValuesReader delegate;

        public ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() {
            return this.delegate.readInteger();
        }
    }

    static abstract class IntIterator {
        IntIterator() {
        }

        abstract int nextInt();
    }

    private static abstract class Binding {
        private Binding() {
        }

        abstract void read();

        abstract void skip();

        abstract void skip(int var1);

        abstract void writeValue();

        public int getDictionaryId() {
            throw new UnsupportedOperationException();
        }

        public int getInteger() {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean() {
            throw new UnsupportedOperationException();
        }

        public long getLong() {
            throw new UnsupportedOperationException();
        }

        public Binary getBinary() {
            throw new UnsupportedOperationException();
        }

        public float getFloat() {
            throw new UnsupportedOperationException();
        }

        public double getDouble() {
            throw new UnsupportedOperationException();
        }
    }
}

