/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.tuples.DualTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeSearchCursor;

public class LSMRTreeAccessor
extends LSMTreeIndexAccessor {
    private final DualTupleReference dualTuple;

    public LSMRTreeAccessor(ILSMHarness lsmHarness, ILSMIndexOperationContext ctx, int[] buddyBTreeFields) {
        super(lsmHarness, ctx, aCtx -> new LSMRTreeSearchCursor(aCtx, buddyBTreeFields));
        this.dualTuple = new DualTupleReference(buddyBTreeFields);
    }

    public void delete(ITupleReference tuple) throws HyracksDataException {
        this.getCtx().setOperation(IndexOperation.DELETE);
        this.dualTuple.reset(tuple);
        this.lsmHarness.modify(this.getCtx(), false, (ITupleReference)this.dualTuple);
    }

    public boolean tryDelete(ITupleReference tuple) throws HyracksDataException {
        this.getCtx().setOperation(IndexOperation.DELETE);
        this.dualTuple.reset(tuple);
        return this.lsmHarness.modify(this.getCtx(), true, (ITupleReference)this.dualTuple);
    }

    public void forceDelete(ITupleReference tuple) throws HyracksDataException {
        this.getCtx().setOperation(IndexOperation.DELETE);
        this.dualTuple.reset(tuple);
        this.lsmHarness.forceModify(this.getCtx(), (ITupleReference)this.dualTuple);
    }
}

