/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.trace;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.hyracks.util.PidHelper;
import org.apache.hyracks.util.trace.Event;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.hyracks.util.trace.TraceCategoryRegistry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Tracer
implements ITracer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Level TRACE_LOG_LEVEL = Level.forName((String)"TRACER", (int)570);
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
    private final Logger traceLog;
    private long categories;
    private final TraceCategoryRegistry registry;
    private static final long PID = PidHelper.getPid();

    public Tracer(String name, long categories, TraceCategoryRegistry registry) {
        String traceLoggerName = Tracer.class.getName() + ".Traces." + name;
        LOGGER.info("Initialize Tracer " + traceLoggerName);
        this.traceLog = LogManager.getLogger((String)traceLoggerName);
        this.categories = categories;
        this.registry = registry;
        long traceCategory = this.getRegistry().get("Tracer");
        this.instant("Trace-Start", traceCategory, ITracer.Scope.p, Tracer::dateTimeStamp);
    }

    public Tracer(String name, String[] categories, TraceCategoryRegistry registry) {
        this(name, -1L, registry);
        this.setCategories(categories);
    }

    @Override
    public void setCategories(String ... categories) {
        LOGGER.info("Set categories for Tracer " + this.traceLog.getName() + " to " + Arrays.toString(categories));
        this.categories = this.set(categories);
    }

    private long set(String ... names) {
        long result = 0L;
        for (String name : names) {
            result |= this.getRegistry().get(name);
        }
        return result;
    }

    public static String dateTimeStamp() {
        return "{\"datetime\":\"" + DATE_FORMAT.get().format(new Date()) + "\"}";
    }

    @Override
    public String toString() {
        return this.getName() + Long.toHexString(this.categories);
    }

    @Override
    public String getName() {
        return this.traceLog.getName();
    }

    @Override
    public TraceCategoryRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public boolean isEnabled(long cat) {
        return (this.categories & cat) != 0L;
    }

    @Override
    public long durationB(String name, long cat) {
        if (this.isEnabled(cat)) {
            return this.emitDurationB(name, cat, null);
        }
        return -1L;
    }

    @Override
    public long durationB(String name, long cat, String args) {
        if (this.isEnabled(cat)) {
            return this.emitDurationB(name, cat, args);
        }
        return -1L;
    }

    @Override
    public long durationB(String name, long cat, Supplier<String> args) {
        if (this.isEnabled(cat)) {
            return this.emitDurationB(name, cat, args.get());
        }
        return -1L;
    }

    @Override
    public void durationE(String name, long cat, long tid, String args) {
        if (this.isEnabled(cat)) {
            this.emit(name, cat, null, ITracer.Phase.E, tid, args);
        }
    }

    @Override
    public void durationE(String name, long cat, long tid, Supplier<String> args) {
        if (this.isEnabled(cat)) {
            this.emit(name, cat, null, ITracer.Phase.E, tid, args.get());
        }
    }

    @Override
    public void durationE(long cat, long tid) {
        if (this.isEnabled(cat)) {
            this.emit(null, 0L, null, ITracer.Phase.E, tid, null);
        }
    }

    @Override
    public void durationE(long cat, long tid, String args) {
        if (this.isEnabled(cat)) {
            this.emit(null, 0L, null, ITracer.Phase.E, tid, args);
        }
    }

    @Override
    public void durationE(long cat, long tid, Supplier<String> args) {
        if (this.isEnabled(cat)) {
            this.emit(null, 0L, null, ITracer.Phase.E, tid, args.get());
        }
    }

    @Override
    public void instant(String name, long cat, ITracer.Scope scope) {
        if (this.isEnabled(cat)) {
            this.emit(name, cat, scope, ITracer.Phase.i, Thread.currentThread().getId(), null);
        }
    }

    @Override
    public void instant(String name, long cat, ITracer.Scope scope, String args) {
        if (this.isEnabled(cat)) {
            this.emit(name, cat, scope, ITracer.Phase.i, Thread.currentThread().getId(), args);
        }
    }

    @Override
    public void instant(String name, long cat, ITracer.Scope scope, Supplier<String> args) {
        if (this.isEnabled(cat)) {
            this.emit(name, cat, scope, ITracer.Phase.i, Thread.currentThread().getId(), args.get());
        }
    }

    private long emitDurationB(String name, long cat, String args) {
        Event e = Event.create(name, cat, ITracer.Phase.B, PID, Thread.currentThread().getId(), null, args, this.getRegistry());
        this.traceLog.log(TRACE_LOG_LEVEL, e.toJson());
        return e.tid;
    }

    private void emit(String name, long cat, ITracer.Scope scope, ITracer.Phase i, long tid, String args) {
        Event e = Event.create(name, cat, i, PID, tid, scope, args, this.getRegistry());
        this.traceLog.log(TRACE_LOG_LEVEL, e.toJson());
    }
}

