/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.om.base.temporal.DateTimeFormatUtils;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringWriter;

@MissingNullInOutFunction
public class PrintDateTimeDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = PrintDateTimeDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable argPtr0 = new VoidPointable();
                    private IPointable argPtr1 = new VoidPointable();
                    private IScalarEvaluator eval0;
                    private IScalarEvaluator eval1;
                    private StringBuilder sbder;
                    private UTF8StringWriter utf8Writer;
                    private UTF8StringPointable utf8Ptr;
                    private final DateTimeFormatUtils util;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.sbder = new StringBuilder();
                        this.utf8Writer = new UTF8StringWriter();
                        this.utf8Ptr = new UTF8StringPointable();
                        this.util = DateTimeFormatUtils.getInstance();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.argPtr0);
                        this.eval1.evaluate(tuple, this.argPtr1);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr0, this.argPtr1)) {
                            return;
                        }
                        byte[] bytes0 = this.argPtr0.getByteArray();
                        int offset0 = this.argPtr0.getStartOffset();
                        byte[] bytes1 = this.argPtr1.getByteArray();
                        int offset1 = this.argPtr1.getStartOffset();
                        int len1 = this.argPtr1.getLength();
                        try {
                            if (bytes0[offset0] != ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                                throw new TypeMismatchException(PrintDateTimeDescriptor.this.sourceLoc, PrintDateTimeDescriptor.this.getIdentifier(), 0, bytes0[offset0], ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                            }
                            if (bytes1[offset1] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                throw new TypeMismatchException(PrintDateTimeDescriptor.this.sourceLoc, PrintDateTimeDescriptor.this.getIdentifier(), 1, bytes1[offset1], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            long chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                            this.utf8Ptr.set(bytes1, offset1 + 1, len1 - 1);
                            int formatLength = this.utf8Ptr.getUTF8Length();
                            this.sbder.delete(0, this.sbder.length());
                            this.util.printDateTime(chronon, this.utf8Ptr.getByteArray(), this.utf8Ptr.getCharStartOffset(), formatLength, (Appendable)this.sbder, DateTimeFormatUtils.DateTimeParseMode.DATETIME);
                            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            this.utf8Writer.writeUTF8((CharSequence)this.sbder, this.out);
                        }
                        catch (IOException ex) {
                            throw HyracksDataException.create((Throwable)ex);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.PRINT_DATETIME;
    }
}

