/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.writer;

import java.io.Serializable;
import java.io.UTFDataFormatException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.writer.AbstractPathResolver;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8CharBuffer;
import org.apache.hyracks.util.string.UTF8StringUtil;

final class DynamicPathResolver
extends AbstractPathResolver {
    private final IScalarEvaluator pathEval;
    private final IWarningCollector warningCollector;
    private final StringBuilder dirStringBuilder;
    private final VoidPointable pathResult;
    private final UTF8CharBuffer charBuffer;
    private final SourceLocation pathSourceLocation;

    DynamicPathResolver(String fileExtension, char fileSeparator, int partition, IScalarEvaluator pathEval, IWarningCollector warningCollector, SourceLocation pathSourceLocation) {
        super(fileExtension, fileSeparator, partition);
        this.pathEval = pathEval;
        this.warningCollector = warningCollector;
        this.pathSourceLocation = pathSourceLocation;
        this.dirStringBuilder = new StringBuilder();
        this.pathResult = new VoidPointable();
        this.charBuffer = new UTF8CharBuffer();
    }

    @Override
    public String getPartitionDirectory(IFrameTupleReference tuple) throws HyracksDataException {
        if (!this.appendPrefix(tuple)) {
            return "UNRESOLVABLE_PATH";
        }
        if (this.dirStringBuilder.length() > 0 && this.dirStringBuilder.charAt(this.dirStringBuilder.length() - 1) != this.fileSeparator) {
            this.dirStringBuilder.append(this.fileSeparator);
        }
        return this.dirStringBuilder.toString();
    }

    private boolean appendPrefix(IFrameTupleReference tuple) throws HyracksDataException {
        this.dirStringBuilder.setLength(0);
        this.pathEval.evaluate(tuple, (IPointable)this.pathResult);
        ATypeTag typeTag = ATypeTag.VALUE_TYPE_MAPPING[this.pathResult.getByteArray()[0]];
        if (typeTag != ATypeTag.STRING) {
            if (this.warningCollector.shouldWarn()) {
                this.warningCollector.warn(Warning.of((SourceLocation)this.pathSourceLocation, (IError)ErrorCode.NON_STRING_WRITE_PATH, (Serializable[])new Serializable[]{typeTag}));
            }
            return false;
        }
        try {
            UTF8StringUtil.readUTF8((byte[])this.pathResult.getByteArray(), (int)(this.pathResult.getStartOffset() + 1), (UTF8CharBuffer)this.charBuffer);
        }
        catch (UTFDataFormatException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        this.dirStringBuilder.append(this.charBuffer.getBuffer(), 0, this.charBuffer.getFilledLength());
        return true;
    }
}

