/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class OperatorUtils {
    public static void createDistinctOpsForJoinNodes(ILogicalOperator op, Pair<List<LogicalVariable>, List<AbstractFunctionCallExpression>> distinctVarsFuncPair, IOptimizationContext context, HashMap<DataSourceScanOperator, ILogicalOperator> scanAndDistinctOps) {
        List distinctVars = (List)distinctVarsFuncPair.getFirst();
        List distinctFunctions = (List)distinctVarsFuncPair.getSecond();
        if (op == null || distinctVars.size() == 0) {
            return;
        }
        ArrayList<LogicalVariable> foundDistinctVars = new ArrayList<LogicalVariable>();
        DataSourceScanOperator selOp = null;
        DataSourceScanOperator assignOp = null;
        ILogicalOperator currentOp = op;
        LogicalOperatorTag tag = currentOp.getOperatorTag();
        if (tag == LogicalOperatorTag.INNERJOIN || tag == LogicalOperatorTag.LEFTOUTERJOIN) {
            for (int i = 0; i < currentOp.getInputs().size(); ++i) {
                ILogicalOperator nextOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(i)).getValue();
                OperatorUtils.createDistinctOpsForJoinNodes(nextOp, distinctVarsFuncPair, context, scanAndDistinctOps);
            }
        } else {
            SourceLocation sourceLocation;
            DataSourceScanOperator inputOp;
            DistinctOperator distinctOp;
            DataSourceScanOperator scanOp = null;
            while (tag != LogicalOperatorTag.EMPTYTUPLESOURCE) {
                if (tag == LogicalOperatorTag.SELECT) {
                    ILogicalOperator nextOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
                    if ((nextOp.getOperatorTag() == LogicalOperatorTag.ASSIGN || nextOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) && selOp == null && assignOp == null) {
                        selOp = currentOp;
                    }
                } else if (tag == LogicalOperatorTag.ASSIGN) {
                    LogicalVariable assignVar = (LogicalVariable)((AssignOperator)currentOp).getVariables().get(0);
                    int idx = distinctVars.indexOf(assignVar);
                    if (idx != -1 && assignOp == null) {
                        assignOp = currentOp;
                    }
                    if (idx != -1) {
                        foundDistinctVars.add(assignVar);
                    }
                } else if (tag == LogicalOperatorTag.DATASOURCESCAN) {
                    scanOp = (DataSourceScanOperator)currentOp;
                    List scanVars = scanOp.getVariables();
                    for (LogicalVariable scanVar : scanVars) {
                        if (!distinctVars.contains(scanVar)) continue;
                        foundDistinctVars.add(scanVar);
                    }
                    if (foundDistinctVars.size() == 0) {
                        scanOp = null;
                    }
                } else if (tag == LogicalOperatorTag.GROUP) {
                    List nestedGrpVarsList = ((GroupByOperator)currentOp).getGroupByList();
                    for (int i = 0; i < nestedGrpVarsList.size(); ++i) {
                        ILogicalExpression expr;
                        LogicalVariable prevVar = (LogicalVariable)((Pair)nestedGrpVarsList.get((int)i)).first;
                        int idx = distinctVars.indexOf(prevVar);
                        if (idx == -1 || distinctVars.size() <= 0 || (expr = (ILogicalExpression)((Mutable)((Pair)nestedGrpVarsList.get((int)i)).second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                        LogicalVariable newVar = ((VariableReferenceExpression)expr).getVariableReference();
                        distinctVars.remove(idx);
                        distinctVars.add(newVar);
                        for (AbstractFunctionCallExpression funcExpr : distinctFunctions) {
                            OperatorUtils.replaceVariableInFunction(funcExpr, prevVar, newVar);
                        }
                    }
                } else if (tag == LogicalOperatorTag.INNERJOIN || tag == LogicalOperatorTag.LEFTOUTERJOIN) {
                    for (int i = 0; i < currentOp.getInputs().size(); ++i) {
                        ILogicalOperator nextOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(i)).getValue();
                        OperatorUtils.createDistinctOpsForJoinNodes(nextOp, distinctVarsFuncPair, context, scanAndDistinctOps);
                    }
                    break;
                }
                currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
                tag = currentOp.getOperatorTag();
            }
            if (scanOp != null && (distinctOp = OperatorUtils.createDistinctOp(foundDistinctVars, (ILogicalOperator)(inputOp = selOp != null ? selOp : (assignOp != null ? assignOp : scanOp)), sourceLocation = inputOp.getSourceLocation(), distinctFunctions, context)) != null) {
                scanAndDistinctOps.put(scanOp, (ILogicalOperator)distinctOp);
            }
        }
    }

    private static void replaceVariableInFunction(AbstractFunctionCallExpression funcExpr, LogicalVariable prevVar, LogicalVariable newVar) {
        List argList = funcExpr.getArguments();
        for (Mutable arg : argList) {
            if (((ILogicalExpression)arg.getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                if (!prevVar.equals((Object)((VariableReferenceExpression)arg.getValue()).getVariableReference())) continue;
                ((ILogicalExpression)arg.getValue()).substituteVar(prevVar, newVar);
                continue;
            }
            if (((ILogicalExpression)arg.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            OperatorUtils.replaceVariableInFunction((AbstractFunctionCallExpression)arg.getValue(), prevVar, newVar);
        }
    }

    private static List<LogicalVariable> getFunctionVariables(AbstractFunctionCallExpression funcExpr) {
        ArrayList<LogicalVariable> variables = new ArrayList<LogicalVariable>();
        List argList = funcExpr.getArguments();
        for (Mutable arg : argList) {
            if (((ILogicalExpression)arg.getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                variables.add(((VariableReferenceExpression)arg.getValue()).getVariableReference());
                continue;
            }
            if (((ILogicalExpression)arg.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            variables.addAll(OperatorUtils.getFunctionVariables((AbstractFunctionCallExpression)arg.getValue()));
        }
        return variables;
    }

    public static Pair<List<LogicalVariable>, List<AbstractFunctionCallExpression>> getGroupByDistinctVarFuncPair(ILogicalOperator grpByDistinctOp) {
        Pair distinctVarsFunctions;
        block10: {
            List distinctFunctions;
            List distinctVars;
            block11: {
                distinctVarsFunctions = new Pair(new ArrayList(), new ArrayList());
                distinctVars = (List)distinctVarsFunctions.getFirst();
                distinctFunctions = (List)distinctVarsFunctions.getSecond();
                if (grpByDistinctOp == null) {
                    return distinctVarsFunctions;
                }
                if (grpByDistinctOp.getOperatorTag() != LogicalOperatorTag.DISTINCT) break block11;
                ILogicalExpression distinctExpr = (ILogicalExpression)((Mutable)((DistinctOperator)grpByDistinctOp).getExpressions().get(0)).getValue();
                if (distinctExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) break block10;
                distinctVars.add(((VariableReferenceExpression)distinctExpr).getVariableReference());
                ILogicalOperator nextOp = (ILogicalOperator)((Mutable)grpByDistinctOp.getInputs().get(0)).getValue();
                while (nextOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                    LogicalVariable assignVar = (LogicalVariable)((AssignOperator)nextOp).getVariables().get(0);
                    if (assignVar.equals((Object)((VariableReferenceExpression)distinctExpr).getVariableReference())) {
                        assert (distinctVars.size() == 1);
                        distinctVars.remove(0);
                        ILogicalExpression assignExpr = (ILogicalExpression)((Mutable)((AssignOperator)nextOp).getExpressions().get(0)).getValue();
                        if (assignExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) break block10;
                        List argList = ((AbstractFunctionCallExpression)assignExpr).getArguments();
                        for (int i = 0; i < argList.size(); i += 2) {
                            ILogicalExpression varRef = (ILogicalExpression)((Mutable)argList.get(i + 1)).getValue();
                            if (varRef.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                                distinctVars.add(((VariableReferenceExpression)varRef).getVariableReference());
                                continue;
                            }
                            if (varRef.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                            distinctVars.addAll(OperatorUtils.getFunctionVariables((AbstractFunctionCallExpression)varRef));
                            distinctFunctions.add((AbstractFunctionCallExpression)varRef.cloneExpression());
                        }
                        break block10;
                    }
                    nextOp = (ILogicalOperator)((Mutable)nextOp.getInputs().get(0)).getValue();
                }
                break block10;
            }
            if (grpByDistinctOp.getOperatorTag() == LogicalOperatorTag.GROUP) {
                distinctVars.addAll(((GroupByOperator)grpByDistinctOp).getGroupByVarList());
                ILogicalOperator nextOp = (ILogicalOperator)((Mutable)grpByDistinctOp.getInputs().get(0)).getValue();
                LogicalOperatorTag tag = nextOp.getOperatorTag();
                while (tag != LogicalOperatorTag.DATASOURCESCAN && tag != LogicalOperatorTag.INNERJOIN && tag != LogicalOperatorTag.LEFTOUTERJOIN) {
                    ILogicalExpression assignExpr;
                    if (tag == LogicalOperatorTag.ASSIGN && (assignExpr = (ILogicalExpression)((Mutable)((AssignOperator)nextOp).getExpressions().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                        List<LogicalVariable> fVars = OperatorUtils.getFunctionVariables((AbstractFunctionCallExpression)assignExpr);
                        LogicalVariable assignVar = (LogicalVariable)((AssignOperator)nextOp).getVariables().get(0);
                        int idx = distinctVars.indexOf(assignVar);
                        if (idx != -1 && fVars.size() > 0) {
                            distinctVars.remove(idx);
                            distinctVars.addAll(fVars);
                            distinctFunctions.add((AbstractFunctionCallExpression)assignExpr.cloneExpression());
                        }
                    }
                    nextOp = (ILogicalOperator)((Mutable)nextOp.getInputs().get(0)).getValue();
                    tag = nextOp.getOperatorTag();
                }
            }
        }
        return distinctVarsFunctions;
    }

    private static AssignOperator createAssignOpForFunctionExpr(IOptimizationContext optCtx, List<LogicalVariable> distinctVars, List<AbstractFunctionCallExpression> funcExpr, SourceLocation sourceLocation) {
        int counter = 1;
        ArrayList<LogicalVariable> notFoundDistinctVars = new ArrayList<LogicalVariable>(distinctVars);
        ArrayList<MutableObject> openRecConsArgs = new ArrayList<MutableObject>();
        for (AbstractFunctionCallExpression expr : funcExpr) {
            List<LogicalVariable> funcVars = OperatorUtils.getFunctionVariables(expr);
            if (!new HashSet<LogicalVariable>(distinctVars).containsAll(funcVars)) continue;
            openRecConsArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(String.valueOf(counter))))));
            openRecConsArgs.add(new MutableObject((Object)expr));
            ++counter;
            notFoundDistinctVars.removeAll(funcVars);
        }
        if (openRecConsArgs.size() > 0) {
            for (LogicalVariable var : notFoundDistinctVars) {
                openRecConsArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(String.valueOf(counter))))));
                openRecConsArgs.add(new MutableObject((Object)new VariableReferenceExpression(var)));
                ++counter;
            }
            ScalarFunctionCallExpression openRecFunc = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR), openRecConsArgs);
            LogicalVariable assignVar = optCtx.newVar();
            AssignOperator assignOp = new AssignOperator(assignVar, (Mutable)new MutableObject((Object)openRecFunc));
            assignOp.setSourceLocation(sourceLocation);
            return assignOp;
        }
        return null;
    }

    private static DistinctOperator createDistinctOp(List<LogicalVariable> distinctVars, ILogicalOperator inputOp, SourceLocation sourceLocation, List<AbstractFunctionCallExpression> funcExpr, IOptimizationContext optCtx) {
        if (distinctVars.size() == 0 || inputOp == null) {
            return null;
        }
        LogicalOperatorTag tag = inputOp.getOperatorTag();
        if (tag != LogicalOperatorTag.ASSIGN && tag != LogicalOperatorTag.SELECT && tag != LogicalOperatorTag.DATASOURCESCAN) {
            return null;
        }
        AssignOperator assignOp = OperatorUtils.createAssignOpForFunctionExpr(optCtx, distinctVars, funcExpr, sourceLocation);
        ArrayList<MutableObject> distinctExpr = new ArrayList<MutableObject>();
        if (assignOp == null) {
            for (LogicalVariable var : distinctVars) {
                VariableReferenceExpression varExpr = new VariableReferenceExpression(var);
                varExpr.setSourceLocation(sourceLocation);
                distinctExpr.add(new MutableObject((Object)varExpr));
            }
        } else {
            VariableReferenceExpression varExpr = new VariableReferenceExpression((LogicalVariable)assignOp.getVariables().get(0));
            varExpr.setSourceLocation(sourceLocation);
            distinctExpr.add(new MutableObject((Object)varExpr));
        }
        DistinctOperator distinctOp = new DistinctOperator(distinctExpr);
        distinctOp.setSourceLocation(sourceLocation);
        if (assignOp == null) {
            distinctOp.getInputs().add(new MutableObject((Object)inputOp));
        } else {
            distinctOp.getInputs().add(new MutableObject((Object)assignOp));
            ILogicalOperator nextOp = (ILogicalOperator)((Mutable)distinctOp.getInputs().get(0)).getValue();
            nextOp.getInputs().add(new MutableObject((Object)inputOp));
        }
        distinctOp.setExecutionMode(inputOp.getExecutionMode());
        return distinctOp;
    }
}

