/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.aggreg;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.evaluators.EvaluatorContext;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class AggregatePushRuntime
extends AbstractOneInputOneOutputOneFramePushRuntime {
    private final IAggregateEvaluatorFactory[] aggFactories;
    private final IEvaluatorContext ctx;
    private IAggregateEvaluator[] aggEvals;
    private IPointable result;
    private ArrayTupleBuilder tupleBuilder;
    private boolean first;

    AggregatePushRuntime(IAggregateEvaluatorFactory[] aggFactories, IHyracksTaskContext ctx) {
        this.aggFactories = aggFactories;
        this.ctx = new EvaluatorContext(ctx);
        this.aggEvals = new IAggregateEvaluator[aggFactories.length];
        this.result = VoidPointable.FACTORY.createPointable();
        this.tupleBuilder = new ArrayTupleBuilder(this.aggEvals.length);
        this.first = true;
    }

    @Override
    public void open() throws HyracksDataException {
        int i;
        if (this.first) {
            this.first = false;
            this.initAccessAppendRef(this.ctx.getTaskContext());
            for (i = 0; i < this.aggFactories.length; ++i) {
                this.aggEvals[i] = this.aggFactories[i].createAggregateEvaluator(this.ctx);
            }
        }
        for (i = 0; i < this.aggFactories.length; ++i) {
            this.aggEvals[i].init();
        }
        super.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.tAccess.reset(buffer);
        int nTuple = this.tAccess.getTupleCount();
        for (int t = 0; t < nTuple; ++t) {
            this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
            this.processTuple(this.tRef);
        }
    }

    @Override
    public void close() throws HyracksDataException {
        if (this.isOpen) {
            try {
                this.finishAggregates(false);
            }
            finally {
                super.close();
            }
        }
    }

    public void finishAggregates(boolean flushFrame) throws HyracksDataException {
        this.tupleBuilder.reset();
        for (IAggregateEvaluator aggEval : this.aggEvals) {
            aggEval.finish(this.result);
            this.tupleBuilder.addField(this.result.getByteArray(), this.result.getStartOffset(), this.result.getLength());
        }
        this.appendToFrameFromTupleBuilder(this.tupleBuilder, flushFrame);
    }

    private void processTuple(FrameTupleReference tupleRef) throws HyracksDataException {
        for (IAggregateEvaluator aggEval : this.aggEvals) {
            aggEval.step((IFrameTupleReference)tupleRef);
        }
    }
}

