/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigValueAtContainer;
import org.apache.brooklyn.util.guava.Maybe;

public class LazyContainerAndKeyValue<TContainer, TValue>
implements ConfigValueAtContainer<TContainer, TValue> {
    @Nullable
    private final TContainer container;
    @Nullable
    private final ConfigKey<TValue> key;
    private final Function<TContainer, Maybe<Object>> lookupResolutionFunction;
    private final Function<Maybe<Object>, Maybe<TValue>> conversionFunction;
    private Maybe<TValue> resolved;

    public LazyContainerAndKeyValue(@Nullable ConfigKey<TValue> key, @Nullable TContainer container, Function<TContainer, Maybe<Object>> lookupResolutionFunction, Function<Maybe<Object>, Maybe<TValue>> conversionFunction) {
        this.key = key;
        this.container = container;
        this.lookupResolutionFunction = (Function)Preconditions.checkNotNull(lookupResolutionFunction);
        this.conversionFunction = (Function)Preconditions.checkNotNull(conversionFunction);
    }

    protected synchronized Maybe<TValue> resolve() {
        if (this.resolved == null) {
            this.resolved = (Maybe)this.conversionFunction.apply(this.lookupResolutionFunction.apply(this.getContainer()));
        }
        return this.resolved;
    }

    public TContainer getContainer() {
        return this.container;
    }

    public TValue get() {
        if (this.resolve().isPresent()) {
            return (TValue)this.resolve().get();
        }
        return (TValue)this.getDefaultValue().orNull();
    }

    public Maybe<TValue> asMaybe() {
        if (this.resolve().isPresent()) {
            return this.resolve();
        }
        return this.getDefaultValue();
    }

    public boolean isValueExplicitlySet() {
        return this.resolve().isPresent();
    }

    public ConfigKey<TValue> getKey() {
        return this.key;
    }

    public Maybe<TValue> getDefaultValue() {
        if (this.key == null || !this.key.hasDefaultValue()) {
            return Maybe.absent();
        }
        return (Maybe)this.conversionFunction.apply((Object)Maybe.of((Object)this.key.getDefaultValue()));
    }

    public String toString() {
        return super.toString() + "[key=" + this.key + "; container=" + this.container + "]";
    }
}

