/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticSensor<T>
extends AddSensor<T> {
    private static final Logger log = LoggerFactory.getLogger(StaticSensor.class);
    public static final ConfigKey<Object> STATIC_VALUE = ConfigKeys.newConfigKey(Object.class, "static.value");
    public static final ConfigKey<Duration> TIMEOUT = ConfigKeys.newConfigKey(Duration.class, "static.timeout", "Duration to wait for the value to resolve", Duration.PRACTICALLY_FOREVER);
    private final Object value;
    private final Duration timeout;

    public StaticSensor(ConfigBag params) {
        super(params);
        this.value = params.get(STATIC_VALUE);
        this.timeout = params.get(TIMEOUT);
    }

    @Override
    public void apply(final EntityLocal entity) {
        super.apply(entity);
        class ResolveValue
        implements Callable<Maybe<T>> {
            ResolveValue() {
            }

            @Override
            public Maybe<T> call() throws Exception {
                return Tasks.resolving(StaticSensor.this.value).as(StaticSensor.this.sensor.getTypeToken()).timeout(StaticSensor.this.timeout).getMaybe();
            }
        }
        final Task resolveValue = Tasks.builder().displayName("resolving " + this.value).body(new ResolveValue()).build();
        class SetValue
        implements Callable<T> {
            SetValue() {
            }

            @Override
            public T call() throws Exception {
                Maybe v = (Maybe)resolveValue.get();
                if (!v.isPresent()) {
                    log.debug(this + " not setting sensor " + StaticSensor.this.sensor + " on " + entity + "; cannot resolve " + StaticSensor.this.value + " after timeout " + StaticSensor.this.timeout);
                    return null;
                }
                log.debug(this + " setting sensor " + StaticSensor.this.sensor + " to " + v.get() + " on " + entity);
                return entity.sensors().set(StaticSensor.this.sensor, v.get());
            }
        }
        Task setValue = Tasks.builder().displayName("Setting " + this.sensor + " on " + entity).body(new SetValue()).build();
        Entities.submit((Entity)entity, Tasks.sequential("Resolving and setting " + this.sensor + " on " + entity, new TaskAdaptable[]{resolveValue, setValue}));
    }
}

