/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.KillCursorsMessage;
import com.mongodb.connection.Protocol;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import java.util.List;

class KillCursorProtocol
implements Protocol<Void> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.killcursor");
    private final List<Long> cursors;

    public KillCursorProtocol(List<Long> cursors) {
        this.cursors = cursors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Killing cursors [%s] on connection [%s] to server %s", this.getCursorIdListAsString(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
        try {
            KillCursorsMessage message = new KillCursorsMessage(this.cursors);
            message.encode(bsonOutput);
            connection.sendMessage(bsonOutput.getByteBuffers(), message.getId());
            Void void_ = null;
            return void_;
        }
        finally {
            bsonOutput.close();
        }
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<Void> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously killing cursors [%s] on connection [%s] to server %s", this.getCursorIdListAsString(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            final ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            KillCursorsMessage message = new KillCursorsMessage(this.cursors);
            message.encode(bsonOutput);
            connection.sendMessageAsync(bsonOutput.getByteBuffers(), message.getId(), new SingleResultCallback<Void>(){

                @Override
                public void onResult(Void result, Throwable t) {
                    bsonOutput.close();
                    callback.onResult(result, t);
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    private String getCursorIdListAsString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.cursors.size(); ++i) {
            Long cursor = this.cursors.get(i);
            builder.append(cursor);
            if (i >= this.cursors.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

