/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import org.apache.cayenne.modeler.undo.JComboBoxUndoListener;
import org.apache.cayenne.modeler.util.CayenneCellEditor;
import org.apache.cayenne.modeler.util.JEditTextAreaUndoable;
import org.apache.cayenne.modeler.util.WidgetFactory;
import org.apache.cayenne.modeler.util.combo.ComboBoxCellEditor;
import org.syntax.jedit.JEditTextArea;

public class DefaultWidgetFactory
implements WidgetFactory {
    @Override
    public JComboBox<String> createComboBox(Collection<String> model, boolean sort) {
        return this.createComboBox((T[])model.toArray(new String[0]), sort);
    }

    public <T> JComboBox<T> createComboBox(T[] model, boolean sort) {
        JComboBox<T> comboBox = this.createComboBox();
        if (sort) {
            Arrays.sort(model);
        }
        comboBox.setModel(new DefaultComboBoxModel<T>(model));
        return comboBox;
    }

    public <T> JComboBox<T> createComboBox() {
        JComboBox comboBox = new JComboBox();
        comboBox.setFont(UIManager.getFont("Label.font"));
        comboBox.setBackground(Color.WHITE);
        comboBox.setMaximumRowCount(12);
        return comboBox;
    }

    public <T> JComboBox<T> createUndoableComboBox() {
        JComboBox comboBox = new JComboBox();
        comboBox.addItemListener(new JComboBoxUndoListener());
        comboBox.setBackground(Color.WHITE);
        comboBox.setMaximumRowCount(12);
        return comboBox;
    }

    @Override
    public DefaultCellEditor createCellEditor(JTextField textField) {
        textField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        return new CayenneCellEditor(textField);
    }

    @Override
    public TableCellEditor createCellEditor(JComboBox<?> combo) {
        combo.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        if (Boolean.TRUE.equals(combo.getClientProperty("JComboBox.autoCompletion"))) {
            return new ComboBoxCellEditor(combo);
        }
        DefaultCellEditor editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(1);
        return editor;
    }

    @Override
    public JEditTextArea createJEditTextArea() {
        return new JEditTextAreaUndoable();
    }
}

