/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.jdom;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.jdom.JDOMNodePointer;
import org.apache.commons.jxpath.util.TypeUtils;
import org.jdom.Attribute;

public class JDOMAttributePointer
extends NodePointer {
    private static final long serialVersionUID = 8896050354479644028L;
    private final Attribute attribute;

    public JDOMAttributePointer(NodePointer parent, Attribute attribute) {
        super(parent);
        this.attribute = attribute;
    }

    @Override
    public String asPath() {
        StringBuilder buffer = new StringBuilder();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
        }
        buffer.append('@');
        buffer.append(this.getName());
        return buffer.toString();
    }

    @Override
    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof JDOMAttributePointer && ((JDOMAttributePointer)object).attribute == this.attribute;
    }

    @Override
    public Object getBaseValue() {
        return this.attribute;
    }

    @Override
    public Object getImmediateNode() {
        return this.attribute;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public QName getName() {
        return new QName(JDOMNodePointer.getPrefix(this.attribute), JDOMNodePointer.getLocalName(this.attribute));
    }

    @Override
    public String getNamespaceURI() {
        String uri = this.attribute.getNamespaceURI();
        if (uri != null && uri.isEmpty()) {
            uri = null;
        }
        return uri;
    }

    @Override
    public Object getValue() {
        return this.attribute.getValue();
    }

    public int hashCode() {
        return System.identityHashCode(this.attribute);
    }

    @Override
    public boolean isActual() {
        return true;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void remove() {
        this.attribute.getParent().removeAttribute(this.attribute);
    }

    @Override
    public void setValue(Object value) {
        this.attribute.setValue((String)TypeUtils.convert(value, String.class));
    }
}

