/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class MarsagliaNormalizedGaussianSampler
implements NormalizedGaussianSampler,
SharedStateContinuousSampler {
    private double nextGaussian = Double.NaN;
    private final UniformRandomProvider rng;

    public MarsagliaNormalizedGaussianSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    @Override
    public double sample() {
        if (Double.isNaN(this.nextGaussian)) {
            double y;
            double x;
            double r2;
            while (!((r2 = (x = 2.0 * this.rng.nextDouble() - 1.0) * x + (y = 2.0 * this.rng.nextDouble() - 1.0) * y) < 1.0) || !(r2 > 0.0)) {
            }
            double alpha = Math.sqrt(-2.0 * Math.log(r2) / r2);
            this.nextGaussian = alpha * y;
            return alpha * x;
        }
        double r = this.nextGaussian;
        this.nextGaussian = Double.NaN;
        return r;
    }

    public String toString() {
        return "Box-Muller (with rejection) normalized Gaussian deviate [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new MarsagliaNormalizedGaussianSampler(rng);
    }

    public static <S extends NormalizedGaussianSampler & SharedStateContinuousSampler> S of(UniformRandomProvider rng) {
        return (S)new MarsagliaNormalizedGaussianSampler(rng);
    }
}

